#ifndef GENERAL_H
#define GENERAL_H

#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdarg.h>
#include <signal.h>
#include <syslog.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include "global.h"
#include "rsaref.h"
#include "parse.h"
#include "arcfour.h"
#include "sockatmark.h"
#include "oob_queue.h"
#include "dh.h"
#include "base64.h"
#include "crypto.h"
#include "probe.h"
#include "control.h"
#include "parse.h"
#include "init.h"
#include "probe.h"
#include "connection.h"
#include "io.h"
#include "error.h"

#define	DEFAULT_PORT	6789

#define VERSION			"0.2"
#define LISTEN_PORT             6789
#define MAX_CONNECT             30
#define TIMEOUT                 10      /* 10 seconds time out for client to send conninit structure */
#define PUBLIC_KEY_FILE         "Server.pub"

#if defined(IRIX) || defined(SOLARIS)
#define socklen_t       int
#endif

#define MAX(x, y)       ((x) > (y) ? (x) : (y))
#define MIN(x, y)       ((x) < (y) ? (x) : (y))

#ifdef SVR4
 typedef int     socklen_t;
 #define isblank __isblank
#endif


extern Connection *conn;
extern int h_errno;
extern int conn_size, maxfd, debug, sndbufsz;
extern int timeout;
extern conninit *cntrl;
extern int cntrl_num;
extern int skip_ok, probe_all;
extern int verbose;
extern int daemon_proc;
extern int skip_verification;
extern fd_set rdset, wrset;
extern struct in_addr proxyhost;
extern short proxyport;
extern R_RSA_PUBLIC_KEY ServerPublicKey;

#endif
