#ifndef CONNECTION_H
#define CONNECTION_H

#define ST_NOTUSED	0	/* Entry avaiable 			*/
#define ST_INPROGR	1	/* Connecting to remote proxy           */
#define ST_DHSEND1	2	/* Sending DH data to proxy		*/
#define ST_DHRECV1	3	/* Receiving DH data from proxy 	*/
#define ST_DHSEND2	4	/* Sending DH data to endpoint		*/
#define ST_DHRECV2	5	/* Receiving DH data from endpoint	*/
#define ST_SENDINF	6	/* Sending out control data for proxies */
#define	ST_CONNECT	7	/* Both sides connected 		*/
#define ST_FINISHL	8	/* Client closed the connection, but there is still data to write to the proxy */
#define ST_FINISHR	9	/* Proxy closed the connection, but there is still data to write to the client */

#define IS_ST_TIMEOUT(c)	(((c).status == ST_DHSEND1) || ((c).status == ST_DHRECV1) || ((c).status == ST_DHSEND2) || \
				((c).status == ST_DHRECV2))
#define IS_ST_PROCESS(c)	(((c).status == ST_CONNECT) || ((c).status == ST_FINISHL) || ((c).status == ST_FINISHR))

#define FOR_NORMAL	0
#define FOR_ENDPOINT	1

#define MAGIC		0x4145534f	/* "AESO" */

#define	EOF_LOCAL	0	/* Client EOF for Connection_eof()	*/
#define EOF_REMOT	1	/* Destination EOF for Connection_eof()	*/

/* Control codes for proxy per structure */
#define CNTRL_ALONE	1	/* Standalone mode 			*/
#define CNTRL_CHAIN	2	/* Part of chain			*/
#define CNTRL_ENDPO	4	/* Endpoint				*/
#define CNTRL_DEBUG	8	/* Debug mode (undefined as of now)	*/
#define CNTRL_INET6	16	/* IPv6 Address				*/

#ifndef __GNUC__
 #pragma pack(1)
#endif
typedef struct _conninit {
   uint32_t     magic;          /* Magic Number: "AESO" in network order */
   uint8_t      targetip[16];   /* Network Order */
   uint16_t     targetport;     /* Network Order */
   uint16_t     control;        /* Control codes for proxy in network order */
#ifndef __GNUC__
 } conninit;
 #pragma pack(0)
#else
 } __attribute__ ((packed)) conninit;
#endif

typedef struct connection {
   int localfd;		/* FD representing user-tunnel link */
   int remotefd;	/* FD representing tunnel-proxy link */
   int status;
   unsigned char *lbuf;	/* Read buffer for localfd */
   unsigned char *rbuf;	/* Read buffer for remotefd */
   int lpos;		/* Read position in localfd read buffer */
   int rpos;		/* Read position in remotefd read buffer */
   int *l_oobpos;       /* Array of positions of eventual Out of Bandage databyte in lbuf */
   int l_oobsize;       /* Number of elements in Array l_oobpos */
   int l_oobused;       /* Number of elements used in array l_oobpos */
   int *r_oobpos;       /* Array of position of eventual Out of Bandage databyte in rbuf */
   int r_oobsize;       /* Number of elements in Array r_oobpos */
   int r_oobused;       /* Number of elements used in array r_oobpos */
   struct DHData *dh;	/* Temporary DH structure */
   ArcfourContext e;	/* RC4 context used for encryption */ 
   ArcfourContext d;	/* RC4 context used for decryption */
   ArcfourContext e2;	/* 2nd RC4 context for encryption with endpoint */
   ArcfourContext d2;	/* 2nd RC4 context for decryption with endpoint */
} Connection;

void Connection_alloc(void);
int Connection_add(int localfd);
void Connection_del(Connection *con);
void Connection_connect(Connection *con);
void Connection_DH_init(Connection *con, int with);
void Connection_DH_senddata(Connection *con);
void Connection_DH_readdata(Connection *con);
void Connection_DH_process(Connection *con, int with);
void Connection_initinfo(Connection *con);
void Connection_sendinfo(Connection *con);
void Connection_eof(Connection *con, int who);

#endif
