#ifndef GENERAL_H
#define GENERAL_H

#include "sysdeps.h"
#include "aesop.h"
#include "defaults.h"

#ifndef have_socklen_t
 typedef int socklen_t;
#endif

#ifndef have_isblank
 #define isblank(c)	(((c) == ' ') || ((c) == '\t'))
#endif

#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#include <syslog.h>
#include <signal.h>
#include <sys/param.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include "global.h"
#include "rsaref.h"
#include "rsa.h"
#include "base64.h"
#include "crypto.h"
#include "arcfour.h"
#include "sockatmark.h"
#include "oob_queue.h"
#include "netwrap.h"
#include "error.h"
#include "dh.h"

#include "compat.h"

#define VERSION                 "0.4"

#ifndef MAX
 #define MAX(x, y)       ((x) > (y) ? (x) : (y))
#endif
#ifndef MIN
 #define MIN(x, y)       ((x) < (y) ? (x) : (y))
#endif

#ifndef SHUT_RD
 #define SHUT_RD 0
#endif

extern int h_errno;
extern int debug;
extern int daemon_proc;
extern char *seedfile;

#endif
