#include "aesoptunnel.h"

int initialise(int argc, char **argv) {
   char *file = NULL, *label = NULL;
   char *keyfile = NULL;
   char *ptr;
   int o, sd, n = 0;
   long flags;

   opterr = 0;
   while((o = getopt(argc, argv, "?hvduisf:l:k:a:m:r:")) != EOF) {
      switch(o) {
	case '?':
	case 'h':
	   usage(argv[0]);
	   break;
	case 'v':
	   version();
	   break;
	case 'd':
#ifndef DEBUG
	   fprintf(stderr, "This aesoptunnel binary has not been built with debugging support\n");
	   exit(-1);
#else
	   debug++;
#endif
	   break;
	case 'u':
	   probe_all = 1;
	   break;
	case 'i':
	   skip_verification = 1;
	   break;
	case 's':
	   skip_ok = 1;
	   break;
	case 'f':
	   if(file)
	      err_quit("File already specified");
	   if((file = malloc(strlen(optarg)+1)) == NULL)
	      err_sys("Memory allocation error");
	   strcpy(file, optarg);
	   break;
	case 'l':
	   if(label)
	      err_quit("You can only specify one label");
	   if((label = malloc(strlen(optarg)+1)) == NULL)
	      err_sys("Memory allocation error");
	   strcpy(label, optarg);
	   break;
	case 'k':
	   if(keyfile)
	      err_quit("Public Keyfile already specified");
	   if((keyfile = malloc(strlen(optarg)+1)) == NULL)
	      err_sys("Memory allocation error");
	   strcpy(keyfile, optarg);
	   break;
	case 'a':
	   sp_port = atoi(optarg);
	   sp_spec = 1;
	   break;
	case 'm':
	   sp_port = atoi(optarg);
	   sp_spec = 2;
	   break;
	case 'r':
	   if((seedfile = malloc(strlen(optarg)+1)) == NULL)
	      err_sys("Memory allocation error");
	   strcpy(seedfile, optarg);
	   break;
	default:
	   fprintf(stderr, "Warning: invalid option %c\n", o);
	   usage(argv[0]);
	   break;
      }
   }

   if((argc - optind) < 1) {
      fprintf(stderr, "Error: Too few arguments\n");
      usage(argv[0]);
   } else if((argc - optind) > 3) {
      fprintf(stderr, "Error: Too many arguments\n");
      usage(argv[0]);
   } else if((argc - optind) == 1) {
      n = 0;
      need_desthdr = 1;
   } else {
      n = 1;
   }

   if(LoadPublicKey(keyfile ? keyfile : PUBLIC_KEY_FILE, &ServerPublicKey) != 0)
      exit(-1);         /* LoadPrivateKey prints error message */

   if((ptr = strchr(argv[optind+n], '#'))) {
      *ptr++ = '\0';
      sd = w_listen(argv[optind+n], ptr, SOCK_STREAM);
   } else
      sd = w_listen(NULL, argv[optind+n], SOCK_STREAM);

   if((flags = fcntl(sd, F_GETFL, 0)) == -1)
      err_sys("initialise: fcntl F_GETFL error");

   if(fcntl(sd, F_SETFL, flags | O_NONBLOCK) == -1)
      err_sys("initialise: fcntl F_SETFL error");

   if(!sndbufsz) {
      socklen_t optlen = sizeof(int);

      if(getsockopt(sd, SOL_SOCKET, SO_SNDBUF, &sndbufsz, &optlen))
	 err_sys("initialise: Can not get SO_SNDBUF");
   }

   if(!file)
      err_quit("No file specified");

   parse_file(file, label);

   if(n) {
      if((ptr = strchr(argv[optind], '#'))) {
	 *ptr++ = '\0';

	 add_proxy(argv[optind], atoi(ptr), 0);
      } else
	 add_proxy("127.0.0.1", atoi(argv[optind]), 0);

      proxy_final(1);
   } else {
      proxy_final(0);
   }

#ifdef IPV6
   {	/* Check if an actual IPv6 stack is present.	*/
      int sd2;
      if(((sd2 = socket(AF_INET6, SOCK_STREAM, 0)) == -1) && proxyhostlen == sizeof(struct sockaddr_in6))
	 err_quit("Error: Aesop has been built with IPv6 support, but there is no IPv6 stack available\n"
		  "       and the first proxy specified is an IPv6 host: aborting\n");
      close(sd2);
   }
#endif

   if(!debug) {
      if(fork()) {
	 exit(0);
      } else {
	 setsid();
	 openlog(argv[0], LOG_PID, LOG_USER);
	 daemon_proc = 1;
      }
   }

   free(file);
   free(label);

   signal(SIGPIPE, sigpipe);   

   return sd;
}

void sigpipe(int dummy) {
#ifdef DEBUG
   if(debug)
      err_msg("sigpipe: Got delivered a SIGPIPE");
#endif
   return;
}

void usage(char *name) {
   fprintf(stderr, "aesoptunnel: Client Tunnel for Aesop \n");
   fprintf(stderr, "usage: %s [options] [destinationhost[/v4|/v6]#]port [listenhost[/v4|/v6]#]port\n", name);
   fprintf(stderr, "       %s [options] [listenhost[/v4|/v6]#]port\n", name);
   fprintf(stderr, "where options are:\n");
   fprintf(stderr, "\t-h\t\t: Show this help.\n");
#ifdef DEBUG
   fprintf(stderr, "\t-d\t\t: Run the tunnel in debug mode.\n");
#endif
   fprintf(stderr, "\t-f file\t\t: Specify file to load routes from.\n");
   fprintf(stderr, "\t-l label\t: Specify the label for the chain, default: first label.\n");
   fprintf(stderr, "\t-k file\t\t: Specify the public key file of the proxy.\n");
   fprintf(stderr, "\t-i\t\t: Ignore signature from endpoint: insecure.\n");
   fprintf(stderr, "\t-u\t\t: Do an udp probe on all the proxies in the route.\n");
   fprintf(stderr, "\t-s\t\t: Skip proxies which didn't respond to udp probe.\n");
   fprintf(stderr, "\t-a port\t\t: Advisory sourceport specification.\n");
   fprintf(stderr, "\t-m port\t\t: Mandatory sourceport specification.\n");
   fprintf(stderr, "\t-r file\t\t: Specify file to take random seed from.\n");
   fprintf(stderr, "\t-v\t\t: Show version information.\n");
   exit(0);
}

void version(void) {
   fprintf(stderr, "\tThis is aesoptunnel v%s\n", VERSION);
   fprintf(stderr, "Built with:"
#ifdef IPV6
   " -DIPV6"
#endif
#ifdef DEBUG
   " -DDEBUG"
#endif
   "\n");
   fprintf(stderr, "webpage: http://www.kryptology.org/aesop/\n");
   fprintf(stderr, "author:  bighawk, bighawk@kryptology.org\n");
   exit(0);
}
