#ifndef LIBAESOP2_H
#define LIBAESOP2_H

#include "general.h"

#include <dlfcn.h>

#define MAGIC           0x4145534f      /* "AESO" */
#define CNTRL_INET6     16      /* IPv6 Address	*/

#ifndef __GNUC__
 #pragma pack(1)
#endif
typedef struct _conninit {
   uint32_t     magic;          /* Magic Number: "AESO" in network order */
   uint8_t      targetip[16];   /* Network Order */
   uint16_t     targetport;     /* Network Order */
   uint16_t     control;        /* Control codes for proxy in network order */
   uint16_t	data;
#ifndef __GNUC__
 } conninit;
 #pragma pack(0)
#else
 } __attribute__ ((packed)) conninit;
#endif

extern int (*_r_connect)(int, const struct sockaddr *, socklen_t);

#endif
