#ifndef CONNECTION_H
#define CONNECTION_H

#define ST_NOTUSED	0	/* Entry avaiable 			*/
#define ST_DHSEND1	1	/* Sending DH data to client		*/
#define ST_DHRECV1	2	/* Receiving DH data from client 	*/
#define ST_DHSEND2	3	/* Sending DH data to remote (chain mode) */
#define ST_DHRECV2	4	/* Receiving DH data from remote (chain mode) */
#define ST_DHSEND3	5	/* Sending DH data over proxies back (endpoint mode) */
#define ST_DHRECV3	6	/* Receiving DH data over proxies back (endpoint mode) */
#define ST_WAITINF	7	/* Waiting for conninit structure 	*/
#define ST_INPROGR	8	/* Connecting to specified host 	*/
#define	ST_CONNECT	9	/* Both sides connected 		*/
#define ST_FINISHL	10	/* Client closed the connection, but there is still data to write to the destination */
#define ST_FINISHR	11	/* Destination closed the connection, but there is still data to write to the client */

#define IS_ST_TIMEOUT(c)	(((c).status == ST_DHSEND1) || ((c).status == ST_DHRECV1) || ((c).status == ST_WAITINF) || \
				 ((c).status == ST_DHSEND2) || ((c).status == ST_DHRECV2) || ((c).status == ST_DHSEND3) || \
				 ((c).status == ST_DHRECV3))
#define IS_ST_PROCESS(c)	(((c).status == ST_CONNECT) || ((c).status == ST_FINISHL) || ((c).status == ST_FINISHR))

#define AS_NORMAL	0
#define AS_CHAIN	1
#define AS_ENDPOINT	2

#define MAGIC		0x4145534f	/* "AESO" */

#define	EOF_LOCAL	0	/* Client EOF for Connection_eof()	*/
#define EOF_REMOT	1	/* Destination EOF for Connection_eof()	*/

/* Control codes for proxy per structure */
#define CNTRL_ALONE	1	/* Standalone mode 			*/
#define CNTRL_CHAIN	2	/* Part of chain			*/
#define CNTRL_ENDPO	4	/* Endpoint				*/
#define CNTRL_DEBUG	8	/* Debug mode (undefined as of now)	*/
#define CNTRL_INET6	16	/* IPv6 Address				*/
#define CNTRL_APORT	32	/* Advisory source port specification	*/
#define CNTRL_MPORT	64	/* Mandatory source port specification	*/

#ifndef __GNUC__
 #pragma pack(1)
#endif
typedef struct _conninit {
   uint32_t     magic;          /* Magic Number: "AESO" in network order */
   uint8_t      targetip[16];   /* Network Order */
   uint16_t     targetport;     /* Network Order */
   uint16_t     control;        /* Control codes for proxy in network order */
   uint16_t	data;		/* Data field (used by APORT, MPORT, etc) Network Order	*/
   uint8_t      authdata[40];
   R_RSA_PUBLIC_KEY pkey;       /* pkey.bits in Network Order   */
#ifndef __GNUC__
 } conninit;
 #pragma pack(0)
#else
 } __attribute__ ((packed)) conninit;
#endif

#define ENC_CONN_SIZE   (3 * 128)       /* Size of encrypted conninit structure */

typedef struct connection {
   int localfd;		/* FD representing user-proxy link */
   int remotefd;	/* FD representing proxy-target link */
   int status;		/* Current status of this Connection struct	*/
   time_t time;		/* Timestamp on when the current Connection structure was added */
   unsigned char *lbuf;	/* Read buffer for localfd */
   unsigned char *rbuf;	/* Read buffer for remotefd */
   int lpos;		/* Read position in localfd read buffer */
   int rpos;		/* Read position in remotefd read buffer */
   int *l_oobpos;	/* Array of positions of eventual Out of Bandage databyte in lbuf */
   int l_oobsize;	/* Number of elements in Array l_oobpos */
   int l_oobused;	/* Number of elements used in array l_oobpos */
   int *r_oobpos;	/* Array of position of eventual Out of Bandage databyte in rbuf */
   int r_oobsize;	/* Number of elements in Array r_oobpos */
   int r_oobused;	/* Number of elements used in array r_oobpos */
   struct DHData *dh;	/* Temporary DH structure */
   ArcfourContext e;	/* RC4 context used for encryption */ 
   ArcfourContext d;	/* RC4 context used for decryption */
   ArcfourContext e2;	/* 2nd RC4 context for encryption in chain or endpoint mode */
   ArcfourContext d2;	/* 2nd RC4 context for encryption in chain or endpoint mode */
   int control;		/* Copy of control field of control header for this connection.	*/
   conninit *init;	/* Temporary copy of the conninit structure for this connection.*/
} Connection;

void Connection_alloc(void);
int Connection_add(int localfd);
void Connection_del(Connection *delcon);
void Connection_process(Connection *con);
void Connection_DH_init(Connection *con, int how);
void Connection_DH_senddata(Connection *con, int to);
void Connection_DH_readdata(Connection *con, int from);
void Connection_DH_process(Connection *con, int how);
void Connection_eof(Connection *con, int who);
void dec_conninit(R_RSA_PRIVATE_KEY *pkey, unsigned char *data, unsigned char *dest);

#endif
