#include "aesopd.h"

void initialise(int argc, char **argv, int fd[2]) {
   char *chrootdir = NULL;
   char *keyfile = NULL;
   char *conffile = NULL;
   char *ptr;
   int uid = -1, gid = -1;
   int o, udp_probe = 1;
   long flags;

   opterr = 0;
   while((o = getopt(argc, argv, "?hvdea:l:n:o:c:u:g:s:k:t:b:r:")) != EOF) {
      switch(o) {
	 case 'h':
	 case '?':
	    usage(argv[0]);
	    break;
	 case 'v':
	    version();
	    break;
	 case 'd':
#ifndef DEBUG
	    fprintf(stderr, "This aesop binary has not been built with debugging support\n");
	    exit(-1);
#else
	    debug++;
	    break;
#endif
	 case 'e':
	    udp_probe = 0;
	    break;
	 case 'n':
	    max_simul_con = atoi(optarg);
	    break;
	 case 'a':
	    AuthData = strdup(optarg);
	    break;
	 case 'l':
	    do_log = 1;
	    LogFile = strdup(optarg);
	    break;
	 case 'o':
	    conffile = strdup(optarg);
	    break;
	 case 'c':
	    chrootdir = strdup(optarg);
	    break;
	 case 'u':
	    uid = atoi(optarg);
	    break;
	 case 'g':
	    gid = atoi(optarg);
	    break;
	 case 's':
	    sndbufsz = atoi(optarg);
	    break;
	 case 'k':
	    keyfile = strdup(optarg);
	    break;
	 case 't':
	    timeout = atoi(optarg);
	    break;
	 case 'b':
	    sp_base = atoi(optarg);
	    break;
	 case 'r':
	    seedfile = strdup(optarg);
	    break;
	 default:
	    fprintf(stderr, "Invalid option: -%c\n", o);
	    usage(argv[0]);
	    break;
      }
   }

   if(!conffile) {
      if(!access(AESOPD_CONF_FILE, F_OK))
	 conf_parse(AESOPD_CONF_FILE);
      else if(!access(GLOBAL_AESOPD_CONF_FILE, F_OK))
	 conf_parse(GLOBAL_AESOPD_CONF_FILE);
   } else {
      conf_parse(conffile);
      free(conffile);
   }

   /* Get parameters from configuration file if not overridden by commandline	*/

   if(!LogFile) {
      if((LogFile = getvalue("LogFile")) != NULL)
	 do_log = 1;
   }

   if(!chrootdir)
      chrootdir = getvalue("ChrootDir");

   if(!uid) {
      char *tmp = getvalue("User");
      if(tmp)
	 uid = atoi(tmp);
   }

   if(!gid) {
      char *tmp = getvalue("Group");
      if(tmp)
	 gid = atoi(tmp);
   }

   if(getvalue("MaxSimulConn"))
      max_simul_con = atoi(getvalue("MaxSimulConn"));

   if(!sndbufsz) {
      char *tmp = getvalue("BufferSize");
      if(tmp)
	 sndbufsz = atoi(tmp);
   }

   if(!keyfile)
      keyfile = getvalue("PrivateKeyFile");

   if(!AuthData) {
      char *tmp = getvalue("AuthString");
      if(tmp)
	 AuthData = strdup(tmp);
   }

   if(timeout != -1) {
      char *tmp = getvalue("TimeOut");
      if(tmp)
	 timeout = atoi(tmp);
   } else
      timeout = TIMEOUT;

   if(!sp_base) {
      char *tmp = getvalue("SourcePortBase");
      if(tmp)
	 sp_base = atoi(tmp);
   }

   if(!seedfile) {
      char *tmp = getvalue("SeedFile");
      if(tmp)
	 seedfile = strdup(tmp);
      else
	 seedfile = RANDOM_SEED_FILE;
   }

   if(LoadPrivateKey(keyfile ? keyfile : PRIVATE_KEY_FILE, &ServerPrivateKey) != 0)
      exit(-1);         /* LoadPrivateKey prints error message */

   fd[1] = 0;

   if((argc - optind) > 0) {
      if((ptr = strchr(argv[optind], '#'))) {
	 *ptr++ = '\0';
	 fd[0] = w_listen(argv[optind], ptr, SOCK_STREAM);
	 if(udp_probe)
	    fd[1] = w_listen(argv[optind], ptr, SOCK_DGRAM);
      } else {
	 fd[0] = w_listen(NULL, argv[optind], SOCK_STREAM);
	 if(udp_probe)
	    fd[1] = w_listen(NULL, argv[optind], SOCK_DGRAM);
      }
   } else { 
       fd[0] = w_listen(NULL, LISTEN_PORT_STRING, SOCK_STREAM);
       if(udp_probe)
	  fd[1] = w_listen(NULL, LISTEN_PORT_STRING, SOCK_DGRAM);
   }

   if((flags = fcntl(fd[0], F_GETFL, 0)) == -1)
      err_sys("initialise: fcntl F_GETFL error");

   if(fcntl(fd[0], F_SETFL, flags | O_NONBLOCK) == -1)
      err_sys("initialise: fcntl F_SETFL error");

   if(!sndbufsz) {
      socklen_t optlen = sizeof(int);

      if(getsockopt(fd[0], SOL_SOCKET, SO_SNDBUF, &sndbufsz, &optlen))
	 err_sys("initialise: Can not get SO_SNDBUF");
   }

   if(!timeout)
      timeout = TIMEOUT;

   if(chrootdir) {
      if(chroot(chrootdir))
	 err_sys("initialise: Can not chroot to %s", chrootdir);
      chdir("/");
      free(chrootdir);
   }

   if(gid != -1) {
      if(setregid(gid, gid))
	 err_sys("initialise: Can not change gid to %d", gid);
   }

   if(uid != -1) {
      if(setreuid(uid, uid))
	 err_sys("initialise: Can not change uid to %d", uid);
   }

   if(!debug) {
      if(fork()) {
	 exit(0);
      } else {
	 setsid();
	 daemon_proc = 1;
      }
   }
   aesoplog("Aesopd started.");
   conf_cleanup();
   signal(SIGPIPE, sigpipe);
}

void sigpipe(int dummy) {
#ifdef DEBUG
   if(debug)
      err_msg("sigpipe: Got delivered a SIGPIPE");
#endif
   return;
}

void usage(char *name) {
   fprintf(stderr, "aesopd: Advanced Encrypted Stackable Open Proxy v%s\n", VERSION);
   fprintf(stderr, "usage: %s [options] [[listenhost[/v4|/v6]#]port]\n", name);
   fprintf(stderr, "where options are:\n");
   fprintf(stderr, "\t-a string\t: Specify the authentication string this proxy requires.\n");
   fprintf(stderr, "\t-b base\t\t: Set sourceport specification base. base > 65535 to disallow.\n");
   fprintf(stderr, "\t-c dir\t\t: Chroot daemon to dir.\n");
#ifdef DEBUG
   fprintf(stderr, "\t-d\t\t: Run the daemon in debug mode.\n");
   fprintf(stderr, "\t-e\t\t: Disable support for udp probing.\n");
#endif
   fprintf(stderr, "\t-g gid\t\t: Run daemon under gid.\n");
   fprintf(stderr, "\t-h\t\t: Show this help.\n");
   fprintf(stderr, "\t-k file\t\t: Specify private keyfile.\n");
   fprintf(stderr, "\t-l file\t\t: Log to file.\n");
   fprintf(stderr, "\t-n num\t\t: Maximum simultaneous connections.\n");
   fprintf(stderr, "\t-o file\t\t: Read configuration from file.\n");
   fprintf(stderr, "\t-r file\t\t: Specify file to take random seed from.\n");
   fprintf(stderr, "\t-s size\t\t: Set internal buffersize.\n");
   fprintf(stderr, "\t-t timeout\t: Set connection timeout.\n");
   fprintf(stderr, "\t-u uid\t\t: Run daemon under uid.\n");
   fprintf(stderr, "\t-v\t\t: Show version information.\n");
   exit(0);
}

void version(void) {
   fprintf(stderr, "\tThis is aesop v%s\n", VERSION);
   fprintf(stderr, "Built with:"
#ifdef IPV6
   " -DIPV6"
#endif
#ifdef DEBUG
   " -DDEBUG"
#endif
   "\n");
   fprintf(stderr, "webpage: http://www.kryptology.org/aesop/\n");
   fprintf(stderr, "author:  bighawk, bighawk@kryptology.org\n");
   exit(0);
}
