#include "aesoptunnel.h"

int main(int argc, char **argv) {
   int listenfd, num, i;
   unsigned int timeoffset;
   struct sockaddr *cli;
   socklen_t clilen, clilensave;
   fd_set rdsettmp, wrsettmp;
   struct timeval tv;
   time_t currtime;

   listenfd = initialise(argc, argv);

   FD_ZERO(&rdset);
   FD_ZERO(&wrset);
   FD_SET(listenfd, &rdset);
   maxfd = listenfd;

#ifdef IPV6
   clilensave = sizeof(struct sockaddr_in6);
#else
   clilensave = sizeof(struct sockaddr_in);
#endif

   cli = Malloc(clilensave);

   for( ; ; ) {
      /* Timeout handling */

      currtime = time(NULL);
      timeoffset = 10000000;    /* Very big timeperiod =) */

      for(i = 0; i < conn_size; i++) {
	 if(IS_ST_TIMEOUT(conn[i])) {
	    if(currtime > conn[i].time) {
#ifdef DEBUG
	       err_msg("Timeout for localfd=%d", conn[i].localfd);
#endif
	       aesoplog("Connection from %s timed out.", print_sock(conn[i].localfd));
	       Connection_del(&conn[i]);
	       continue;
	    } else
		timeoffset = MIN(timeoffset, (conn[i].time - currtime));
	 }
      }

      tv.tv_sec = timeoffset+1;         /* +1 to prevent race conditions */
      tv.tv_usec = 0;

      rdsettmp = rdset;
      wrsettmp = wrset;
#ifdef DEBUG
      err_msg("main: in select()");
#endif
      num = select(maxfd+1, &rdsettmp, &wrsettmp, NULL, &tv);

      if(num == -1)
	 if(errno == EINTR)
	    continue;
	 else
	    err_sys("main: Select error");
      else if(num == 0)
	 continue;              /* Timeout detected */

#ifdef DEBUG
      err_msg("main: selectloop: select returned %d", num);
#endif

      if(FD_ISSET(listenfd, &rdsettmp)) {
	 int connfd, i;
	 char *ret;

	 clilen = clilensave;

	 if((connfd = accept(listenfd, cli, &clilen)) == -1) {
	    if(errno == EWOULDBLOCK || errno == ECONNABORTED)
	       continue;        /* Connection was reset before we could accept */
	    else
	       continue;
	 }

#ifdef DEBUG
	 err_msg("main: accepted connection from %s on fd=%d", w_sock_ntop(cli), connfd);
#endif

	 aesoplog("Accepted connection from %s.", ret = w_sock_ntop(cli));
	 free(ret);
	 
	 i = Connection_add(connfd);
	 if(!need_desthdr)
	    Connection_connect(&conn[i]);
      }

      for(i = 0; i < conn_size; i++) {
	 if(conn[i].status == ST_NOTUSED)
	    continue;

	 if(FD_ISSET(conn[i].localfd, &rdsettmp)) {
	    if(conn[i].status == ST_RD_DEST)
	       Connection_readdest(&conn[i]);
	    else if(IS_ST_PROCESS(conn[i]))
	       Readdata(&conn[i], FROM_LOCAL, 0);
	 }

	 if(FD_ISSET(conn[i].localfd, &wrsettmp)) {
	    if(IS_ST_PROCESS(conn[i]))
	       Writedata(&conn[i], TO_LOCAL);
	 }

	 if(FD_ISSET(conn[i].remotefd, &rdsettmp)) {
	    if(conn[i].status == ST_DHRECV1 || conn[i].status == ST_DHRECV2)
	       Connection_DH_readdata(&conn[i]);
	    else if(IS_ST_PROCESS(conn[i]))
	       Readdata(&conn[i], FROM_REMOTE, 0);
	 }

	 if(FD_ISSET(conn[i].remotefd, &wrsettmp)) {
	    if(conn[i].status == ST_INPROGR)
	       CheckConnection(&conn[i]);
	    else if(conn[i].status == ST_DHSEND1 || conn[i].status == ST_DHSEND2)
	       Connection_DH_senddata(&conn[i]);
	    else if(conn[i].status == ST_SENDINF)
	       Connection_sendinfo(&conn[i]);
	    else if(IS_ST_PROCESS(conn[i]))
	       Writedata(&conn[i], TO_REMOTE);
	 }

      }
   }
}
