#include "aesoptunnel.h"

void add_proxy(Proxy *proxy) {
   char data[16];
   static char NextAuthData[20];
   int inet6;

   inet6 = resolve_proxy(proxy->address, data);

   if(probe_all)
      if(probe_proxy(data, htons(proxy->port), inet6)) {
	 if(skip_ok) {
	    err_msg("Warning %s:%d didnt respond to UDP probe.", proxy->address, proxy->port);
	    return;
	 }
	 else
	    err_quit("Proxy %s:%d did not respond do UDP probe, exiting.", proxy->address, proxy->port);
      }

   if(!proxyhostlen) {
      proxyhost = w_setsockaddr(data, htons(proxy->port), &proxyhostlen, inet6);
      if(LoadPublicKey(proxy->keyfile, &FirstPublicKey) == -1)
	 exit(-1);
      strncpy(NextAuthData, proxy->authstring, 40);
      return;
   }

   if((cntrl = realloc(cntrl, (cntrl_num + 1) * sizeof(conninit))) == NULL)
      err_sys("Memory allocation error");

   memset(&cntrl[cntrl_num], 0, sizeof(conninit));

   cntrl[cntrl_num].magic = htonl(MAGIC);
   cntrl[cntrl_num].targetport = htons(proxy->port);
   memcpy(&cntrl[cntrl_num].targetip, data, inet6 ? 16 : 4);
   strncpy((char *)cntrl[cntrl_num].authdata, NextAuthData, sizeof(cntrl[cntrl_num].authdata));
   strncpy(NextAuthData, proxy->authstring, 40);
   if(strcmp(proxy->keyfile, "none"))
      if(LoadPublicKey(proxy->keyfile, &cntrl[cntrl_num].pkey) == -1)
	 exit(-1);
   cntrl[cntrl_num].pkey.bits = htonl(cntrl[cntrl_num].pkey.bits);
   if(inet6)
      cntrl[cntrl_num].control = htons(CNTRL_INET6);
   cntrl_num++;
}

void proxy_final(int dest_included) {
   int i;
   R_RSA_PUBLIC_KEY pkey;

   if(dest_included) {
      if(cntrl_num == 1) /* Standalone mode */
	 cntrl[0].control |= htons(CNTRL_ALONE);
      else {
	 for(i = 0; i < cntrl_num-1; i++)
	    cntrl[i].control |= htons(CNTRL_CHAIN);
	 cntrl[cntrl_num-1].control |= htons(CNTRL_ENDPO);
      }
      cntrl[cntrl_num-1].data = htons(sp_port);
      if(sp_spec)
	 cntrl[cntrl_num-1].control |= htons((sp_spec == 1 ? CNTRL_APORT : CNTRL_MPORT));
   } else {
      if(!cntrl_num)
	 return;
      for(i = 0; i < cntrl_num; i++)
	 cntrl[i].control |= htons(CNTRL_CHAIN);
   }
   if((ctrlheaders = malloc(cntrl_num * 3 * 128)) == NULL)
      err_sys("proxy_final: Memory allocation error");

   enc_conninit(&FirstPublicKey, (unsigned char *)&cntrl[0], ctrlheaders);
   for(i = 1; i < cntrl_num; i++) {
      pkey = cntrl[i-1].pkey;
      pkey.bits = ntohl(pkey.bits);
      enc_conninit(&pkey, (unsigned char *)&cntrl[i], ctrlheaders + (i * 3 * 128));
   }
}

void enc_conninit(R_RSA_PUBLIC_KEY *pkey, unsigned char *data, unsigned char *dest) {
   static R_RANDOM_STRUCT randomStruct;
   static int did_init;
   int i;

   if(!did_init) {
      InitRandomStruct(&randomStruct);
      did_init = 1;
   }

   for(i = 306; i > 0; i -= 117) {
      unsigned int outputlen, inputlen = MIN(i, 117);

      if(RSAPublicEncrypt(dest, &outputlen, data, inputlen, pkey, &randomStruct))
	 err_quit("encrypt_conninit: RSAPublicEncrypt() failed");
   
      dest += 128;
      data += 117;
   }
}

int resolve_proxy(char *proxy, char *dest) {
   struct hostent *host;
   int err;

   if(ipv6host(proxy) == 0) {
      if((host = gethostbyname(proxy)) == NULL) {
	 fprintf(stderr, "resolve_proxy: Error resolving %s.\n", proxy);
	 exit(-1);
      }
      memcpy(dest, host->h_addr_list[0], host->h_length);
      return 0;
   } else {
#ifdef IPV6
#ifdef have_gethostbyname2

      if((host = gethostbyname2(proxy, AF_INET6)) == NULL) {
	 fprintf(stderr, "resolve_proxy: Error resolving %s.\n", proxy);
	 exit(-1);
      }
#elif defined(have_getipnodebyname)

      if((host = getipnodebyname(proxy, AF_INET6, 0, &err)) == NULL) {
	 fprintf(stderr, "resolve_proxy: Error resolving %s.\n", proxy);
	 exit(-1);
      }
#endif	/* have_gethostbyname2	*/

      memcpy(dest, host->h_addr_list[0], host->h_length);
#else
      if(inet_pton(AF_INET6, proxy, dest) <= 0) {
	 fprintf(stderr, "resolve_proxy: IPv6 host %s in invalid format\n", proxy);
	 exit(-1);
      }
#endif
      return 1;
   }
}
