#include "aesoptunnel.h"

int initialise(int argc, char **argv) {
   char *file = NULL, *label = NULL;
   char *conffile = NULL, *chrootdir = NULL;
   char *ptr;
   int uid = -1, gid = -1;
   int o, sd, n = 0;
   Proxy dest;
   long flags;

   opterr = 0;
   while((o = getopt(argc, argv, "a:b:c:def:g:hil:m:n:o:pr:st:u:v?")) != EOF) {
      switch(o) {
	case 'a':
	   sp_port = atoi(optarg);
	   sp_spec = 1;
	   break;
	case 'b':
	   label = strdup(optarg);;
	   break;
	 case 'c':
	    chrootdir = strdup(optarg);
	    break;
	case 'd':
#ifndef DEBUG
	   err_quit("This aesoptunnel binary has not been built with debugging support.");
#else
	   debug++;
#endif
	   break;
	case 'e':
	   skip_ok = 1;
	   break;
	case 'f':
	   file = strdup(optarg);
	   break;
	case 'g':
	    gid = atoi(optarg);
	    break;
	case '?':
	case 'h':
	   usage(argv[0]);
	   break;
	case 'i':
	   skip_verification = 1;
	   break;
	case 'l':
	   do_log = 1;
	   LogFile = strdup(optarg);
	   break;
	case 'm':
	   sp_port = atoi(optarg);
	   sp_spec = 2;
	   break;
	case 'n':
	    max_simul_con = atoi(optarg);
	    break;
	case 'o':
	    conffile = strdup(optarg);
	    break;
	case 'p':
	   probe_all = 1;
	   break;
	case 'r':
	   seedfile = strdup(optarg);
	   break;
	case 's':
	   sndbufsz = atoi(optarg);
	   break;
	case 't':
	    timeout = atoi(optarg);
	    break;
	case 'u':
	    uid = atoi(optarg);
	    break;
	case 'v':
	   version();
	   break;
	default:
	   err_msg("Warning: invalid option %c.", o);
	   usage(argv[0]);
	   break;
      }
   }

   if(!conffile) {
      if(!access(AESOPTUNNEL_CONF_FILE, F_OK))
	 conf_parse(AESOPTUNNEL_CONF_FILE);
      else if(!access(GLOBAL_AESOPTUNNEL_CONF_FILE, F_OK))
	 conf_parse(GLOBAL_AESOPTUNNEL_CONF_FILE);
   } else {
      conf_parse(conffile);
      free(conffile);
   }

   if(!LogFile) {
      if((LogFile = getvalue("LogFile")) != NULL)
	 do_log = 1;
   }

   if(!chrootdir)
      chrootdir = getvalue("ChrootDir");

   if(!uid) {
      char *tmp = getvalue("User");
      if(tmp)
	 uid = atoi(tmp);
   }

   if(!gid) {
      char *tmp = getvalue("Group");
      if(tmp)
	 gid = atoi(tmp);
   }

   if(getvalue("MaxSimulConn"))
      max_simul_con = atoi(getvalue("MaxSimulConn"));

   if(!sndbufsz) {
      char *tmp = getvalue("BufferSize");
      if(tmp)
	 sndbufsz = atoi(tmp);
   }

   if(timeout == -1) {
      char *tmp = getvalue("TimeOut");
      if(tmp)
	 timeout = atoi(tmp);
      else
	 timeout = TIMEOUT;
   }

   if(!seedfile) {
      char *tmp = getvalue("SeedFile");
      if(tmp)
	 seedfile = strdup(tmp);
      else
	 seedfile = RANDOM_SEED_FILE;
   }

   if(!file)
      file = getvalue("RoutesFile");

   if(!label)
      label = getvalue("Label");

   if(!probe_all) {
      char *tmp = getvalue("UDPProbe");
      if(tmp)
	 probe_all = atoi(tmp);
   }

   if((argc - optind) < 1) {
      fprintf(stderr, "Error: Too few arguments\n");
      usage(argv[0]);
   } else if((argc - optind) > 3) {
      fprintf(stderr, "Error: Too many arguments\n");
      usage(argv[0]);
   } else if((argc - optind) == 1) {
      n = 0;
      need_desthdr = 1;
   } else {
      n = 1;
   }

   if((ptr = strchr(argv[optind+n], '#'))) {
      *ptr++ = '\0';
      sd = w_listen(argv[optind+n], ptr, SOCK_STREAM);
   } else
      sd = w_listen(NULL, argv[optind+n], SOCK_STREAM);

   if((flags = fcntl(sd, F_GETFL, 0)) == -1)
      err_sys("initialise: fcntl F_GETFL error");

   if(fcntl(sd, F_SETFL, flags | O_NONBLOCK) == -1)
      err_sys("initialise: fcntl F_SETFL error");

   if(!sndbufsz) {
      socklen_t optlen = sizeof(int);

      if(getsockopt(sd, SOL_SOCKET, SO_SNDBUF, &sndbufsz, &optlen))
	 err_sys("initialise: Can not get SO_SNDBUF");
   }

   if(!file)
      err_quit("No file specified");

   parse_file(file, label);

   probe_all = 0;

   if(n) {
      if((ptr = strchr(argv[optind], '#'))) {
	 *ptr++ = '\0';
	 dest.address = argv[optind];
	 dest.port = atoi(ptr);
	 dest.keyfile = "none";
	 dest.authstring = "none";
	 add_proxy(&dest);
      } else {
	 dest.address = "127.0.0.1";
	 dest.port = atoi(argv[optind]);
	 dest.keyfile = "none";
	 dest.authstring = "none";
	 add_proxy(&dest);
      }
      proxy_final(1);
   } else {
      proxy_final(0);
   }

#ifdef IPV6
   {	/* Check if an actual IPv6 stack is present.	*/
      int sd2;
      if(((sd2 = socket(AF_INET6, SOCK_STREAM, 0)) == -1) && proxyhostlen == sizeof(struct sockaddr_in6))
	 err_quit("Error: Aesop has been built with IPv6 support, but there is no IPv6 stack available\n"
		  "       and the first proxy specified is an IPv6 host: aborting.");
      close(sd2);
   }
#endif

   if(!debug) {
      if(fork()) {
	 exit(0);
      } else {
	 setsid();
	 daemon_proc = 1;
      }
   }

   free(file);
   free(label);

   aesoplog("Aesoptunnel started.");
   conf_cleanup();
   signal(SIGPIPE, sigpipe);   

   return sd;
}

void sigpipe(int dummy) {
#ifdef DEBUG
   if(debug)
      err_msg("sigpipe: Got delivered a SIGPIPE");
#endif
   return;
}

void usage(char *name) {
   fprintf(stderr, "aesoptunnel: Client Tunnel for Aesop \n");
   fprintf(stderr, "usage: %s [options] [destinationhost[/v4|/v6]#]port [listenhost[/v4|/v6]#]port\n", name);
   fprintf(stderr, "       %s [options] [listenhost[/v4|/v6]#]port\n", name);
   fprintf(stderr, "where options are:\n");
   fprintf(stderr, "\t-a port\t\t: Advisory sourceport specification.\n");
   fprintf(stderr, "\t-b label\t: Specify the label for the chain, default: first label.\n");
   fprintf(stderr, "\t-c dir\t\t: Chroot daemon to dir.\n");
#ifdef DEBUG
   fprintf(stderr, "\t-d\t\t: Run the tunnel in debug mode.\n");
#endif
   fprintf(stderr, "\t-e\t\t: Skip proxies which didn't respond to udp probe.\n");
   fprintf(stderr, "\t-f file\t\t: Specify file to load routes from.\n");
   fprintf(stderr, "\t-g gid\t\t: Run daemon under gid.\n");
   fprintf(stderr, "\t-h\t\t: Show this help.\n");
   fprintf(stderr, "\t-i\t\t: Ignore signature from endpoint: insecure.\n");
   fprintf(stderr, "\t-l file\t\t: Log to file.\n");
   fprintf(stderr, "\t-m port\t\t: Mandatory sourceport specification.\n");
   fprintf(stderr, "\t-n num\t\t: Maximum simultaneous connections.\n");
   fprintf(stderr, "\t-o file\t\t: Read configuration from file.\n");
   fprintf(stderr, "\t-p\t\t: Do an udp probe on all the proxies in the route.\n");
   fprintf(stderr, "\t-r file\t\t: Specify file to take random seed from.\n");
   fprintf(stderr, "\t-s size\t\t: Set internal buffersize.\n");
   fprintf(stderr, "\t-t timeout\t: Set connection timeout.\n");
   fprintf(stderr, "\t-u file\t\t: Run daemon under uid.\n");
   fprintf(stderr, "\t-v\t\t: Show version information.\n");
   exit(0);
}

void version(void) {
   fprintf(stderr, "\tThis is aesoptunnel v%s\n", VERSION);
   fprintf(stderr, "Built with:"
#ifdef IPV6
   " -DIPV6"
#endif
#ifdef DEBUG
   " -DDEBUG"
#endif
   "\n");
   fprintf(stderr, "webpage: http://www.kryptology.org/aesop/\n");
   fprintf(stderr, "author:  bighawk, bighawk@kryptology.org\n");
   exit(0);
}
