#include "aesoptunnel.h"

int num_proxies = 0;
Proxy *proxies = NULL;
int num_routes = 0;
Route *routes = NULL;

void parse_file(char *file, char *label) {

   FILE *fptr;
   char *ptr;

   linecount = 0;

   if((fptr = fopen(file, "r")) == NULL)
      err_quit("Couldn't open %s for reading.", file);

   while((ptr = getnextline(fptr)) != NULL) {
      if(!strncmp(ptr, "proxy", 5))
	 parse_proxy(ptr, fptr);
      else if(!strncmp(ptr, "route", 5))
	 parse_route(ptr, fptr);
      else
	 err_quit("parse_file: Garbage found at line %d.\n", linecount);
   }

   if(!num_routes)
      err_quit("parse_file: No route{} constructs specified.");

   handle_route(label, 0);

   cleanup_routes();
   cleanup_proxies();
   fclose(fptr);
}

void parse_proxy(char *buf, FILE *fptr) {
   char *ptr, *ptr2;
   char *lbuf;
   Proxy *new;

   if((proxies = realloc(proxies, (num_proxies+1) * sizeof(Proxy))) == NULL)
      err_sys("parse_proxy: Memory allocation error");

   new = &proxies[num_proxies];
   num_proxies++;

   /* Get label 	*/
   ptr = ptr2 = skip_whitespace(buf+5);
   while(isalnum((int)*ptr2)) ptr2++;
   *ptr2 = 0;   
   new->label = strdup(ptr);

   /* Get address and eventual port */
   if((lbuf = getnextline(fptr)) == NULL)
      err_quit("parse_proxy: Premature end of file at line %d.", linecount);

   if(*lbuf == '}')
      err_quit("parse_proxy: Too few elements in proxy{} construct at line %d.", linecount);

   if((ptr = strtok(lbuf, " \t\n")) == NULL)
      err_quit("parse_proxy: Invalid proxy{} construct at line %d.", linecount);

   new->address = strdup(ptr);

   if((ptr = strtok(NULL, " \t\n")) == NULL)
      new->port = 6789;
   else
      new->port = atoi(ptr);

   /* Get keyfile	*/
   if((lbuf = getnextline(fptr)) == NULL)
      err_quit("parse_proxy: Premature end of file at line %d.", linecount);

   if(*lbuf == '}')
      err_quit("parse_proxy: Too few elements in proxy{} construct at line %d.", linecount);

   if((ptr = strtok(lbuf, " \t\n")) == NULL)
      err_quit("parse_proxy: Invalid proxy{} construct at line %d.", linecount);

   new->keyfile = strdup(ptr);

   /* Get authenticationstring	*/
   if((lbuf = getnextline(fptr)) == NULL)
      err_quit("parse_proxy: Premature end of file at line %d.", linecount);

   if(*lbuf == '}')
      err_quit("parse_proxy: Too few elements in proxy{} construct at line %d.", linecount);

   ptr = skip_whitespace(lbuf);
   if(*ptr != '"')
      err_quit("parse_proxy: Authentication string at line %d is not between double quotes.", linecount);

   if((ptr2 = strrchr(ptr+1, '"')) == NULL)
      err_quit("parse_proxy: Authentication string at line %d is not between double quotes.", linecount);
   
   *ptr2 = 0;
   if(strlen(++ptr) > 39)
      err_quit("parse_proxy: Authentication string at line %d bigger than 39 characters.", linecount);

   new->authstring = strdup(ptr);
   skip_to_closing_brace(fptr);
}

void parse_route(char *buf, FILE *fptr) {
   char *ptr, *ptr2;
   int num = 0, gotproxy = 0, got_brace = 0;
   Route *new;

   if((routes = realloc(routes, (num_routes+1) * sizeof(Route))) == NULL)
      err_sys("parse_route: Memory allocation error");

   new = &routes[num_routes];
   num_routes++;

   ptr = ptr2 = skip_whitespace(buf+5);
   while(isalnum((int)*ptr2)) ptr2++;
   *ptr2 = 0;
   new->name = strdup(ptr);
   new->count = 0;
   new->proxies = NULL;

   while((ptr = ptr2 = getnextline(fptr)) != NULL) {
      if(*ptr == '}') {
	 if(!gotproxy)
	    err_quit("parse_route: No proxies specified in route: %s.", new->name);
	 got_brace = 1;
	 break;
      } else if(strchr(ptr, '{')) {
	   err_quit("parse_route: Previous construct not correctly closed at line %d.", linecount);
      }

      while(isalnum((int)*ptr2)) ptr2++;
      *ptr2 = 0;
      
      if((new->proxies = realloc(new->proxies, (++num) * sizeof(char *))) == NULL)
	 err_sys("parse_route: Memory allocation error");

      new->proxies[num-1] = strdup(ptr);
      gotproxy++;
   }
   
   if(!got_brace)
      err_quit("parse_proxy: Premature end of file at line %d.", linecount);      

   if((new->proxies = realloc(new->proxies, (++num) * sizeof(char *))) == NULL)
      err_sys("parse_route: Memory allocation error");

   new->proxies[num-1] = NULL;
}

void handle_route(char *label, int rec) {
   int i;
   char *cur;
   Proxy *curproxy = NULL;
   Route *curroute = NULL;
   static char *lastpubkey, *lastauthdata;

   if(label == NULL)
      curroute = &routes[0];
   else if((curroute = find_route(label)) == NULL)
      err_quit("handle_route: Could not find any route for label %s.", label);

   if(curroute->count)
      err_quit("handle_route: Loop detected in declaration of route labeled '%s'.", label);
   else
      curroute->count++;

   for(i = 1, cur = curroute->proxies[0]; cur != NULL; i++) {
      if(find_route(cur)) {
	 handle_route(cur, rec+1);
      } else {
	 if((curproxy = find_proxy(cur)) == NULL)
	    err_quit("handle_route: Could not find proxy or route labeled %s.", cur);
   
	 add_proxy(curproxy);

	 lastpubkey = curproxy->keyfile;
	 lastauthdata = curproxy->authstring;
      }
      cur = curroute->proxies[i];
   }
   
   if(rec == 0) {
      LoadPublicKey(lastpubkey, &EndpointPublicKey);
      AuthData = strdup(lastauthdata);
   }

   curroute->count--;
   return;
}

Proxy *find_proxy(char *label) {
   int i;
   for(i = 0; i < num_proxies; i++) {
      if(!strcmp(proxies[i].label, label))
	 return &proxies[i];
   }
   return NULL;
}

Route *find_route(char *name) {
   int i;
   for(i = 0; i < num_routes; i++) {
      if(!strcmp(routes[i].name, name))
	 return &routes[i];
   }
   return NULL;
}

void cleanup_proxies(void) {
   int i;
   for(i = 0; i < num_proxies; i++) {
      free(proxies[i].label);
      free(proxies[i].address);
      free(proxies[i].keyfile);
      free(proxies[i].authstring);
   }
   free(proxies);
}

void cleanup_routes(void) {
   int i, j;

   for(i = 0; i < num_routes; i++) {
      free(routes[i].name);
      for(j = 0; routes[i].proxies[j] != NULL; j++)
	 free(routes[i].proxies[j]);
   }
   free(routes);
}

void skip_to_closing_brace(FILE *fptr) {
   char *ptr;

   while((ptr = getnextline(fptr)) != NULL) {
      if(strchr(ptr, '{'))
	 err_quit("skip_to_close_brace: Did not close previous structure correctly at line %d.", linecount);

      if(*ptr == '}')
	 return;
   }

   fprintf(stderr, "parse_file: Could not find closing brace.");
   exit(-1);
}
