#ifndef PARSER_H
#define PARSER_H

#include "general.h"

typedef struct _proxy {
   char *label;
   char *address;
   int port;
   char *keyfile;
   char *authstring;
} Proxy;

typedef struct _route {
   char *name;
   char **proxies;
   int count;
} Route;

void parse_file(char *file, char *label);
void parse_proxy(char *buf, FILE *fptr);
void parse_route(char *buf, FILE *fptr);
void handle_route(char *label, int rec);
Proxy *find_proxy(char *label);
Route *find_route(char *name);
void skip_to_closing_brace(FILE *fptr);
void cleanup_proxies(void);
void cleanup_routes(void);


#endif
