#include "general.h"

char *seedfile = NULL;

unsigned int urand(void) {
   unsigned int dword;
   static FILE *fptr = NULL;

   if(fptr == NULL) {
      if((fptr = fopen(seedfile, "r")) == NULL)
	 err_quit("Could not open random seed file %s.", seedfile);
   }

   if(fread(&dword, 4, 1, fptr) != 1) {
      fclose(fptr);
      return rand();
   }

   return dword;
}

/* Initiates a R_RANDOM_STRUCT struct */
int InitRandomStruct(R_RANDOM_STRUCT *randomStruct) {

   unsigned int bytesNeeded;
   unsigned int randData;

   srand(urand());

   R_RandomInit(randomStruct);

   while(1) {
      R_GetRandomBytesNeeded(&bytesNeeded, randomStruct);
      if(!bytesNeeded) break;

      randData = rand();
      R_RandomUpdate (randomStruct, (unsigned char *)&randData, 4);
   }
   return 0;
}

/* Sets the parameters for the R_RSA_PROTO_KEY struct */
int InitProtoKey(int bits, int fermat, R_RSA_PROTO_KEY *protoKey) {

   if(bits < MIN_RSA_MODULUS_BITS)
      { fprintf(stderr, "InitProtoKey(): too few bits: %d\n", bits); return(-1); }
   else if(bits > MAX_RSA_MODULUS_BITS)
      { fprintf(stderr, "InitProtoKey(): too many bits: %d\n", bits); return(-1); }

   protoKey->bits       = bits;
   protoKey->useFermat4 = fermat;

   return 0;
}

/* Store R_RSA_PUBLIC_KEY stucture as textfile */
int StorePublicKey(char *file, R_RSA_PUBLIC_KEY *publicKey) {

   FILE *fptr;

   if((fptr = fopen(file, "w")) == NULL)
      { fprintf(stderr, "StorePublicKey(): Couldn't open %s for writing\n", file); return(-1); }

   fprintf(fptr, "RSA PUBLIC KEY\n");
   fprintf(fptr, "%u\n", publicKey->bits);
   StorePart(fptr, publicKey->modulus, MAX_RSA_MODULUS_LEN);
   StorePart(fptr, publicKey->exponent, MAX_RSA_MODULUS_LEN);

   fclose(fptr);

   return 0;
}

/* Load textfile into a R_RSA_PUBLIC_KEY structure */
int LoadPublicKey(char *file, R_RSA_PUBLIC_KEY *publicKey) {

   FILE *fptr;
   char tempbuf[20]; /* adjust later */

   if((fptr = fopen(file, "r")) == NULL) {
      fprintf(stderr, "LoadPublicKey(): Couldn't open %s for reading\n", file);
      return -1;
   }

   fgets(tempbuf, 20, fptr);
   if(strncmp(tempbuf, "RSA PUBLIC KEY", 14))
      { fprintf(stderr, "LoadPublicKey(): Not a public key file.\n"); return(-1); }

   fgets(tempbuf, 20, fptr);
   publicKey->bits = atoi(tempbuf);

   LoadPart(fptr, publicKey->modulus, MAX_RSA_MODULUS_LEN);
   LoadPart(fptr, publicKey->exponent, MAX_RSA_MODULUS_LEN);

   fclose(fptr);
   return 0;
}

/* Store R_RSA_PRIVATE_KEY stucture as textfile */
int StorePrivateKey(char *file, R_RSA_PRIVATE_KEY *privateKey) {

   FILE *fptr;

   if((fptr = fopen(file, "w")) == NULL)
      { fprintf(stderr, "StorePrivateKey(): Couldn't open %s for writing\n", file); return(-1); }

   fprintf(fptr, "RSA PRIVATE KEY\n");
   fprintf(fptr, "%u\n", privateKey->bits);
   StorePart(fptr, privateKey->modulus, MAX_RSA_MODULUS_LEN);
   StorePart(fptr, privateKey->publicExponent, MAX_RSA_MODULUS_LEN);
   StorePart(fptr, privateKey->exponent, MAX_RSA_MODULUS_LEN);
   StorePart(fptr, privateKey->prime[0], MAX_RSA_PRIME_LEN);
   StorePart(fptr, privateKey->prime[1], MAX_RSA_PRIME_LEN);
   StorePart(fptr, privateKey->primeExponent[0], MAX_RSA_PRIME_LEN);
   StorePart(fptr, privateKey->primeExponent[1], MAX_RSA_PRIME_LEN);
   StorePart(fptr, privateKey->coefficient, MAX_RSA_PRIME_LEN);

   fclose(fptr);

   return 0;
}
/* Load textfile into a R_RSA_PRIVATE_KEY structure */
int LoadPrivateKey(char *file, R_RSA_PRIVATE_KEY *privateKey) {

   FILE *fptr;
   char tempbuf[20]; /* adjust later */

   if((fptr = fopen(file, "r")) == NULL) {
      fprintf(stderr, "LoadPrivateKey(): Couldn't open %s for reading\n", file);
      return -1;
   }

   fgets(tempbuf, 20, fptr);
   if(strncmp(tempbuf, "RSA PRIVATE KEY", 15))
      { fprintf(stderr, "LoadPrivateKey(): Not a public key file.\n"); return(-1); }

   fgets(tempbuf, 20, fptr);
   privateKey->bits = atoi(tempbuf);

   LoadPart(fptr, privateKey->modulus, MAX_RSA_MODULUS_LEN);
   LoadPart(fptr, privateKey->publicExponent, MAX_RSA_MODULUS_LEN);
   LoadPart(fptr, privateKey->exponent, MAX_RSA_MODULUS_LEN);
   LoadPart(fptr, privateKey->prime[0], MAX_RSA_PRIME_LEN);
   LoadPart(fptr, privateKey->prime[1], MAX_RSA_PRIME_LEN);
   LoadPart(fptr, privateKey->primeExponent[0], MAX_RSA_PRIME_LEN);
   LoadPart(fptr, privateKey->primeExponent[1], MAX_RSA_PRIME_LEN);
   LoadPart(fptr, privateKey->coefficient, MAX_RSA_PRIME_LEN);

   fclose(fptr);
   return 0;
}

int StorePart(FILE *fptr, void *src, int size) {
   char *ptr;

   ptr = base64_encode(src, size);
   fprintf(fptr, "%s\n", ptr);
   free(ptr);

   return 0;
}

int LoadPart(FILE *fptr, void *dest, int size) {
   char tempbuf[2000]; /* adjust this */
   char *ptr;
   int len;

   fgets(tempbuf, 2000, fptr);
   tempbuf[strlen(tempbuf)+1] = 0;
   ptr = base64_decode(tempbuf, &len);
   memcpy(dest, ptr, size);
   free(ptr);

   return 0;
}

char *MD5Hash(unsigned char *passphrase) {
   MD5_CTX context;
   unsigned char hash[16];

   MD5Init(&context);
   MD5Update(&context, passphrase, strlen((char *)passphrase));
   MD5Final(hash, &context);

   return base64_encode(hash, 16);
}
