#include "general.h"

char *LogFile = NULL;
int do_log = 0;

void aesoplog(const char *msg, ...) {
   static FILE *fptr = NULL;
   time_t ct;
   struct tm *rt;
   char buf[1024];
   va_list args;
   
   if(!do_log)
      return;
   
   ct = time(NULL);
   rt = localtime(&ct);

   va_start(args, msg);
   memset(&buf, 0, sizeof(buf));
   vsnprintf(buf, sizeof(buf)-1, msg, args);

   if(!fptr) {
      if(!(fptr = fopen(LogFile, "a+"))) {
	   err_msg("FATAL: Can not open %s", LogFile);
	   va_end(args);
	   return;
      }
      setvbuf(fptr, NULL, _IOLBF, 0);
   }

   if(flock(fileno(fptr), LOCK_EX))
      err_sys("log: Could not get exclusive lock");

   fprintf(fptr, "%.2d:%.2d:%.2d %d/%d/%d - [%d] %s\n", rt->tm_hour, rt->tm_min, rt->tm_sec, rt->tm_mday,
						    rt->tm_mon+1, rt->tm_year+1900, (int)getpid(), buf);
   flock(fileno(fptr), LOCK_UN);
   va_end(args);
}
