#ifndef CipePanelDefined
#define CipePanelDefined

#include "ctype.h"
#include "memory.h"
#include "winsock2.h"
#include "windows.h"
#include "commctrl.h"
#include "windowsx.h"
#include "winuser.h"
#include "iphlpapi.h"
#include "constants.h"

#include "CipeServiceMgr.h"
#include "CipePeer.h"

#include "ControlApplet.hpp"

using namespace JetByteTools;

class CipeControlPanelException
   {
   };

class CipeControlPanel : public CJBControlPanelApplet, public CipeBase
   {
    private:   static char *m_CipherList[];

    private:   CipePeerList m_PeerList;
               HIMAGELIST m_ImageList;
               HWND m_DialogWindow;
               HWND m_TreeView;
               BOOL m_IsModified;

    public:    CipeControlPanel();

    public:    static BOOL CALLBACK OnDialogMessage (HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
               BOOL OnDialogAction (HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam);
               BOOL OnDoubleClick (HWND hWnd, LONG appletData);

    private:   void LoadPeerData();
               void SavePeerData();
               void AddNewPeer();

    private:   void FormatCipherList();
               void RefreshTreeView();
               void CreateTreeView();

    private:   HTREEITEM InsertPeerItem (CipePeer &p_Peer, HTREEITEM p_AdapterItem) throw (CipeControlPanelException);
               HTREEITEM InsertAdapterItem (CipeAdapter &p_Adapter) throw (CipeControlPanelException);
               void SetEditTextState (BOOL p_Enable);

    public:    BOOL Verify (UINT p_Control);
               BOOL IsModified() {return m_IsModified;}
               void StatusMsg (const char *p_Message = "Ready");

    public:    static int m_EditFieldID[], m_EditFieldSize;
               static int m_IconID[], m_IconArraySize;
               static BOOL m_RestartWhenDone;
               static HCURSOR m_SystemCursor;
               static HCURSOR m_Hourglass;
   };

#endif
