#include "CipeBase.h"
#include "constants.h"
#include "hexdump.h"

using namespace std;

string CipeBase::m_ProductName (PRODUCT_STRING);

unsigned char CipeBase::m_BroadcastMAC[] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

string CipeBase::SystemDir()
   {
    char l_Buffer [MAX_PATH + 2];
    l_Buffer [0] = 0;

    GetSystemDirectory (l_Buffer, sizeof (l_Buffer));
    return string (l_Buffer);
   }

int CipeBase::OSType()
   {
    OSVERSIONINFO l_VersionInfo;
    int l_Return = 32767;

    l_VersionInfo.dwOSVersionInfoSize = sizeof (l_VersionInfo);

    if (GetVersionEx (&l_VersionInfo) == TRUE && l_VersionInfo.dwPlatformId == VER_PLATFORM_WIN32_NT)
       {
        l_Return = l_VersionInfo.dwMajorVersion;
       }

    return l_Return;
   }

string &CipeBase::RegQueryVal (HKEY &p_RegistryKey, char *p_Key, string &p_Value)
   {
    return RegQueryVal (p_RegistryKey, string (p_Key), p_Value);
   }

string &CipeBase::RegQueryVal (HKEY &p_RegistryKey, string &p_Key, string &p_Value)
   {
    char l_Buffer [256];
    unsigned long l_Length = sizeof (l_Buffer);

    return p_Value.assign
       (
        RegQueryValueEx (p_RegistryKey, p_Key.c_str(), 0, 0, (unsigned char *) l_Buffer, &l_Length) == ERROR_SUCCESS ?
        l_Buffer :
        ""
       );
   }

BOOL CipeBase::RegSetVal (HKEY &p_RegistryKey, char *p_Key, string &p_Value)
   {
    return RegSetVal (p_RegistryKey, string (p_Key), p_Value);
   }

BOOL CipeBase::RegSetVal (HKEY &p_RegistryKey, string &p_Key, string &p_Value)
   {
    unsigned long l_Status = RegSetValueEx
       (
        p_RegistryKey,
        p_Key.c_str(),
        0,
        REG_SZ,
        (const unsigned char *) p_Value.c_str(),
        p_Value.size() + 1
       );

    return (l_Status == ERROR_SUCCESS);
   }

string CipeBase::RegEnumVal (HKEY &p_RegistryKey, unsigned long p_Index) throw (CipeSubscriptException)
   {
    char l_Buffer [512];
    unsigned long l_Length = sizeof (l_Buffer);
    FILETIME l_Time;

    if (RegEnumKeyEx (p_RegistryKey, p_Index, l_Buffer, &l_Length, 0, 0, 0, &l_Time) != ERROR_SUCCESS)
       {
        throw CipeSubscriptException();
       }

    return string (l_Buffer);
   }

string &CipeBase::MyProductName()
   {
    return m_ProductName;
   }

string &CipeBase::SetMyProductName (char *p_ProductName)
   {
    return m_ProductName = p_ProductName;
   }

string &CipeBase::SetMyProductName (string &p_ProductName)
   {
    return m_ProductName = p_ProductName;
   }

BOOL CipeBase::IsThisMyProduct (char *p_ProductName)
   {
    return p_ProductName == m_ProductName;
   }

BOOL CipeBase::IsThisMyProduct (string &p_ProductName)
   {
    return p_ProductName == m_ProductName;
   }

string CipeBase::inet_str (unsigned long p_Address)
   {
    char l_Buffer [64];
    unsigned char *l_Address = (unsigned char *) &p_Address;
    sprintf (l_Buffer, "%d.%d.%d.%d", l_Address [0], l_Address [1], l_Address [2], l_Address [3]);
    return string (l_Buffer);
   }

string CipeBase::mac_str (unsigned char *p_MAC)
   {
    char l_Buffer [64];

    sprintf
       (
        l_Buffer,
        "%02x:%02x:%02x:%02x:%02x:%02x",
        p_MAC [0],
        p_MAC [1],
        p_MAC [2],
        p_MAC [3],
        p_MAC [4],
        p_MAC [5]
       );

    return string (l_Buffer);
   }

string CipeBase::port_str (unsigned short p_Port)
   {
    char l_Buffer [256];
    sprintf (l_Buffer, "%d", ntohs (p_Port));
    return string (l_Buffer);
   }

string CipeBase::num_str (unsigned long p_Number)
   {
    char l_Buffer [256];
    sprintf (l_Buffer, "%ld", p_Number);
    return string (l_Buffer);
   }

unsigned long CipeBase::str_num (string &p_String)
   {
    return atol (p_String.c_str());
   }
