#ifndef CipeBaseDefined
#define CipeBaseDefined

#include "windows.h"
#include "string"

using namespace std;

class CipeException
   {
    private:   string m_Text;

    public:    CipeException (const char *p_Text = "Undefined error") : m_Text (string (p_Text)){}
               CipeException (string &p_Text) : m_Text (p_Text){}

    public:    string &Text() {return m_Text;}
   };

class CipeSubscriptException
   {
   };

class CipeBase
   {
    public:   unsigned long m_UserData; // For convenience

    private:  static unsigned char m_BroadcastMAC[];

    public:   static string m_ProductName;

    public:   static string SystemDir();
              static int OSType();

    public:   static unsigned char *BroadcastMAC() {return m_BroadcastMAC;}

    public:   static string RegEnumVal (HKEY &p_RegistryKey, unsigned long p_Index) throw (CipeException);
              static string &RegQueryVal (HKEY &p_RegistryKey, string &p_Key, string &p_Value);
              static string &RegQueryVal (HKEY &p_RegistryKey, char *p_Key, string &p_Value);
              static BOOL   RegSetVal (HKEY &p_RegistryKey, string &p_Key, string &p_Value);
              static BOOL   RegSetVal (HKEY &p_RegistryKey, char *p_Key, string &p_Value);

    public:   static string &SetMyProductName (string &p_ProductName);
              static string &SetMyProductName (char *p_ProductName);
              static BOOL   IsThisMyProduct (string &p_ProductName);
              static BOOL   IsThisMyProduct (char *p_ProductName);
              static string &MyProductName();

    public:   static string inet_str (unsigned long p_Address);
              static string mac_str (unsigned char *p_MAC);
              static string port_str (unsigned short p_Port);
              static string num_str (unsigned long p_Number);
              static unsigned long str_num (string &p_String);
   };

#endif
