#ifndef CipeBlowfishEncryptorDefined
#define CipeBlowfishEncryptorDefined

#include "CipeEncryptor.h"
#include "constants.h"
#include "blowfish.h"

class CipeBlowfishEncryptorException
   {
   };

class CipeBlowfishEncryptor : public virtual CipeEncryptor
   {
    private:   CipeEncryptionKeyType m_PreferredStaticKey, m_EncryptKey, m_DecryptKey, m_LastStaticGuess;
               unsigned char m_KeyData [KEY_LIMIT] [BLOWFISH_KEY_LENGTH];
               BLOWFISH_CTX m_Key [KEY_LIMIT];
               BOOL m_HaveKey [KEY_LIMIT];

    public:    CipeBlowfishEncryptor();

    public:    virtual void InstallKey (unsigned char *p_KeyData, CipeEncryptionKeyType p_KeyType);
               virtual void InstallKey (CipeEncryptionKeyType p_KeyType);
               virtual void InstallStaticKey (const char *p_TextKey);

    public:    virtual void SaveKeyData (unsigned char *p_KeyData, CipeEncryptionKeyType p_KeyType);
               virtual unsigned char *GenerateDynamicKeyData (CipeEncryptionKeyType p_KeyType);
               virtual unsigned char *GenerateDynamicKeyData();

    public:    virtual unsigned long KeyDataSize() {return BLOWFISH_KEY_LENGTH;}

    public:    virtual unsigned long Encrypt
                  (
                   unsigned char *p_Out,
                   unsigned char *p_In,
                   unsigned long p_Length,
                   CipeEncryptionKeyType p_KeyType = KEY_DYNAMIC_ENCRYPT,
                   unsigned long p_Options = (unsigned long) NK_DATA
                  );

               virtual unsigned long Decrypt
                  (
                   unsigned char *p_Out,
                   unsigned char *p_In,
                   unsigned long p_Length,
                   CipeEncryptionKeyType p_KeyType,
                   unsigned long &p_Options
                  );

    private:   unsigned long BlockEncrypt (unsigned char *p_Buffer, unsigned long p_Length, BLOWFISH_CTX &p_Key);
               unsigned long BlockDecrypt (unsigned char *p_Buffer, unsigned long p_Length, BLOWFISH_CTX &p_Key);
   };

#endif
