#include "CipeServiceBase.h"
#include "hexdump.h"

//========================================================================================
//
//========================================================================================
typedef enum
   {
    CIPE_SERVICE_STOPPED,
    CIPE_SERVICE_NOT_INSTALLED,
    CIPE_SERVICE_PENDING,
    CIPE_SERVICE_STARTED,
    CIPE_SERVICE_FAILED
   }
CipeServiceLevel;

//========================================================================================
//
//========================================================================================
SERVICE_STATUS_HANDLE CipeServiceBase::m_ServiceStatusHandle = 0;

SERVICE_STATUS CipeServiceBase::m_ServiceStatus;

SC_HANDLE CipeServiceBase::m_ManagerHandle;

SC_HANDLE CipeServiceBase::m_ServiceHandle;

//========================================================================================
//
//========================================================================================
void CipeServiceBase::OpenMgrHandle() throw (CipeServiceBaseException)
   {
    if (! (m_ManagerHandle = OpenSCManager (NULL, NULL, SC_MANAGER_ALL_ACCESS)))
       {
        DbgPrint ("[SERVICE_MANAGER] Couldn't open service manager\n");
        throw CipeServiceBaseException();
       }
   }

void CipeServiceBase::CloseMgrHandle()
   {
    CloseServiceHandle (m_ManagerHandle);
   }

//========================================================================================
//
//========================================================================================
void CipeServiceBase::OpenSvcHandle (string &p_Name) throw (CipeServiceBaseException)
   {
    OpenMgrHandle();

    if (! (m_ServiceHandle = OpenService (m_ManagerHandle, p_Name.c_str(), SERVICE_ALL_ACCESS)))
       {
        CloseMgrHandle();
        throw CipeServiceBaseException();
       }
   }

void CipeServiceBase::CloseSvcHandle()
   {
    CloseServiceHandle (m_ServiceHandle);
   }

void CipeServiceBase::GetSvcInfo (SERVICE_STATUS &p_Status)
   {
    if (! QueryServiceStatus (m_ServiceHandle, &p_Status))
       {
        p_Status.dwCurrentState = SERVICE_STOPPED;
       }
   }

unsigned long CipeServiceBase::GetSvcState (string &p_Name)
   {
    SERVICE_STATUS l_Status;

    try
       {
        l_Status.dwCurrentState = SERVICE_STOPPED;
        OpenSvcHandle (p_Name);
        GetSvcInfo (l_Status);
        CloseSvcHandle();
       }
    catch (CipeServiceBaseException &e_Exception)
       {
       }

    return l_Status.dwCurrentState;
   }

BOOL CipeServiceBase::SvcExists (string &p_Name)
   {
    BOOL l_Return = FALSE;

    try
       {
        OpenSvcHandle (p_Name);
        CloseSvcHandle();
        l_Return = TRUE;
       }
    catch (CipeServiceBaseException &e_Exception)
       {
       }

    return l_Return;
   }

BOOL CipeServiceBase::InstallSvc (string &p_Name, string &p_Executable, string &p_DisplayName)
   {
    BOOL l_Return =  FALSE;

    if (! (l_Return = SvcExists (p_Name)))
       {
        try
           {
            if (SvcExists (p_Name))
               {
                DbgPrint ("[SERVICE_MANAGER] service [%s] already exists\n", p_Name.c_str());
                throw CipeServiceBaseException();
               }

            OpenMgrHandle();

            m_ServiceHandle = CreateService
               ( 
                m_ManagerHandle,
                p_Name.c_str(),
                p_DisplayName.c_str(),
                SERVICE_ALL_ACCESS,
                SERVICE_WIN32_OWN_PROCESS,
                SERVICE_AUTO_START, // SERVICE_DEMAND_START
                SERVICE_ERROR_NORMAL,
                p_Executable.c_str(),
                "NDIS", // Make it start with NDIS group. (This used to be NULL)
                NULL,
                NULL,
                NULL,
                NULL
               );

           if (m_ServiceHandle)
              {
               DbgPrint ("[SERVICE_MANAGER] service [%s] was successfully installed\n", p_Name.c_str());
               CloseSvcHandle();
               l_Return = TRUE;
              }

            CloseMgrHandle();
           }
        catch (CipeServiceBaseException &e_Exception)
           {
           }
       }

    return l_Return;
   }

BOOL CipeServiceBase::RemoveSvc (string &p_Name)
   {
    BOOL l_Return = FALSE;

    if (StopSvc (p_Name))
       {
        try
           {
            OpenSvcHandle (p_Name);

            if (l_Return = DeleteService (m_ServiceHandle))
               DbgPrint ("[SERVICE_MANAGER] service deleted [%s]\n", p_Name.c_str());
            else
               DbgPrint ("[SERVICE_MANAGER] failed to remove service [%s]\n", p_Name.c_str());

            CloseSvcHandle();
           }
        catch (CipeServiceBaseException &e_Exception)
           {
           }
       }

    return l_Return;
   }

BOOL CipeServiceBase::StartSvc (string &p_Name)
   {
    BOOL l_Return = FALSE;

    if (! SvcExists (p_Name))
        DbgPrint ("[SERVICE_MANAGER] service [%s] does not exist\n", p_Name.c_str());
    else if (GetSvcState (p_Name.c_str()) == SERVICE_RUNNING)
       DbgPrint ("[SERVICE_MANAGER] service [%s] has already been started\n", p_Name.c_str()), l_Return = TRUE;
    else
       {
        try
           {
            OpenSvcHandle (p_Name);
            DbgPrint ("[SERVICE_MANAGER] Starting service [%s]\n", p_Name.c_str());
            StartService (m_ServiceHandle, 0, NULL);
            CloseSvcHandle();
           }
        catch (CipeServiceBaseException &e_Exception)
           {
           }

        if (l_Return = WaitSvc (p_Name, SVC_STATE_STARTED))
           {
            DbgPrint ("[SERVICE_MANAGER] Service [%s] has been started\n", p_Name.c_str());
           }
       }

    return l_Return;
   }

BOOL CipeServiceBase::StopSvc (string &p_Name)
   {
    BOOL l_Return = FALSE;

    if (! SvcExists (p_Name))
       DbgPrint ("[SERVICE_MANAGER] service [%s] does not exist\n", p_Name.c_str());
    else if (GetSvcState (p_Name.c_str()) == SERVICE_STOPPED)
       DbgPrint ("[SERVICE_MANAGER] service [%s] has already been stopped\n", p_Name.c_str()), l_Return = TRUE;
    else
       {
        SERVICE_STATUS l_Status;

        try
           {
            OpenSvcHandle (p_Name);
            DbgPrint ("[SERVICE_MANAGER] Stopping service [%s]\n", p_Name.c_str());
            ControlService (m_ServiceHandle, SERVICE_CONTROL_STOP, &l_Status);
            Sleep (DAEMON_SELECT_TIMEOUT);
            CloseSvcHandle();
           }
        catch (CipeServiceBaseException &e_Exception)
           {
           }

        if (l_Return = WaitSvc (p_Name, SVC_STATE_STOPPED))
           {
            DbgPrint ("[SERVICE_MANAGER] Service [%s] has been stopped\n", p_Name.c_str());
           }
       }

    return l_Return;
   }

BOOL CipeServiceBase::WaitSvc (string &p_Name, SVC_STATE_QUERY p_State)
   {
    BOOL l_Return = FALSE;

    if (SvcExists (p_Name)) for (int l_Retry = 16; l_Retry > 0 && ! l_Return; --l_Retry)
       {
        switch (GetSvcState (p_Name.c_str()))
           {
            case SERVICE_RUNNING:
               {
                if (p_State == SVC_STATE_STARTED) l_Return = TRUE;
                break;
               }

            case SERVICE_STOPPED:
               {
                if (p_State == SVC_STATE_STOPPED) l_Return = TRUE;
                break;
               }

            case SERVICE_START_PENDING:
            case SERVICE_STOP_PENDING:
            default:
               {
                break;
               }
           }

        Sleep (2000);
       }

    return l_Return;
   }

//========================================================================================
//                        "Convenience" functions
//========================================================================================
BOOL CipeServiceBase::InstallCipeService()
   {
    return InstallSvc
       (
        string (CIPE_SERVICE_NAME),
        (SystemDir() + "\\cipsrvr.exe"),
        (MyProductName() + " Service")
       );
   }

BOOL CipeServiceBase::RemoveCipeService()
   {
    return RemoveSvc (CIPE_SERVICE_NAME);
   }

//========================================================================================
//                                   End of Source
//========================================================================================
