#include "CipeTaskIO.h"
#include "hexdump.h"

        // Remember, too that the processes can be waited
        // on their OpenProcess handles just like sockets and files

//========================================================================================
//
//========================================================================================
CipeTaskIO::CipeTaskIO() throw (CipeTaskIOException) : m_Name ("JOB HANDLER")
   {
    m_LastCommand = 0;

    CloseHandle (m_OverlappedEx.hEvent);
    CloseHandle (m_Overlapped.hEvent);

    m_OverlappedEx.hEvent = NULL;
    m_Overlapped.hEvent = NULL;
   }

//========================================================================================
//
//========================================================================================
void CipeTaskIO::Send (CipePacketDescriptor &p_Buffer)
   {
    if (p_Buffer.length > 0 && p_Buffer.length < sizeof (CipePacketDescriptor))
       {
        p_Buffer.buffer [p_Buffer.length] = 0;
        push (strdup ((const char *) p_Buffer.buffer));
        RequestAsyncReceive();
       }
   }

void CipeTaskIO::RequestAsyncReceive()
   {
    if (! CheckForShutdownIndication() && m_LastCommand == 0 && size())
       {
        GetStartupInfo (&m_StartupInfo);

        DbgPrint ("[%s] Starting [%s]. %ld items in queue\n", Name().c_str(), front(), size());

        BOOL l_Result = CreateProcess
           (
            NULL,
            m_LastCommand = front(),
            NULL,
            NULL,
            FALSE,
            CREATE_SEPARATE_WOW_VDM | CREATE_DEFAULT_ERROR_MODE | IDLE_PRIORITY_CLASS | CREATE_NEW_CONSOLE,
            NULL,
            "c:\\",
            &m_StartupInfo,
            &m_ProcessInfo
           );

        if (l_Result)
           {
            m_Overlapped.hEvent = m_ProcessInfo.hProcess;
           }
        else
           {
            DbgPrint ("Failed to start [%s]\n", m_LastCommand);
            free (m_LastCommand);
            m_LastCommand = 0;
           }

        pop();
       }
   }

void CipeTaskIO::CompleteAsyncReceive()
   {
    unsigned long l_State;

    if (GetExitCodeProcess (m_ProcessInfo.hProcess, &l_State) && l_State != STILL_ACTIVE)
       {
        DbgPrint ("[%s] Task [%s] finished\n", Name().c_str(), m_LastCommand);
        m_Overlapped.hEvent = m_ProcessInfo.hProcess = NULL;
        free (m_LastCommand);
        m_LastCommand = 0;
       }
   }

//========================================================================================
//
//========================================================================================
void CipeTaskIO::Enjoin (CipeGenericIO &p_Object)
   {
   }

//========================================================================================
//                                   End of Source
//========================================================================================
