#ifndef CIPE_TYPES_DEFINED
#define CIPE_TYPES_DEFINED

//===========================================================================================
//
//===========================================================================================
typedef PVOID LITEM;

typedef enum 
   {
    LMODE_STACK,
    LMODE_QUEUE
   }
LMODE;

typedef struct LNODESTRUCT
   {
    struct LNODESTRUCT *m_Next, *m_Previous;
    LITEM m_Payload;
   }
*LNODE;

typedef struct LROOTSTRUCT
   {
    ULONG m_Count, m_Limit;
    LNODE m_First, m_Last;
   }
*LROOT;

//===========================================================================================
//
//===========================================================================================
typedef struct _CipeAdapter;
typedef struct _CipePacket;

typedef union _CipeAdapterQuery
   {
    NDIS_HARDWARE_STATUS m_HardwareStatus;
    NDIS_MEDIUM m_Medium;
    UCHAR m_MacAddress [6];
    UCHAR m_Buffer [256];
    ULONG m_Long;
    USHORT m_Short;
    UCHAR m_Byte;
   }
CipeAdapterQuery, *CipeAdapterQueryPointer;

typedef struct _CipeTapExtension
   {
    struct LROOTSTRUCT m_PacketQueue, m_IrpQueue;
    struct _CipeAdapter *m_Adapter;
   }
CipeTapExtension, *CipeTapExtensionPointer;

typedef struct _CipePacket
   {
    ULONG m_Size;
    UCHAR m_Data [1]; // Do NOT rearrange the order here, m_Buffer MUST be last !!
   }
CipePacket, *CipePacketPointer;

typedef struct _CipeAdapter
   {
    unsigned char m_MAC [6], *m_Name, *m_TapName;
    BOOLEAN m_TapIsRunning, m_InterfaceIsRunning;
    NDIS_HANDLE m_MiniportAdapterHandle;
    ULONG m_Rx, m_Tx, m_RxErr, m_TxErr;
    UNICODE_STRING m_UnicodeLinkName;
    PDEVICE_OBJECT m_TapDevice;
    NDIS_SPIN_LOCK m_Lock;
    NDIS_MEDIUM m_Medium;
    ULONG m_Lookahead;
    ULONG m_TapOpens;
   }
CipeAdapter, *CipeAdapterPointer;

#endif

