#ifndef CipeGenericIODefined
#define CipeGenericIODefined

#include "constants.h"
#include "windows.h"
#include "winsock2.h"

#include "CipePeer.h"
#include "CipeBase.h"
#include "CipeTypes.h"
#include "string"

using namespace std;

//========================================================================================
//
//========================================================================================
class CipeGenericIOException
   {
   };

class CipeGenericIO : public CipeBase
   {
    protected: static MACADDR m_NextMAC;

    protected: WSAOVERLAPPED m_Overlapped, m_OverlappedEx;
               unsigned long m_TxErr, m_RxErr, m_Tx, m_Rx;
               BOOL m_Synchronous, m_ShutdownIndicated;
               CipePacketDescriptor m_Buffer;
               MACADDR m_MAC;

    public:    CipeGenericIO() throw (CipeGenericIOException);

    public:    virtual string &AssociateName() {return string ("");}
               virtual unsigned long Address() = 0;
               virtual string &Name() = 0;

    public:    virtual unsigned long TxErr()  {return m_TxErr;}
               virtual unsigned long RxErr()  {return m_RxErr;}
               virtual unsigned long Tx()     {return m_Tx;}
               virtual unsigned long Rx()     {return m_Rx;}

    public:    virtual void Send (CipePacketDescriptor &p_Buffer);
               void Send (string &p_String);

    public:    virtual void RequestAsyncReceive() = 0;
               virtual void CompleteAsyncReceive();
               virtual BOOL CheckForShutdownIndication();
               virtual void TimeoutEvent(){}
               virtual void Shutdown();

    public:    virtual void Enjoin (CipeGenericIO &p_Object) = 0;

    public:    void EventReset();
               void CopyMAC();

    public:    HANDLE &EventHandle()       {return m_Overlapped.hEvent;}
               WSAOVERLAPPED &Overlapped() {return m_Overlapped;}
               MACADDR &MAC()              {return m_MAC;}

    private:   static BOOL m_CipeGenericInitialized;
               static void ClassConstructor();
   };

//========================================================================================
//                                   End of Source
//========================================================================================
#endif
