#ifndef CipeTypesDefined
#define CipeTypesDefined

#include "constants.h"

//========================================================================================
//
//========================================================================================
typedef struct
   {
    unsigned short MacAddressType;      // 0x0001
    unsigned short ProtocolAddressType; // 0x0800
    unsigned char  MacAddressSize;      // 0x06
    unsigned char  ProtocolAddressSize; // 0x04
    unsigned short Operation;           // 0x0001 for ARP request, 0x0002 for ARP reply
    MACADDR        SourceMAC;
    IPADDR         SourceIP;
    MACADDR        DestinationMAC;
    IPADDR         DestinationIP;
   }
CipeArpInfo;

typedef struct
   {
    MACADDR        destination;        // Reverse these two
    MACADDR        source;             // to answer ARP requests
    unsigned short type;               // 0x0806 for ARP, 0x0800 for IP
   }
CipeMacInfo;

extern "C"
   {
    typedef struct
       {
        unsigned long crc;
       }
    CipeACK;

    typedef struct
       {
        unsigned char keydata [0];
       }
    CipeIND;

    typedef struct
       {
        unsigned char type;

        union
           {
            CipeACK ack;
            CipeIND ind;
           };
       }
    CipeNK;

    typedef struct
       {
        unsigned char  version_info;
        unsigned char  service_type;
        unsigned short length;
        unsigned short id;
        unsigned short flags;
        unsigned char  ttl;
        unsigned char  protocol;
        unsigned short checksum;
        unsigned long  source;
        unsigned long  destination;
        unsigned char  options [0];
       }
    CipeIpInfo;
   }

typedef struct
   {
    unsigned long length;
    unsigned long flags;

    union
       {
        struct
           {
            CipeMacInfo mac;

            union
               {
                UDPBUFFER   raw;
                CipeArpInfo arp;
                CipeIpInfo  ip;
                CipeNK      nk;
               };
           };

        unsigned char buffer [1];
       };
   }
CipePacketDescriptor;

#define DescriptorSize() (sizeof (CipePacketDescriptor) - (sizeof (unsigned long) * 2))

#endif
//========================================================================================
//                              End Of Source
//========================================================================================

