
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <gnutls/gnutls.h>
#include <gnutls/extra.h>

#define MAX_BUF 1024
#define USERNAME "user"
#define PASSWORD "pass"
#define SA struct sockaddr
#define MSG "GET / HTTP/1.0\r\n\r\n"

const int protocol_priority[] = { GNUTLS_TLS1, GNUTLS_SSL3, 0 };
const int kx_priority[] = { GNUTLS_KX_SRP, 0 };
const int cipher_priority[] = { GNUTLS_CIPHER_3DES_CBC, 
                                GNUTLS_CIPHER_ARCFOUR_128, 0};
const int comp_priority[] = { GNUTLS_COMP_NULL, 0 };
const int mac_priority[] = { GNUTLS_MAC_SHA, GNUTLS_MAC_MD5, 0 };

int main()
{
   const char *PORT = "443";
   const char *SERVER = "127.0.0.1";
   int err, ret;
   int sd, ii;
   struct sockaddr_in sa;
   gnutls_session state;
   char buffer[MAX_BUF + 1];
   gnutls_srp_client_credentials xcred;

   if (gnutls_global_init() < 0) {
      fprintf(stderr, "global state initialization error\n");
      exit(1);
   }

   /* now enable the gnutls-extra library which contains the
    * SRP stuff. */
   if (gnutls_global_init_extra() < 0) {
      fprintf(stderr, "global state initialization error\n");
      exit(1);
   }

   if (gnutls_srp_allocate_client_credentials(&xcred) < 0) {
      fprintf(stderr, "memory error\n");
      exit(1);
   }
   gnutls_srp_set_client_credentials(xcred, USERNAME, PASSWORD);

   /* connects to server 
    */
   sd = socket(AF_INET, SOCK_STREAM, 0);

   memset(&sa, '\0', sizeof(sa));
   sa.sin_family = AF_INET;
   sa.sin_port = htons(atoi(PORT));
   inet_pton(AF_INET, SERVER, &sa.sin_addr);

   err = connect(sd, (SA *) & sa, sizeof(sa));
   if (err < 0) {
      fprintf(stderr, "Connect error\n");
      exit(1);
   }
   /* Initialize TLS state 
    */
   gnutls_init(&state, GNUTLS_CLIENT);

   /* allow both SSL3 and TLS1
    */
   gnutls_protocol_set_priority(state, protocol_priority);
 
   /* allow only ARCFOUR and 3DES ciphers
    * (3DES has the highest priority)
    */
    gnutls_cipher_set_priority(state, cipher_priority);

   /* only allow null compression
    */
   gnutls_compression_set_priority(state, comp_priority);
 
   /* use GNUTLS_KX_SRP
    */
   gnutls_kx_set_priority(state, kx_priority);
 
   /* allow the usage of both SHA and MD5
    */
   gnutls_mac_set_priority(state, mac_priority);


   /* put the SRP credentials to the current state
    */
   gnutls_credentials_set(state, GNUTLS_CRD_SRP, xcred);

   gnutls_transport_set_ptr( state, (gnutls_transport_ptr)sd);

   /* Perform the TLS handshake
    */
   ret = gnutls_handshake( state);

   if (ret < 0) {
      fprintf(stderr, "*** Handshake failed\n");
      gnutls_perror(ret);
      goto end;
   } else {
      printf("- Handshake was completed\n");
   }

   gnutls_record_send( state, MSG, strlen(MSG));

   ret = gnutls_record_recv( state, buffer, MAX_BUF);
   if (gnutls_error_is_fatal(ret) == 1 || ret == 0) {
      if (ret == 0) {
         printf("- Peer has closed the GNUTLS connection\n");
         goto end;
      } else {
         fprintf(stderr, "*** Error: %s\n", gnutls_strerror(ret));
         goto end;
      }
   } else {
      if (ret == GNUTLS_E_WARNING_ALERT_RECEIVED || ret == GNUTLS_E_FATAL_ALERT_RECEIVED)
         printf("* Received alert [%d]\n", gnutls_alert_get(state));
      if (ret == GNUTLS_E_REHANDSHAKE)
         printf("* Received HelloRequest message (server asked to rehandshake)\n");
   }

   if (ret > 0) {
      printf("- Received %d bytes: ", ret);
      for (ii = 0; ii < ret; ii++) {
         fputc(buffer[ii], stdout);
      }
      fputs("\n", stdout);
   }
   gnutls_bye( state, 0);

 end:

   shutdown(sd, SHUT_RDWR);     /* no more receptions */
   close(sd);

   gnutls_deinit(state);

   gnutls_srp_free_client_credentials(xcred);

   gnutls_global_deinit();

   return 0;
}

