/* error.c - Error handling
 *  Copyright (C) 2001, 2002 Timo Schulz 
 *
 * This file is part of OpenCDK.
 *
 * OpenCDK is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version. 
 *  
 * OpenCDK is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU General Public License for more details. 
 *  
 * You should have received a copy of the GNU General Public License 
 * along with OpenCDK; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */ 

#include <stdio.h>

#include "opencdk.h"

const char *
cdk_strerror(int ec)
{
    static char buf[20];
	
    switch (ec) {
    case CDKERR_SUCCESS: return "No error";
    case CDKERR_GENERAL: return "General error";
    case CDKERR_FILE_OPEN: return "Could not open file";
    case CDKERR_FILE_READ: return "Could not read file";
    case CDKERR_FILE_WRITE: return "Could not write file";
    case CDKERR_BAD_SIGNATURE: return "Bad signature";
    case CDKERR_INV_PACKET: return "Invalid packet";
    case CDKERR_INV_ALGO: return "Invalid algorithm";
    case CDKERR_NOT_IMPLEMENT: return "This is not implemented yet";
    case CDKERR_GCRY: return "GCRYPT error";
    case CDKERR_ARMOR: return "ASCII armor error";
    case CDKERR_ARMOR_CRC: return "ASCII armored damaged (CRC error)";
    case CDKERR_MPI: return "Invalid or missformed MPI";
    case CDKERR_INV_VALUE: return "Invalid parameter or value";
    case CDKERR_NOKEY: return "No key available";
    case CDKERR_CHECKSUM: return "Check for key doesn't match";
    case CDKERR_EOF: return "End of file";
    case CDKERR_TIME_CONFLICT: return "Time conflict";
    case CDKERR_ZLIB: return "ZLIB error";
    case CDKERR_WEAK_KEY: return "Weak key was detected";
    case CDKERR_FILTER: return "Filter operation failed";
    case CDKERR_OUT_OF_CORE: return "Out of core!!";
    case CDKERR_WRONG_SECKEY: return "Wrong secret key";
    case CDKERR_BADMDC: return "Manipulated MDC detected";
    case CDKERR_INV_MODE: return "Invalid mode";
    case CDKERR_NOKEYRING: return "No keyring available";
    default:
        sprintf(buf, "ec=%d\n", ec);
        return buf;
    }
	
    return NULL;
} /* cdk_strerror */


