/* filters.h - Filter structs
 *        Copyright (C) 2002 Timo Schulz
 *
 * This file is part of OpenCDK.
 *
 * OpenCDK is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * OpenCDK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenCDK; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef CDK_FILTERS_H
#define CDK_FILTERS_H

typedef struct
{
  GCRY_CIPHER_HD cipher_hd;
  GCRY_MD_HD mdc_hash;
  int mdc_method;
  CDK_DEK dek;
  unsigned char enchash[20];
  unsigned long datalen;
  CDK_STREAM s;
} cipher_filter_s;

typedef struct
{
  int digest_algo;
  GCRY_MD_HD md;
  GCRY_MD_HD md2;  
} md_filter_s;

typedef struct
{
  const char *le; /* line endings */
  const char *hdrlines;
  unsigned long crc;
  int crc_okay;
  int idx;
  int idx2;
} armor_filter_s;

typedef struct
{
  int mode;
  char *filename;
  GCRY_MD_HD md;
} plaintext_filter_s;

typedef struct
{
  size_t inbufsize;
  unsigned char inbuf[8192];
  size_t outbufsize;
  unsigned char outbuf[8192];
  int algo; /* compress algo */
  int algo1hack;    
} compress_filter_s;

typedef struct 
{
  const char *lf;
} text_filter_s;


/*-- armor.c -*/
int armor_encode (void * opaque, FILE * in, FILE * out);
int armor_decode (void * opaque, FILE * in, FILE * out);

/*-- cipher.c --*/
int hash_filter (void * opaque, FILE * in, FILE * out);
int cipher_encode (void * opaque, FILE * in, FILE * out);
int cipher_decode (void * opaque, FILE * in, FILE * out);

/*-- plaintext.c --*/
int plaintext_encode (void * opaque, FILE * in, FILE * out);
int plaintext_decode (void * opaque, FILE * in, FILE * out);

int text_encode (void * opaque, FILE * in, FILE * out);
int text_decode (void * opaque, FILE * in, FILE * out);

/*-- compress.c --*/
int compress_encode (void * opaque, FILE * in, FILE * out);
int compress_decode (void * opaque, FILE * in, FILE * out);

#endif /* CDK_FILTERS_H */

        
