#!/usr/bin/perl -w

@patchfiles = ("include/net/ip.h", "include/linux/netlink.h", "net/protocols.c",
                "net/Config.in", "net/Makefile", "net/ipv4/igmp.c", 
                "net/ipv4/ip_input.c", "net/ipv4/ip_output.c", 
                "net/ipv4/tcp_ipv4.c", "net/core/dev.c", 
                "Documentation/Configure.help");
# files specific to REDHAT 6.2 stock kernel
@epatchfiles = ("arch/i386/defconfig");

$cpcmd = "/bin/cp";
$patchcmd = "/usr/bin/patch -f -s -u ";
$mknodcmd = "/bin/mknod ";

#run 'more' on instructions (manual and automated) and copyrights

print << "OUT0";


This script will attempt to install the kernel patches and sadb user
interface software.  Some effort has been made to catch errors and allow
the user to back out all changes.  However, it is still possible that
errors can occur that would make only partial changes to the kernel
resulting in a kernel that would not build or operate correctly without
more manual patch intervention.  Make sure you are running this on a
clean, non-volatile copy of the Linux 2.2 kernel source.

It is highly recommened that you read the INSTALL, README.ipsec,
README.sadb, and COPYRIGHTS documents before proceeding.  The INSTALL
document describes the actions of the script in detail which should help
with manually installing the patches.

OUT0

print "Do you want to proceed ([Y]/N) >";
$proceed = <>; chomp $proceed;
$proceed = ($proceed eq "N" || $proceed eq "n")?"N":"Y";

die "\nInstallation Aborted\n" if $proceed eq "N";

#ask for location of source to be patched

print "Location of Kernel to be patched >";
$location = <>; chomp $location;

#verify directory location and kernel version
die "No such directory: $location\n" if (! -d $location);

open(VHANDLE, $location."/Makefile") || die "No $location/Makefile file found\n";

foreach (<VHANDLE>)
{
	chomp;
	$version = $' if /^VERSION\s+=\s+/;
	$patchlevel = $' if /^PATCHLEVEL\s+=\s+/;
	$sublevel = $' if /^SUBLEVEL\s+=\s+/;
	$eversion = $' if /^EXTRAVERSION\s+=\s+/;
}

die "Must be installed on a 2.2.x kernel\nContact ipsec-dev\@antd.nist.gov for assistance\n" if (! (($version == 2) && ($patchlevel == 2)));

if ($sublevel == 14) 
{
	print "Installing on kernel version 2.2.$sublevel in $location.\n";
	print "Do you want to proceed ([Y]/N) >";
	$proceed = <>; chomp $proceed;
	$proceed = ($proceed eq "N" || $proceed eq "n")?"N":"Y";
}
else
{
print << "OUT1";
Installing on kernel version 2.2.$sublevel in $location.

This install script has been tested primarily with a 2.2.14 kernel.
It should work fine with any 2.2 kernel at or above sublevel 5 (2.2.5).
You may proceed, but patch failures may result. If this happens you
will be given the option to abort and backout any changes You would then
have to try to install the patches manually.  Otherwise you will have to
determine which patches failed and try to manually fix only those files.


OUT1
	print "Do you want to proceed (Y/[N]) >";
	$proceed = <>; chomp $proceed;
	$proceed = ($proceed eq "Y" || $proceed eq "y")?"Y":"N";
}

die "\nInstallation Aborted\n" if $proceed eq "N";

#backup files
foreach $file (@patchfiles)
{
	system($cpcmd." ".$location."/".$file." ".$location."/".$file.".pre-ipsec") if (! -e $location."/".$file.".pre-ipsec");
}

foreach $file (@epatchfiles)
{
	system($cpcmd." ".$location."/".$file." ".$location."/".$file.".pre-ipsec") if (! -e $location."/".$file.".pre-ipsec");
}

#apply each patch, on failure notify of failure and ask if complete backout is desired
foreach $pfile (@patchfiles)
{
	print "\n$patchcmd $location/$pfile $pfile.diff\n";
	$plist = `$patchcmd $location/$pfile $pfile.diff 2>&1`;
	if ($plist =~ /failed/)
	{
		print $plist;
		print "Patch had failures.\n";
		print "Do you want to restore ALL files and abort? (Y/[N])";
		$proceed = <>; chomp $proceed;
		goto RESTORE if ($proceed eq "y" || $proceed eq "Y");
		print "Do you want to restore THIS file? (Y/[N])";
		$proceed = <>; chomp $proceed;
	        system($cpcmd." ".$location."/".$pfile.".pre-ipsec ".$location."/".$pfile) if ($proceed eq "y" || $proceed eq "Y");
		print "Do you want to continue? ([Y]/N)";
		$proceed = <>; chomp $proceed;
		die "\nInstallation Aborted\n" if ($proceed eq "N" || $proceed eq "n");
	}
	else
	{
		print "$location/$pfile successfully patched\n\n";
	}
}

foreach $pfile (@epatchfiles)
{
        if ($eversion eq "-5.0")
        { 
		print "\n$patchcmd $location/$pfile $pfile.diff-5.0\n";
		$plist = `$patchcmd $location/$pfile $pfile.diff-5.0 2>&1`;
        }
        else
        {
		print "\n$patchcmd $location/$pfile $pfile.diff\n";
		$plist = `$patchcmd $location/$pfile $pfile.diff 2>&1`;
        }
	if ($plist =~ /failed/)
	{
		print $plist;
		print "Patch had failures.\n";
		print "Do you want to restore ALL files and abort? (Y/[N])";
		$proceed = <>; chomp $proceed;
		goto RESTORE if ($proceed eq "y" || $proceed eq "Y");
		print "Do you want to restore THIS file? (Y/[N])";
		$proceed = <>; chomp $proceed;
	        system($cpcmd." ".$location."/".$pfile.".pre-ipsec ".$location."/".$pfile) if ($proceed eq "y" || $proceed eq "Y");
		print "Do you want to continue? ([Y]/N)";
		$proceed = <>; chomp $proceed;
		die "\nInstallation Aborted\n" if ($proceed eq "N" || $proceed eq "n");
	}
	else
	{
		print "$location/$pfile successfully patched\n\n";
	}
}

#cp ipsec directory
system($cpcmd." -R net/ipsec ".$location."/net");
print "$location/net/ipsec directory created and copied\n\n";

#build user interface
unlink ("./sadb/Makefile");
open(MAKEFILE,">./sadb/Makefile");
print MAKEFILE "CFLAGS=-I$location/net -O2\n\n";
print MAKEFILE "all: sadb xsadb\n\n";
print MAKEFILE "sadb: sadb_ui.c\n";
print MAKEFILE "\tgcc \$(CFLAGS) -o sadb sadb_ui.c\n\n";
print MAKEFILE "xsadb: sadb-tcl/xsadb\n";
print MAKEFILE "\t(cd sadb-tcl ; make)\n";
print MAKEFILE "\tcp sadb-tcl/xsadb .\n\n";
print MAKEFILE "clean:\n";
print MAKEFILE "\trm -f sadb\n";
print MAKEFILE "\trm -f xsadb\n";
print MAKEFILE "\t(cd sadb-tcl ; make clean)\n";
close(MAKEFILE);
print "\n\nsadb user interface Makefile created and located in ./sadb\n";

#make the /dev/ipsec device
unlink ("/dev/ipsec");
system($mknodcmd." /dev/ipsec c 36 10");
print "\nipsec netlink device created in /dev/ipsec\n";

#make the /dev/ike device
unlink ("/dev/ike");
system($mknodcmd." /dev/ike c 36 15");
print "\nike netlink device created in /dev/ike\n";

#make the /dev/ike2 device
unlink ("/dev/ike2");
system($mknodcmd." /dev/ike2 c 36 14");
print "\nike netlink GETSPI device created in /dev/ike2\n";

#state final instructions (kernel config and build)

print << "OUT2";


Assuming that all went well, you are now ready to continue.  Change
directory to $location and configure the patched kernel, using your
favorite version of make config.  When configuring the new kernel,
make sure EXPERIMENTAL, NETLINK, and NETLINK_DEV are selected (they are
selected by default after running this script).  It is recommended that
you install the ipsec code as a module (select M for IPSEC).  Build and 
install the new kernel.  Build and install the ipsec module Once the kernel 
is built you can goto the sadb user interface directory and build the 
sadb and xsadb commands.  You will need to read the instructions in the
INSTALL file to finish setting up xsadb.  Then read the documentation 
(README.sadb, and sadb.n) on how to use the sadb user interface to setup 
security associations.

OUT2
exit;

RESTORE:
foreach $file (@patchfiles)
{
	system($cpcmd." ".$location."/".$file.".pre-ipsec ".$location."/".$file);
}
die "\nInstallation Aborted\n";
