# Makefile for GNU 386 assembler version under UNIX
CFLAGS = -O

destest: test.o deskey.o desspa.o desgnu.o des_util.o descbc.o
	cc -o destest test.o deskey.o desgnu.o desspa.o des_util.o descbc.o

certify: descerta testdata
	./descerta < testdata

descerta: descert.o deskey.o desspa.o desgnu.o
	cc -o descerta descert.o deskey.o desgnu.o desspa.o

descyclea: descycle.o deskey.o desgnu.o desspa.o
	cc -o descyclea descycle.o deskey.o desgnu.o desspa.o

destimea: unixtime.o deskey.o desgnu.o desspa.o descbc.o
	cc -o destimea unixtime.o deskey.o desgnu.o desspa.o descbc.o

# The SP boxes for the assembler version are left-rotated 3 bits
desspa.c: gensp
	./gensp a > desspa.c

gensp: gensp.c
	cc -O -o gensp gensp.c

# GNU as seems confused by what should be legal comments. Double quotes
# in comments apparently start strings that extend past the end of line,
# and the "# file 1" lines emitted by cpp also seem to confuse it. So
# we strip out all the offending material.
desgnu.o: desgnu.s
	cpp desgnu.s | tr -d '"' | sed -e '/^#/d' | as -o desgnu.o

	
#descerta: descert.o deskey.o desgnu.o desspa.o
