/* written by  Jeremy Nimmer */
/* distributed by Bruce Schneier, Applied Cryptography First Edition */
/* RC5_Key_Expand taken from RFC2040.txt */

#include "rc5.h"

#define Pw 0xb7e15163
#define Qw 0x9e3779b9
#define WW 4

/* Expand an RC5 user key.
 */
void RC5_Key_Expand (int b, unsigned char *K, unsigned long *S)
{

  int i, j, k, LL, t, T;
  unsigned long    L[256/WW];  /* Based on max key size */
  unsigned long    A, B;

  /* LL is number of elements used in L. */
  LL = (b + WW - 1) / WW;
  for (i = 0 ; i < LL ; i++)  {
      L[i] = 0;
  }
  for (i = 0 ; i < b ; i++)  {
      t = (K[i] & 0xFF) << (8*(i%4)); /* 0, 8, 16, 24*/
      L[i/WW] = L[i/WW] + t;
  }


  T = 2*(ROUNDS+1);
  S[0] = Pw;
  for (i = 1 ; i < T ; i++)  {
      S[i] = S[i-1] + Qw;
  }

  i = j = 0;
  A = B = 0;
  if (LL > T)
      k = 3 * LL; /* Secret key len > expanded key. */
  else
      k = 3 * T;  /* Secret key len < expanded key. */
  for ( ; k > 0 ; k--)  {
      A = ROTL(S[i] + A + B, 3);
      S[i] = A;
      B = ROTL(L[j] + A + B, A + B);
      L[j] = B;
      i = (i + 1) % T;
      j = (j + 1) % LL;
  }
  return;
} /* End of RC5_Key_Expand */

void RC5encrypt(unsigned long *in, rc5key key)
{
 register unsigned long a, b;
 int i;

 a = in[0];
 b = in[1];

 a += *key++;
 b += *key++;

 for (i = 0; i < ROUNDS; i++) {
  a ^= b;
  a = ROTL(a, b&31) + *key++;

  b ^= a;
  b = ROTL(b, a&31);
  b += *key++;
 }
 
 in[0] = a;
 in[1] = b;
}


void RC5decrypt(unsigned long *in, rc5key key)
{
 register unsigned long a, b;
 int i;

 a = in[0];
 b = in[1];

 key += KR;

 for (i = 0; i < ROUNDS; i++) {
  b -= *--key;
  b = ROTR(b, a&31) ^ a;

  a -= *--key;
  a = ROTR(a, b&31) ^ b;
 }

 b -= *--key;
 a -= *--key;

 in[0] = a;
 in[1] = b;
}

