#include <string.h>
#include <stdio.h>
#include <sys/time.h>

#include "rc5.h"

static unsigned char plaintext[16] = {0x10,0x20,0x30,0x40,0x50,0x60,0x70,0x80,0x11,0x22,0x33,0x44,0x55,0x66,0x77,0x88};
static unsigned char iv[8] = {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08};
static unsigned char key[8] = {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08};

main()
{
unsigned char a[16],b[8];
rc5key k;
unsigned long l1,l2;
unsigned long i;
struct timeval start,stop;
long elapsed;
double s;

bcopy(plaintext,a,16);
bcopy(iv,b,8);
RC5_Key_Expand(8,key,k);
printf("\n output = ");
for(i=0;i<16;i++) printf("%02x",a[i]);
printf("\n");
#if 1
rc5_cbc_encrypt(a,16,k,b,1);
#endif
printf("\n output = ");
for(i=0;i<16;i++) printf("%02x",a[i]);
printf("\n");
#if 1
rc5_cbc_encrypt(a,16,k,b,0);
#endif
printf("\n output = ");
for(i=0;i<16;i++) printf("%02x",a[i]);
printf("\n");
  printf("starting RC5 time trial, 1,000,000 encryptions\n");
  gettimeofday(&start,NULL);
  for(i=0;i<1000000;i++)
    RC5encrypt ((unsigned long *)a,k);
  gettimeofday(&stop,NULL);

        elapsed = 1000*(stop.tv_sec - start.tv_sec) + (stop.tv_usec - start.tv_usec)/1000.;
        printf("execution time = %ld ms\n",elapsed);
        s = 1000.*1000000./elapsed;
        printf("%.1lf crypts/sec %.1lf bytes/sec %.1lf bits/sec",s,s*8,s*64);
        return 0;


}
