/* cipher_test.c */
/* ESP ONLY, This code assembles an ESP packet but does no encryption */

#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <net/ip.h>
#include <net/sock.h>
#include <linux/in.h>
#include <linux/in6.h>
#include <linux/skbuff.h>
#include <asm/uaccess.h>
#include <asm/checksum.h>
#include "../sadb.h"
#include "../ipsec.h"
#include "../transform.h"
#include "cipher_test.h"

static char addr_s1[18],addr_s2[18];

struct sk_buff *cipher_test_input(struct sk_buff *skb, struct sadb_dst_node *d, struct ipsec_transform *t)
{
        unsigned short dlen,pad_len;
        unsigned char ivec[MAX_CIPHER_TEST_IVEC_LENGTH];
        unsigned char *pdata=0;
        unsigned long spi=0;
        struct iphdr *iph = (struct iphdr *)skb->data;
	unsigned short ihl = iph->ihl<<2;
	int sn_length;

	bprintk(skb->data,skb->len,"IP Packet before Cipher Decapsulation");

        sn_length = d->sa_info.sn?4:0;

        pdata = skb_pull(skb,ihl);
        spi = d->sa_info.spi;

	if (d->sa_info.alg.esp.crypto_ivec_length)
	{
        	memcpy(ivec,pdata+sizeof(spi)+sn_length+d->sa_info.alg.esp.auth_ivec_length,d->sa_info.alg.esp.crypto_ivec_length);
	}
	else
	{
               *(unsigned long *)ivec = *(unsigned long *)(pdata+sizeof(spi));
               *(unsigned long *)(ivec+4) = (*(unsigned long *)(pdata+sizeof(spi)))^0xffffffff;
	}
        pdata = skb_pull(skb,sizeof(spi)+d->sa_info.alg.esp.auth_ivec_length+d->sa_info.alg.esp.crypto_ivec_length+sn_length);

        dlen = htons(iph->tot_len)- ihl - sizeof(spi)-d->sa_info.alg.esp.crypto_ivec_length-sn_length-
                d->sa_info.alg.esp.auth_ivec_length-(d->sa_info.alg.esp.auth_data_length<<2);

        pad_len = *(char *)(pdata+dlen-2);

        if (pad_len > MAX_TEST_PAD_LENGTH)
        {
                printk(KERN_INFO "%s: Inbound: Decryption Error: src %s dst %s spi %lx\n", CIPHERTEST_NAME,
                        strcpy(addr_s1,ntoa(iph->saddr)), strcpy(addr_s2,ntoa(iph->daddr)), spi);
                goto in_error;
        }


        iph->protocol=*(char *)(pdata+dlen-1);
        iph->tot_len = htons(dlen+ihl-pad_len-2);
        iph->check = 0;
        iph->check = ip_fast_csum((unsigned char *)iph,iph->ihl);
        skb_push(skb,ihl);

	/* IP header copy MUST be in tail to head order (hence r_memcpy) to avoid the (ihl<<2)-8 bytes of overlap */
        r_memcpy(skb->data,(unsigned char *)iph,ihl);
        skb_trim(skb,ihl+dlen-pad_len-2);
        skb->nh.raw=skb->data;
        skb->h.raw=skb->data+ihl;

	bprintk(skb->data,skb->len,"IP Packet after Cipher Decapsulation");

        return skb;

in_error:

        if (skb) kfree_skb(skb);
        return NULL;

}

struct sk_buff *cipher_test_output(struct sk_buff *skb, struct sadb_dst_node *d, struct ipsec_transform *t)
{
        struct rtable *rt=(struct rtable*)skb->dst;
        struct device *dev = rt->u.dst.dev;
        struct iphdr *iph = (struct iphdr *)skb->data;
        unsigned long spi;
        unsigned short dlen,plen,pad_len,ihl;
        unsigned char ivec[MAX_CIPHER_TEST_IVEC_LENGTH];
        int error,sn_length;
        struct sk_buff *tmpskb=0;

#define errout(e) { error = e; printk(KERN_INFO "%s: Outbound: Protocol Error %d\n", CIPHERTEST_NAME, e);goto out_error;}

	bprintk(skb->data,skb->len,"IP Packet before Cipher Encapsulation");

	sn_length = d->sa_info.sn?4:0;

        spi = d->sa_info.peer_spi;
/* plen = dlen */
        if (d->sa_info.flags & IPSEC_TUNNEL_FLAG)
	{
                plen = dlen = ntohs(iph->tot_len);
		ihl = 20;
	}
        else
	{
                plen = dlen = ntohs(iph->tot_len)-(iph->ihl<<2);
		ihl = iph->ihl<<2;
	}


/* Generate IVEC */
        generate_ivec(ivec,d->sa_info.alg.esp.crypto_ivec_length);

/* allocate skbuff to it's largest size possible */
        /* allocate skbuff to it's largest size possible */
        if (!(tmpskb = ipsec_alloc_skb(skb,sizeof(spi)+dlen+((dev->hard_header_len+15)&~15)+sn_length+
                ihl+d->sa_info.alg.esp.crypto_ivec_length+MAX_TEST_PAD_LENGTH+2+(d->sa_info.alg.esp.auth_data_length<<2)+
                d->sa_info.alg.esp.auth_ivec_length)))errout(ENOBUFS);

        skb_reserve(tmpskb,((dev->hard_header_len+15)&~15)+ihl+sn_length+
                d->sa_info.alg.esp.crypto_ivec_length+
                d->sa_info.alg.esp.auth_ivec_length+sizeof(spi));
        skb_put(tmpskb,dlen);

        /* add IP data */
        if (d->sa_info.flags & IPSEC_TUNNEL_FLAG)
                memcpy(tmpskb->data,skb->data,dlen);
        else 
                memcpy(tmpskb->data,skb->data+(iph->ihl<<2),dlen);

        pad_len = pad_data(tmpskb->data,dlen+2,dlen,8);
        skb_put(tmpskb,pad_len+2);

        *(char *)(tmpskb->data+dlen+pad_len)=pad_len;

/* store transport protocol type */
        if (d->sa_info.flags & IPSEC_TUNNEL_FLAG)
                *(char *)(tmpskb->data+dlen+pad_len+1)=IPPROTO_IPIP;
        else
                *(char *)(tmpskb->data+dlen+pad_len+1)=iph->protocol;

        skb_push(tmpskb,ihl+sizeof(spi)+sn_length+d->sa_info.alg.esp.crypto_ivec_length+
                d->sa_info.alg.esp.auth_ivec_length);
        memcpy(tmpskb->data,skb->data,ihl);
        spi = htonl(spi);
        memcpy(tmpskb->data+ihl,&spi,sizeof(spi));
        if (d->sa_info.sn)
        {
                unsigned long tmp_sn = ntohl(d->sa_info.sn);
                memcpy(tmpskb->data+ihl+sizeof(spi),&tmp_sn,sn_length);
                d->sa_info.sn++;
        }
        memcpy(tmpskb->data+ihl+sizeof(spi)+sn_length+d->sa_info.alg.esp.auth_ivec_length,
                ivec,d->sa_info.alg.esp.crypto_ivec_length);

        skb_put(tmpskb,(d->sa_info.alg.esp.auth_data_length<<2));

        iph = (struct iphdr *)tmpskb->data;
        iph->protocol = IPPROTO_ESP;

        iph->tot_len = htons(tmpskb->len);

        /* change address if IPIP encapsulation */
        /* fill in new header if tunneling */
        if (d->sa_info.flags & IPSEC_TUNNEL_FLAG){

                ip_rt_put(rt);
                error = ip_route_output(&rt,d->sa_info.peer_addr.addr_union.ip_addr.s_addr,0,iph->tos,0);
                if (error)errout(error);
                iph->saddr = rt->rt_src;
                iph->daddr = rt->rt_dst;
                iph->ihl = ihl>>2;
                iph->id = htons(ip_id_count++);
                iph->frag_off &= htons(IP_DF);
                iph->ttl = ip_statistics.IpDefaultTTL;

                tmpskb->dev = rt->u.dst.dev;
                tmpskb->dst = dst_clone(&rt->u.dst);
        }

	bprintk(tmpskb->data,tmpskb->len,"IP Packet after Cipher Encapsulation");

        if (skb) kfree_skb(skb);
        return tmpskb;

out_error:
        if (tmpskb) kfree_skb(tmpskb);
        if (skb) kfree_skb(skb);
        return NULL;

}

int cipher_test_sadb_add(struct sadb_dst_node *d)
{

        if (d->sa_info.protocol != IPPROTO_ESP)
        {
                printk(KERN_INFO "CIPHER_TEST: SADB: Invalid Protocol: dst %s spi %lx protocol %x\n",
                        strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi, d->sa_info.protocol);
                return 0;
        }


        d->sa_info.mss_delta = sizeof(d->sa_info.spi)+(d->sa_info.sn?4:0)+MAX_TEST_PAD_LENGTH+
                d->sa_info.alg.esp.crypto_ivec_length + d->sa_info.alg.esp.auth_ivec_length +
                (d->sa_info.alg.esp.auth_data_length<<2)+((d->sa_info.flags & IPSEC_TUNNEL_FLAG)?20:0)+2;
        ipsec_mss_delta = max(ipsec_mss_delta,d->sa_info.mss_delta);

	printk_sadb_dst_node(d);

	return 1;
}
