/* esp_idea_cbc.c */
/* ESP, IDEA-CBC transform specific code */

#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/skbuff.h>
#include <linux/errno.h>
#include <net/ip.h>
#include <net/sock.h>
#include <linux/in.h>
#include <linux/in6.h>
#include <asm/uaccess.h>
#include <asm/checksum.h>
#include "../crypto/idea/idea.h"
#include "../sadb.h"
#include "../ipsec.h"
#include "../transform.h"
#include "common_cipher.h"
#include "esp_idea_cbc.h"

static char addr_s2[18];

int esp_idea_cbc_sadb_add(struct sadb_dst_node *d)
{

	if (d->sa_info.protocol != IPPROTO_ESP)
	{
		printk(KERN_INFO "%s: SADB: Invalid Protocol: dst %s spi %lx protocol %x\n", ESP_IDEA_CBC_ALG_NAME,
			strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi, d->sa_info.protocol);
	  	return 0;
        }

	if (d->sa_info.sn != 1)
	{
		printk(KERN_INFO "%s: SADB: Sequence Number of 1 Required: dst %s spi %lx protocol %x\n", ESP_IDEA_CBC_ALG_NAME,
			strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi, d->sa_info.protocol);
	  	return 0;
	}

	if (d->sa_info.alg.esp.auth_alg_id == NO_ALG)
	{
		if ((d->sa_info.alg.esp.inbound_auth_key.key_len != 0) ||
		    (d->sa_info.alg.esp.outbound_auth_key.key_len != 0) ||
		    (d->sa_info.alg.esp.auth_ivec_length != 0) ||
		    (d->sa_info.alg.esp.auth_data_length != 0))
		{
			printk(KERN_INFO "%s: SADB: Auth. Parameters Exist, But No Authentication Specified: dst %s spi %lx\n", ESP_IDEA_CBC_ALG_NAME,
				strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi);
		  	return 0;
		}

	}
	if (d->sa_info.alg.esp.inbound_crypto_key.key_len != 16) 
	{
		printk(KERN_INFO "%s: SADB: Invalid Key Length: dst %s spi %lx len %d\n", ESP_IDEA_CBC_ALG_NAME,
			strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi, d->sa_info.alg.esp.inbound_crypto_key.key_len);
	  	return 0;
        }
	if ((d->sa_info.alg.esp.crypto_ivec_length != 8) && (d->sa_info.alg.esp.crypto_ivec_length != 0))
	{
		printk(KERN_INFO "%s: SADB: Invalid IV Length: dst %s spi %lx IV-Len %d\n", ESP_IDEA_CBC_ALG_NAME,
			strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi,d->sa_info.alg.esp.crypto_ivec_length);

		return 0;
        }
	if (memcmp(&d->sa_info.alg.esp.outbound_crypto_key,&d->sa_info.alg.esp.inbound_crypto_key,d->sa_info.alg.esp.outbound_crypto_key.key_len))
	{
            	printk(KERN_INFO "%s: SADB: Enc & Dec Key Not Same : dst %s spi %lx\n", ESP_IDEA_CBC_ALG_NAME,
			strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi);
		return 0;
	}
/* Weak Key Check TBD */
	if (!(d->sa_info.alg.esp.outbound_crypto_key.fast_key = (unsigned char *)kmalloc(sizeof(IDEA_KEY_SCHEDULE),GFP_ATOMIC)))
	{
            	printk(KERN_INFO "%s: SADB: No Buffer Space for Fast Key: dst %s spi %lx\n", ESP_IDEA_CBC_ALG_NAME,
			strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi);
		return 0;
	}
	if (!(d->sa_info.alg.esp.inbound_crypto_key.fast_key = (unsigned char *)kmalloc(sizeof(IDEA_KEY_SCHEDULE),GFP_ATOMIC)))
	{
            	printk(KERN_INFO "%s: SADB: No Buffer Space for Fast Key: dst %s spi %lx\n", ESP_IDEA_CBC_ALG_NAME,
			strcpy(addr_s2,ntoa(d->dst.addr_union.ip_addr.s_addr)), d->sa_info.spi);
		return 0;
	}

	idea_set_encrypt_key( d->sa_info.alg.esp.outbound_crypto_key.key_data, 
		(IDEA_KEY_SCHEDULE *)d->sa_info.alg.esp.outbound_crypto_key.fast_key);
	idea_set_decrypt_key( (IDEA_KEY_SCHEDULE *)d->sa_info.alg.esp.outbound_crypto_key.fast_key,
		(IDEA_KEY_SCHEDULE *)d->sa_info.alg.esp.inbound_crypto_key.fast_key);

	d->sa_info.alg.esp.outbound_auth_key.fast_key = 0;
	d->sa_info.alg.esp.inbound_auth_key.fast_key = 0;

        d->sa_info.mss_delta = sizeof(d->sa_info.spi)+(d->sa_info.sn?4:0)+MAX_PAD_LENGTH+
                d->sa_info.alg.esp.crypto_ivec_length + d->sa_info.alg.esp.auth_ivec_length +
                (d->sa_info.alg.esp.auth_data_length<<2)+((d->sa_info.flags & IPSEC_TUNNEL_FLAG)?20:0)+2;
        ipsec_mss_delta = max(ipsec_mss_delta,d->sa_info.mss_delta);

	return 1;
}
void esp_idea_cbc_sadb_delete(struct sadb_dst_node *d)
{

 	if(d->sa_info.alg.esp.outbound_crypto_key.fast_key) 
		kfree(d->sa_info.alg.esp.outbound_crypto_key.fast_key);
	d->sa_info.alg.esp.inbound_crypto_key.fast_key = 0;
}
