/* This program is an implementation of the IKE Internet Standard.
 * PlutoPlus Copyright (C) 1999 Sheila Frankel - for details see COPYING.
 * Pluto Copyright (C) 1997 Angelos D. Keromytis - for details see COPYING.others.
 */

/* br.h -
 * 	This file is used by the crypto routines to reverse the byte order
 * 	on the appropriate ENDIAN machines
 */

#include <sys/types.h>
#include <asm/byteorder.h>

static __inline__ void ByteReverse( unsigned long *buffer, int byteCount )
{
register unsigned long value;
register int count;

    byteCount /= sizeof( unsigned long );
    for( count = 0; count < byteCount; count++ )
    {
    value = ( buffer[ count ] << 16 ) | ( buffer[ count ] >> 16 );
    buffer[ count ] = ( ( value & 0xFF00FF00L ) >> 8 ) | ( ( value & 0x00FF00FFL ) << 8 );
    }
}

#ifdef __LITTLE_ENDIAN
#define LittleByteReverse(a,b) ByteReverse(a,b);
#else
#define LittleByteReverse(a,b) /* nothing */
#endif

#ifdef __BIG_ENDIAN
#define BigByteReverse(a,b) ByteReverse(a,b);
#else
#define BigByteReverse(a,b) /* nothing */
#endif
