/* This program is an implementation of the IKE Internet Standard.
 * PlutoPlus Copyright (C) 1999 Sheila Frankel - for details see COPYING.
 * Pluto Copyright (C) 1997 Angelos D. Keromytis - for details see COPYING.others.
 */

/* constants.h */

/* shortcuts to include files */
#define DES_H "/usr/src/linux/net/ipsec/crypto/des/des.h"
#define MD5_H "/usr/src/linux/net/ipsec/crypto/md5/md5.h"
#define SHA_H "/usr/src/linux/net/ipsec/crypto/sha/sha.h"

#define FULL_INET_ADDRESS_SIZE    6
#define DEFAULTGENERATOR "2"
#define GROUPDEFAULT "FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD1 29024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DD EF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245 E485B576 625E7EC6 F44C42E9 A63A3620 FFFFFFFF FFFFFFFF"
#define LOCALSECRETSIZE (256 / 8)	/* 256 bits */
#define DEFAULTNONCESIZE (128 / 8)	/* 128 bits */
#define MINIMUM_PUBLIC_VALUE_SIZE 32    
#define COOKIE_SIZE 8

#ifndef PORT
#define PORT 500
#endif

#define DES_CBC_BLOCK_SIZE        8

/* Timer events */
#define EVENT_REINIT_SECRET                     0 /* Refresh cookie secret */
#define EVENT_RETRANSMIT                        1 /* Retransmit packet */
#define EVENT_CLEANUP				2 /* Cleanup responder state */
#define EVENT_SA_EXPIRE				3 /* SA expiration event */

#ifdef WIT
#define EVENT_REINIT_SECRET_DELAY              30   /* 30 seconds */
#define EVENT_RETRANSMIT_DELAY                 15   /* 15 seconds */
#define EVENT_CLEANUP_DELAY	       			   30   /* 30 seconds */
#define END_PLUTO_DELAY                        30   /* 30 seconds */
#else
#define EVENT_REINIT_SECRET_DELAY               60   /* 1 minute   */
#define EVENT_RETRANSMIT_DELAY                  30   /* 30 seconds */
#define EVENT_CLEANUP_DELAY					    120  /* 2 minutes  */
#endif WIT

#define DEFAULT_SA_EXPIRE                       28800 /* 8 hours */

/* Misc. stuff */
#define SECRET_VALUE_LENGTH  20
#define ISAKMP_RESPONDER     0
#define ISAKMP_INITIATOR     1
#define MAXIMUM_RETRANSMISSIONS              2
#define UDP_SIZE             65536
#define ZERO_FILE            "/dev/zero"
#define LINUX_RANDOM_FILE    "/dev/urandom"

#ifdef DEBUG
#define SHARED_SECRETS_FILE  "./isakmp-secrets"
#define DEBUG_VERBOSE		0x1
#define DEBUG_PACKETS		0x2
#define DEBUG_VALUES		0x4
#else
#define SHARED_SECRETS_FILE  "/etc/isakmp-secrets"
#endif

/* Transport Protocol ID */
#define TRANSPORT_PROT_UDP     17
#define TRANSPORT_PROT_TCP     6

/* Version numbers */
#define ISAKMP_MAJOR_VERSION   0x1
#define ISAKMP_MINOR_VERSION   0x0

#define ISAKMP_DOI_IPSEC           1
#define IPSEC_DOI_SITUATION_LENGTH 4
#define IPSEC_DOI_LDI_LENGTH       4
#define DOI_SPI_SIZE_IPSEC      4
/* cf isakmp-09.txt &3.5 */
#define DOI_SPI_SIZE_ISAKMP_MAX 16
#define DOI_SPI_SIZE_ISAKMP_MIN 0
#define DOI_SPI_SIZE_ISAKMP     8

/* State of exchanges */
#define OAKLEY_MAIN_I_1       0
#define OAKLEY_MAIN_I_2       1
#define OAKLEY_MAIN_I_3       2
#define OAKLEY_MAIN_R_1       3
#define OAKLEY_MAIN_R_2       4
#define OAKLEY_MAIN_R_3       5
#define OAKLEY_MAIN_I_4       6
#define OAKLEY_QUICK_I_1      7
#define OAKLEY_QUICK_R_1      8
#define OAKLEY_QUICK_I_2      9
#define OAKLEY_QUICK_R_2      10
#define OAKLEY_QUICK_R_3      11

/* Payload types */
#define ISAKMP_NEXT_NONE       0	/* No other payload following */
#define ISAKMP_NEXT_SA         1	/* Security Association */
#define ISAKMP_NEXT_P          2	/* Proposal */
#define ISAKMP_NEXT_T          3	/* Transform */
#define ISAKMP_NEXT_KE         4	/* Key Exchange */
#define ISAKMP_NEXT_ID         5	/* Identification */
#define ISAKMP_NEXT_CERT       6	/* Certificate */
#define ISAKMP_NEXT_CR         7	/* Certificate Request */
#define ISAKMP_NEXT_HASH       8	/* Hash */
#define ISAKMP_NEXT_SIG        9	/* Signature */
#define ISAKMP_NEXT_NONCE      10	/* Nonce */
#define ISAKMP_NEXT_N          11	/* Notification */
#define ISAKMP_NEXT_D          12       /* Delete */
#define ISAKMP_NEXT_Vendor_ID  13       /* Vendor ID Payload */

/* Exchange types */
#define ISAKMP_XCHG_NONE       0
#define ISAKMP_XCHG_BASE       1
#define ISAKMP_XCHG_IDPROT     2/* ID Protection - Oakley Main mode */
#define ISAKMP_XCHG_AO         3	/* Authentication Only */
#define ISAKMP_XCHG_AGGR       4	/* Aggressive */
#define ISAKMP_XCHG_INFO       5	/* Informational */

/* Extra exchange types, defined by Oakley */
#define ISAKMP_XCHG_QUICK      32	/* Oakley Quick Mode */
#define ISAKMP_XCHG_NGRP       33	/* Oakley New Group Mode */

/* Flag bits */
#define ISAKMP_FLAG_ENCRYPTION   0x1
#define ISAKMP_FLAG_COMMIT       0x2

/* Situation definition for IPsec DOI */
#define SIT_IDENTITY_ONLY        0x01
#define SIT_SECRECY              0x02
#define SIT_INTEGRITY            0x04

/* Protocol IDs */
#define PROTO_RESERVED           0
#define PROTO_ISAKMP             1
#define PROTO_IPSEC_AH           2
#define PROTO_IPSEC_ESP          3
#define PROTO_IPCOMP             4

/* IPsec ISAKMP transform values */
#define KEY_RESERVED             0
#define KEY_OAKLEY               1

/* IPsec AH transform values */
#define AH_RESERVED1             0
#define AH_RESERVED2             1
#define AH_MD5                   2
#define AH_SHA                   3 
#define AH_DES                   4

/* ISAKMP ESP transform values */
#define ESP_DES_IV64             1
#define ESP_DES                  2
#define ESP_3DES                 3
#define ESP_RC5                  4
#define ESP_IDEA                 5
#define ESP_CAST                 6
#define ESP_BLOWFISH             7
#define ESP_3IDEA                8
#define ESP_DES_IV32             9
#define ESP_RC4                  10
#define ESP_NULL                 11

/* IPSEC DOI ISAKMP Authentication Algorithm attribute value */
#define AUTH_ALGO_RESERVED     0
#define AUTH_ALGO_HMAC_MD5     1
#define AUTH_ALGO_HMAC_SHA_1   2
#define AUTH_ALGO_DES_MAC      3
#define AUTH_ALGO_KPDK         4


/* SA attributes */
#define SA_LIFE_TYPE                   1   /* B */
#define SA_LIFE_DURATION               2   /* B/V */
#define SA_GROUP_DESCRIPTION           3   /* B */
#define SA_ENCAPSULATION_MODE          4   /* B */
#define SA_AUTHENTICATION_ALGORITHM    5   /* B */
#define SA_KEY_LENGTH                  6   /* B */
#define SA_KEY_ROUNDS                  7   /* B */
#define SA_COMPRESS_DICTIONNARY_SIZE   8   /* B */
#define SA_COMPRESS_PRIVATE_ALGORITHM  9   /* B/V */       

/* Identification type values */
#define ID_RESERVED                 0
#define ID_IPV4_ADDR                1
#define ID_FQDN                     2
#define ID_USER_FQDN                3
#define ID_IPV4_ADDR_SUBNET         4
#define ID_IPV6_ADDR                5
#define ID_IPV6_ADDR_SUBNET         6
#define ID_IPV4_ADDR_RANGE          7
#define ID_IPV6_ADDR_RANGE          8

/* Goals for establishing an SA */
#define GOAL_ENCRYPT                0x1
#define GOAL_AUTHENTICATE           0x2
#define GOAL_TUNNEL                 0x4
#define GOAL_KEYMANAGEMENT          0x8

/* Oakley transform attributes */
#define OAKLEY_ENCRYPTION_ALGORITHM   1
#define OAKLEY_HASH_ALGORITHM         2
#define OAKLEY_AUTHENTICATION_METHOD  3
#define OAKLEY_GROUP_DESCRIPTION      4
#define OAKLEY_GROUP_TYPE             5
#define OAKLEY_GROUP_PRIME            6
#define OAKLEY_GROUP_GENERATOR_ONE    7
#define OAKLEY_GROUP_GENERATOR_TWO    8
#define OAKLEY_GROUP_CURVE_A          9
#define OAKLEY_GROUP_CURVE_B          10
#define OAKLEY_LIFE_TYPE              11
#define OAKLEY_LIFE_DURATION          12
#define OAKLEY_PRF                    13
#define OAKLEY_KEY_LENGTH             14
#define OAKLEY_FIELD_SIZE             15
#define OAKLEY_GROUP_ORDER            16

/* SA Lifetime Type attribute */
#define SA_LIFE_TYPE_SECONDS   1
#define SA_LIFE_TYPE_KBYTES    2
#define SA_LIFE_DURATION_DEFAULT    28800 /* 8 hours */
#define SA_LIFE_DURATION_MINIMUM    60   /* 1 minute */
#define SA_LIFE_DURATION_MAXIMUM    86400 /* 24 hours */
#define SA_LIFE_DURATION_K_DEFAULT  0x7FFF
#define SA_LIFE_DURATION_K_MINIMUM  1

/* Lifetime of Partial SA - 
 *         necessary so kernel doesn't expire Partial SA before it's updated */
#define PARTIAL_SA_EXPIRE                       120 /* 2 minutes */

/* Default group for Phase 2 */
#define DEFAULT_GROUP    1

/* CA Distinguished name attribute */
#define CA_DISTINGUISHED_NAME_DNSSEC   1

/* Encapsulation Mode attribute */
#define ENCAPSULATION_MODE_RESERVED   0
#define ENCAPSULATION_MODE_TUNNEL     1
#define ENCAPSULATION_MODE_TRANSPORT  2

/* Oakley Lifetime Type attribute */
#define OAKLEY_LIFE_RESERVED  0
#define OAKLEY_LIFE_SECONDS   1
#define OAKLEY_LIFE_KILOBYTES 2
#define OAKLEY_ISAKMP_SA_LIFETIME_DEFAULT 86400    /* 24 hours */
#define OAKLEY_ISAKMP_SA_LIFETIME_MINIMUM 60    /* 1 minute */
#define OAKLEY_ISAKMP_SA_LIFETIME_MAXIMUM 86400   /* 24 hours */

/* Oakley PRF attribute */
#define OAKLEY_PRF_3DES_CBC_MAC   1

/* HMAC */
#define HMAC_IPAD            0x36
#define HMAC_OPAD            0x5C
#define HMAC_BUFSIZE         64

/* Oakley Encryption Algorithm attribute */
#define OAKLEY_DES_CBC          1
#define OAKLEY_IDEA_CBC         2
#define OAKLEY_BLOWFISH_CBC     3
#define OAKLEY_RC5_R12_B64_CBC  4
#define OAKLEY_3DES_CBC         5
#define OAKLEY_CAST_CBC         6

/* Oakley Hash Algorithm attribute */
#define OAKLEY_MD5      1
#define OAKLEY_SHA      2
#define OAKLEY_TIGER    3

/* Oakley Authentication Method attribute */
#define OAKLEY_PRESHARED_KEY       1
#define OAKLEY_DSS_SIG             2
#define OAKLEY_RSA_SIG             3
#define OAKLEY_RSA_ENC             4

/* Oakley Group Description attribute */
#define OAKLEY_DEFAULT_GROUP       1

/* Notify messages -- error types */
#define INVALID_PAYLOAD_TYPE     1
#define DOI_NOT_SUPPORTED        2
#define SITUATION_NOT_SUPPORTED  3
#define INVALID_COOKIE           4
#define INVALID_MAJOR_VERSION    5
#define INVALID_MINOR_VERSION    6
#define INVALID_EXCHANGE_TYPE    7
#define INVALID_FLAGS            8
#define INVALID_MESSAGE_ID       9
#define INVALID_PROTOCOL_ID      10
#define INVALID_SPI              11
#define INVALID_TRANSFORM_ID     12
#define ATTRIBUTES_NOT_SUPPORTED 13
#define NO_PROPOSAL_CHOSEN       14
#define BAD_PROPOSAL_SYNTAX      15
#define PAYLOAD_MALFORMED        16
#define INVALID_KEY_INFORMATION  17
#define INVALID_ID_INFORMATION   18
#define INVALID_CERT_ENCODING    19
#define INVALID_CERTIFICATE      20
#define BAD_CERT_REQUEST_SYNTAX  21
#define INVALID_CERT_AUTHORITY   22
#define INVALID_HASH_INFORMATION 23
#define AUTHENTICATION_FAILED    24
#define INVALID_SIGNATURE        25
#define ADDRESS_NOTIFICATION     26

/* Protocol & port needed for ID in ID/HASH Exchange */
#define ISAKMP_PROTO_UDP         17
#define ISAKMP_PORT              500

/* from in6.h, for IPSEC kernel communications */
#define IPSEC_IPPROTO_ESP	 50	/* encapsulating security payload */
#define IPSEC_IPPROTO_AH	 51	/* authentication header	*/

/* This is a fake protocol number, used by PlutoPlus to let the kernel
 *	know that a negotiation has failed and the peer's address should
 *	be zeroed out in the isakmp_addr_array, but no SADBM_UPDATE
 *	should be performed
 */
#define IPSEC_IPPROTO_NG 555

/* from ipsec.h, for IPSEC kernel communications */
/* IPSEC Cipher algorithms */
#define IPSEC_RFC_1829           1
#define IPSEC_ESP_DES_CBC        2
#define IPSEC_DES3_ALG           3
#define IPSEC_ESP_RC5_CBC        4
#define IPSEC_ESP_BLOWFISH_CBC   5
#define IPSEC_ESP_IDEA_CBC       6  
#define IPSEC_ESP_NULL           7  
/* IPSEC Authenticator algorithms */
#define IPSEC_RFC_1828           128
#define IPSEC_RFC_1852           129
#define IPSEC_AH_HMACMD5128      130
#define IPSEC_AH_HMACSHA192      131
#define IPSEC_HMACMD596          132
#define IPSEC_HMACSHA96          133
#define IPSEC_CIPHER_TEST_ALG    252
#define IPSEC_AUTH_TEST_ALG      253
#define IPSEC_NULL_ALG           254

/* Packet dump constants */
#define DUMP_MSG                 0
#define DUMP_SENT_BEFORE_ENC     1
#define DUMP_SENT_AFTER_ENC      2
#define DUMP_SENT_NO_ENC         3
#define DUMP_RECVD_BEFORE_DEC    4
#define DUMP_RECVD_AFTER_DEC     5
#define DUMP_RECVD_NO_DEC        6
#define DUMP_RECVD_OR_SENT_PKT   7

/* deskey constants - names are compatible with DES_ENCRYPT & DES_DECRYPT, 
   but values are opposite  */
#define DES_KEY_ENCRYPT          0
#define DES_KEY_DECRYPT          1

/* Flag bits in state structure */
#define ST_FLAG_OUTBOUND_EXPIRED   	0x1
#define ST_FLAG_INBOUND_EXPIRED    	0x2
#define ST_FLAG_OUTBOUND_DELETED        0x4
#define ST_FLAG_INBOUND_DELETED         0x8
#define ST_FLAG_REPL_FOUND         	0x10

/* some optimization */
#define SIZEOF_HDR_PAYLOAD       28       
#define SIZEOF_GENERIC_PAYLOAD   4
#define DES_KEY_SIZE 	         8
#define SIZEOF_KEY_SCHEDULE      sizeof(key_schedule)

#ifdef DEMO
#define DEMOI_FILE        "/usr/src/plutoplus/demoi"
#define DEMOR_FILE        "/usr/src/plutoplus/demor"
#endif DEMO
