/* This program is an implementation of the IKE Internet Standard.
 * PlutoPlus Copyright (C) 1999 Sheila Frankel - for details see COPYING.
 * Pluto Copyright (C) 1997 Angelos D. Keromytis - for details see COPYING.others.
 */

/*
 * cookie.c - This file contains cookie generation/verification routines.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "constants.h"
#include "defs.h"
#include SHA_H

/******************************************************************************* 
 * Generate a cookie, first  argument is true if we're to create an Initiator cookie.
 * Length SHOULD be a multiple of sizeof(u_int32_t). 
 * Called by oakley_initiate (ipsecdoi.c)
 * Called by ipsecdoi_handle_rfirst (ipsecdoi_mainxchg.c)
 */
void get_cookie(int             initiator, 
		u_char         *cookie, 
		int             length, 
		struct sockaddr sa)
{
  u_char  buffer[SECRET_VALUE_LENGTH];
  SHA_CTX shactx;
  int     i;

#ifdef DEBUG_IN_OUT  
  in_out_functions(" E get_cookie | in cookie.c");
#endif
  
  if (initiator == ISAKMP_INITIATOR)
    get_rnd_bytes(cookie, length);
  else  /* Responder cookie */
    {
      /* This looks as good as any way */
      /* To get an 8 byte cookie, 20 bytes are computed.*/
      SHAInit(&shactx);
      SHAUpdate(&shactx, (u_char *)&sa, sizeof(sa));
      SHAUpdate(&shactx, secret_of_the_day, SECRET_VALUE_LENGTH);
      SHAUpdate(&shactx, (u_char *)&sa, sizeof(sa));
      SHAFinal(&shactx);
      bcopy((&shactx)->buffer, buffer, 20);
      bcopy(buffer, cookie, length);
    }
#ifdef DEBUG_IN_OUT
  in_out_functions(" Q get_cookie | in cookie.c");
#endif
}
