/* This program is an implementation of the IKE Internet Standard.
 * PlutoPlus Copyright (C) 1999 Sheila Frankel - for details see COPYING.
 * Pluto Copyright (C) 1997 Angelos D. Keromytis - for details see COPYING.others.
 */

/*
 * demux.c - This file does basic header checking and demux of
 * 		incoming packets.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include "constants.h"
#include "state.h"
#include "packet.h"
#include "defs.h"
/* DES_H SHA_H MD5_H defined in constants.h */
#include DES_H 
#include SHA_H
#include MD5_H
#include "argdefs.h"

extern char *get_address();

#define PRINTADDRESS(x) (get_address(x) != (char *) NULL ? get_address(x) : "(unknown address family)")

/*
 * Receive a packet. If we pass buffer to a routine that does not return
 * failure indication (e.g. the packet handling routines), it's up to them
 * to free it; otherwise this routine does.
 * Called by : call_server (server.c)
 */
void comm_handle(int kernelfd, int sock)
{
  struct isakmp_notification *isan;
  struct isakmp_generic      *isag;
  struct sockaddr_in          sin;
  struct isakmp_hdr          *isa;
  struct isakmp_hdr           tisa;
  struct isakmp_sa           *isasa;
  struct state               *st;
  struct state               *nst;
  struct MD5Context           md5ctx;
  SHA_CTX                     shactx;
  unsigned long               des_cbc_keys[16][2];
  char                       *three_des_cbc_key;
  u_int32_t                   ipsecdoisit;
  u_char                     *buffer;
  u_char                      lastblock[256];	  /* Increase if block size larger */
  int                         length;
  int                         i;
  int                         i1;
  int                         k;
  int                         k1;
  int                         encrypted = 0;
  int                         lastblocksize;

  u_char *                      gros_tmp;
#ifdef DEBUG_IN_OUT
  in_out_functions(" E comm_handle | in demux.c");
#endif
  
  length = sizeof(sin);
  bzero(&sin, sizeof(sin));
  sin.sin_family = AF_INET;
  
  i = UDP_SIZE;  
  
  /* Now really read the message */
  if ( (i = recvfrom(sock, 
		     nullbuffer, 
		     i, 
		     0, 
		     (struct sockaddr *)&sin, 
		     &length) ) 
       == -1)
    {
      log(1, "Response not received from peer (recvfrom() failed in comm_handle)", 0, 0, 0);
#ifdef DEBUG_IN_OUT
      in_out_functions(" Q comm_handle | in demux.c -er1-");
#endif
      return;
    }
  
  if (i < sizeof(struct isakmp_hdr))
    {
      log(0, "received short packet: size = %d isakmp_hdrsize = %d", i, sizeof(struct isakmp_hdr), 0);
#ifdef DEBUG_IN_OUT
      in_out_functions(" Q comm_handle | in demux.c -er2-");
#endif
      return;
    }
  
  bcopy(nullbuffer, &tisa, sizeof(struct isakmp_hdr));
  
/* Save # of bytes actually read */
  i1 = i;
/* Reset i to Packet length from ISAKMP Header */
  i = ntohl(tisa.isa_length);
  
  if (i1 != i)
    {
/* XXX Could send notification NOTIFY_UNEQUAL_PAYLOAD_LENGTHS */
      log(0, "received malformed packet: actual packet size = %d packet length field = %d", i1, i, 0);
#ifdef DEBUG_IN_OUT
      in_out_functions(" Q comm_handle | in demux.c -er2-");
#endif
      return;
    }
  
  /* Allocate exactly that much space */
  buffer = (u_char *) calloc(i, sizeof(u_char));
  if (buffer == (u_char *) NULL)
    exit_log("calloc() failed in comm_handle()", 0, 0, 0);
  
  bcopy(nullbuffer, buffer, i);
  
  isa = (struct isakmp_hdr *) buffer;
  
#ifdef DEBUG
   fprintf(stdout, "Received : read %d bytes from %s, port %d (msgid=%x)\n", 
	i, PRINTADDRESS(sin), get_port(sin), ntohl(isa->isa_msgid));
#endif
  
#ifdef DEBUG
  if (arg_verbose & DEBUG_VERBOSE)
    	show_header(isa);
  if (arg_verbose & DEBUG_PACKETS)
	{
  	if (isa->isa_flags & ISAKMP_FLAG_ENCRYPTION) 
    		packet_dump(buffer, DUMP_RECVD_BEFORE_DEC, i);
  	else
    		packet_dump(buffer, DUMP_RECVD_NO_DEC, 0);
	}
#endif    
  
  if (isa->isa_maj != ISAKMP_MAJOR_VERSION)
    {
      free(buffer);
      log(0, "invalid major version number %d from %s, port %d", 
	  isa->isa_maj, PRINTADDRESS(sin), get_port(sin));
      /* XXX Could send a notification back */
#ifdef DEBUG_IN_OUT
      in_out_functions(" Q comm_handle | in demux.c -er3-");
#endif
      return;
    }
  
  if (isa->isa_min != ISAKMP_MINOR_VERSION)
    {
      free(buffer);
      log(0, "invalid minor version number %d from %s, port %d", 
	  isa->isa_min, PRINTADDRESS(sin), get_port(sin));
      /* XXX Could send a notification back */
#ifdef DEBUG_IN_OUT
      in_out_functions(" Q comm_handle | in demux.c --");
#endif

      return;
    }
  
  switch (isa->isa_xchg)
    {
    case ISAKMP_XCHG_IDPROT:	/* id protection */
    case ISAKMP_XCHG_QUICK:		/* Oakley Quick Mode */ 
    case ISAKMP_XCHG_INFO:		/* informational */
/* XXX	case ISAKMP_XCHG_AGGR: */	/* agressive */
      break;
    default:
      free(buffer);
      log(0, "unsupported exchange type %d from %s, port %d",
	  isa->isa_xchg, PRINTADDRESS(sin), get_port(sin));
      /* XXX Could send a notification back */
#ifdef DEBUG_IN_OUT
      in_out_functions(" Q comm_handle | in demux.c -er4-");
#endif
      return;
    }
  
  if ((isa->isa_xchg == ISAKMP_XCHG_IDPROT) &&	
      (isa->isa_msgid != 0))
    {
      free(buffer);
      log(0, "message id should be zero (was %08x) in base mode",
	  ntohl(isa->isa_msgid), 0, 0);
      /* XXX Could send notification back */
#ifdef DEBUG_IN_OUT
      in_out_functions(" Q comm_handle | in demux.c -er5-");
#endif
      return;
    }

#ifdef DEBUG
  if(arg_verbose & DEBUG_VERBOSE)
    {
      fprintf(stdout, "ICOOKIE : \t");
      for (i1 = 0; i1 < COOKIE_SIZE; i1++)
	fprintf(stdout, "%02x ", isa->isa_icookie[i1]); 
      fprintf(stdout, "\nRCOOKIE : \t");
      for (i1 = 0; i1 < COOKIE_SIZE; i1++)
	fprintf(stdout, "%02x ", isa->isa_rcookie[i1]); 
      fprintf(stdout, "\nMessage ID: \t%x\n", ntohl(isa->isa_msgid)); 
      fprintf(stdout, "address = %s\n", PRINTADDRESS(sin), 0, 0);
    }
#endif

  st = (struct state *) find_full_state(isa->isa_icookie, 
					isa->isa_rcookie,
					sin,
					isa->isa_msgid);

#ifdef DEBUG
  if (st && (arg_verbose & DEBUG_VERBOSE))
    fprintf(stdout, "Full state object found for Message ID %x: state = %d\n", 
		ntohl(isa->isa_msgid), st->st_state);
#endif

  if (isa->isa_flags & ISAKMP_FLAG_ENCRYPTION) 
    {
/* Phase 2 Informational Message - don't use the existing Phase 2 SA
		Force the creation of a new Phase 2 SA  */
  	if (isa->isa_xchg == ISAKMP_XCHG_INFO)
  		st = (struct state *) NULL;  
      if (st == (struct state *) NULL)
	{
#ifdef DEBUG
	  if (arg_verbose & DEBUG_VERBOSE)
	  	fprintf(stdout, 
		  "received encrypted packet from %s, port %d, for which no Phase 2 state can be found\n", 
		  PRINTADDRESS(sin), 
		  get_port(sin));
#endif
	  
	  /* Find the Phase 1 object */
	  st = (struct state *) find_full_state(isa->isa_icookie, isa->isa_rcookie, sin, 0);
	  if (st == (struct state *) NULL)
	    {
	      log(0, 
		  "attempt to use non-existent (expired?) ISAKMP SA with %s, port %d", 
		  PRINTADDRESS(sin), 
		  get_port(sin),
		  0);
	      free(buffer);
	      /* XXX Could send notification back */
#ifdef DEBUG_IN_OUT
	      in_out_functions(" Q comm_handle | in demux.c -er6-");
#endif
	      return;
	    }

	  if ((st->st_state != OAKLEY_MAIN_I_4) &&
	      (st->st_state != OAKLEY_MAIN_R_3))
	    {
	      log(0, 
		  "attempt to use non-fully established ISAKMP SA with %s, port %d", 
		  PRINTADDRESS(sin), 
		  get_port(sin),
		  0);
	      free(buffer);
	      /* XXX Could send notification back */
#ifdef DEBUG_IN_OUT
	      in_out_functions(" Q comm_handle | in demux.c -er7-");
#endif
	      return;
	    }
	  
#ifdef DEBUG
	  if (arg_verbose & DEBUG_VERBOSE)
	  	fprintf(stdout, "A phase 1 object has been found; use it\n");
#endif
	  nst = (struct state *) duplicate_state(st);
	  nst->st_msgid = isa->isa_msgid;
	  nst->st_state = OAKLEY_QUICK_R_1;
	  insert_state(nst);
	  
	  /* Quick Mode Initial IV */
	  if (nst->st_prf == 0)
	    {
	      switch (nst->st_hash)
		  {
		  case OAKLEY_MD5:
		    nst->st_iv_len = 16;
		    nst->st_iv = (u_char *) calloc(nst->st_iv_len, sizeof(u_char));
		    if (nst->st_iv == (u_char *) NULL)
		      exit_log("calloc() failed in comm_handle()", 
			       0, 0, 0);
		    MD5Init(&md5ctx);
		    MD5Update(&md5ctx, st->st_lastblock, st->st_lastblock_len);
		    MD5Update(&md5ctx, (u_char *) &(isa->isa_msgid), sizeof(isa->isa_msgid));
		    MD5Final(nst->st_iv, &md5ctx);
		    break;
		    
		  case OAKLEY_SHA:
		    nst->st_iv_len = 20;
		    nst->st_iv = (u_char *) calloc(nst->st_iv_len, sizeof(u_char));
		    if (nst->st_iv == (u_char *) NULL)
		      exit_log("calloc() failed in comm_handle()", 
			       0, 0, 0);
		    SHAInit(&shactx);
		    SHAUpdate(&shactx, st->st_lastblock, st->st_lastblock_len);
		    SHAUpdate(&shactx, (u_char *) &(isa->isa_msgid), sizeof(isa->isa_msgid));
		    SHAFinal(&shactx);
		    bcopy((&shactx)->buffer, nst->st_iv, 20);
		    break;
		    
		  default:
		    exit_log("unknown/unsupported hash algorithm %d specified in comm_handle()", 
			     nst->st_hash, 
			     0, 
			     0);
		  } /* end of the switch */
	    }     /* end of "if (nst->st_prf == 0)" */
	  else
	    {
	      /* XXX Handle 3DES MAC */
	    }
	  
#ifdef DEBUG
	  if (arg_verbose & DEBUG_VERBOSE)
	    {
	      fprintf(stdout, "computed phase 2 IV: ");
	      for (k = 0; k < nst->st_iv_len; k++)
		fprintf(stdout, "%02x ", nst->st_iv[k]);
	      fprintf(stdout, "\n");
	    }
#endif

	  st = nst;
	} /* end of "if (st == (struct state *) NULL)" */
      
#ifdef DEBUG
      		fprintf(stdout, "received encrypted packet from %s, port %d\n",
	  PRINTADDRESS(sin), get_port(sin));
#endif
      if ((st->st_skeyid_e == (u_char *) NULL) ||
	  (st->st_iv == (u_char *) NULL))
	{
	  free(buffer);
	  /* XXX Could send notification back */
	  log(0, "unexpected encrypted packet received from %s, port %d\n",
	      PRINTADDRESS(sin), get_port(sin), 0);
#ifdef DEBUG_IN_OUT
	  in_out_functions(" Q comm_handle | in demux.c -er8-");
#endif
	  return;
	}
      
      /* Mark as encrypted */
      encrypted = 1;

#ifdef DEBUG
      if (arg_verbose & DEBUG_PACKETS)
      {
        fprintf(stdout, "Decrypting %d bytes; algorithm: %s(%d) \n-----IV: ",
	      i - sizeof(struct isakmp_hdr), 
	      ((st->st_enc == OAKLEY_DES_CBC) ? "DES_CBC" : "3DES_CBC"),
	      st->st_enc);
	    format_dump(st->st_iv, st->st_iv_len);
      }
#endif
      
      switch (st->st_enc)
	{
	case OAKLEY_DES_CBC:
	  /* Copy last block in case we need it */
	  lastblocksize = DES_CBC_BLOCK_SIZE;
	  bcopy(buffer + i - lastblocksize, lastblock, lastblocksize);
	  /* Decrypt */
	  deskey(des_cbc_keys, st->st_skeyid_e, DES_KEY_DECRYPT);
	  des_cbc_encrypt(buffer + sizeof(struct isakmp_hdr),
			  i - sizeof(struct isakmp_hdr),
			  des_cbc_keys, 
			  st->st_iv, 
			  DES_DECRYPT);
#ifdef DEBUG
       if (arg_verbose & DEBUG_PACKETS)
	    packet_dump(buffer, DUMP_RECVD_AFTER_DEC, 0);
#endif

	  /* If not enough space, free it */
	  if ((st->st_iv != (u_char *) NULL) &&
	      (st->st_iv_len < lastblocksize))
	    {
	      free(st->st_iv);
	      st->st_iv = (u_char *) NULL;
	    }
	  
	  /* Allocate enough space */
	  if (st->st_iv == (u_char *) NULL)
	    {
	      st->st_iv = (u_char *) calloc(lastblocksize,
					    sizeof(u_char));
	      if (st->st_iv == (u_char *) NULL)
		exit_log("calloc() failed in comm_handle()", 0, 0, 0);
	    }
	  
	  /* Update the IV */
	  bcopy(lastblock, st->st_iv, lastblocksize);
	  st->st_iv_len = lastblocksize;

#ifdef DEBUG	  
	  if(arg_verbose & DEBUG_VERBOSE)
	    {
	      fprintf(stdout, "Updated IV:\t");
	      format_dump(st->st_iv, st->st_iv_len);
	      
	      fprintf(stdout, "Updated lastblock:\t");
	      format_dump(st->st_lastblock, st->st_lastblock_len);
	    }
#endif
	  break;
	  
	case OAKLEY_3DES_CBC:
	  /* Copy last block in case we need it */
	  lastblocksize = DES_CBC_BLOCK_SIZE;
	  bcopy(buffer + i - lastblocksize, lastblock, lastblocksize);
  /* Decrypt */
  /* Can either recompute the key and key material every time we receive 
   * a message encrypted with 3DES 
   * OR store the key or the key material in the state 
   * The second solution is much faster, but is it crypto-correct? */
	  three_des_cbc_key = (char *) malloc(sizeof(key_schedule)*3);
	  if (three_des_cbc_key == (unsigned char) NULL)
	    exit_log("malloc() failed for three_des_cbc_key\n", 0,0,0);

	  deskey(* (key_schedule *) (three_des_cbc_key), 
		 st->st_skeyid_e+16, 
		 1);
	  deskey(* (key_schedule *) (three_des_cbc_key+sizeof(key_schedule)),
		 st->st_skeyid_e + 8, 
		 0);
	  deskey(* (key_schedule*) (three_des_cbc_key+sizeof(key_schedule)+sizeof(key_schedule)),
		 st->st_skeyid_e, 
		 1);
	  des3_cbc_encrypt(buffer + sizeof( struct isakmp_hdr),
			   i - sizeof( struct isakmp_hdr),
			   * (key_schedule*) (three_des_cbc_key),
			   * (key_schedule*) (three_des_cbc_key+sizeof(key_schedule)),
			   * (key_schedule*) (three_des_cbc_key+sizeof(key_schedule)+sizeof(key_schedule)),
			   st->st_iv,
			   DES_DECRYPT);

	  /* free the key */
	  free(three_des_cbc_key);
#ifdef DEBUG
    	  if (arg_verbose & DEBUG_PACKETS)
	  	  packet_dump(buffer, DUMP_RECVD_AFTER_DEC, 0);
#endif

	  /* If not enough space, free it */
	  if ((st->st_iv != (u_char *) NULL) &&
	      (st->st_iv_len < lastblocksize))
	    {
	      free(st->st_iv);
	      st->st_iv = (u_char *) NULL;
	    }
	  
	  /* Allocate enough space */
	  if (st->st_iv == (u_char *) NULL)
	    {
	      st->st_iv = (u_char *) calloc(lastblocksize,
					    sizeof(u_char));
	      if (st->st_iv == (u_char *) NULL)
		exit_log("calloc() failed in comm_handle()", 0, 0, 0);
	    }
	  
	  /* Update the IV */
	  bcopy(lastblock, st->st_iv, lastblocksize);
	  st->st_iv_len = lastblocksize;

#ifdef DEBUG	  
	  if(arg_verbose & DEBUG_VERBOSE)
	    {
	      fprintf(stdout, "Updated IV:\t");
	      format_dump(st->st_iv, st->st_iv_len);
	      
	      fprintf(stdout, "Updated lastblock:\t");
	      format_dump(st->st_lastblock, st->st_lastblock_len);
	    }
#endif
	  break;
	  
	  /* XXX Handle more */

	default:
	  exit_log("unknown encryption algorithm %d in comm_handle",
		   st->st_enc, 0, 0);
	} /* End switch(st->st_enc) */
	  
      /* Adjust for padding */
      k = sizeof(struct isakmp_hdr);
      isag = (struct isakmp_generic *) (buffer + k);
      
      while (isag->isag_np != ISAKMP_NEXT_NONE)
	{
	  k += ntohs(isag->isag_length);
	  if (k >= i)
	    {
	      log(0, "malformed packet received from %s, port %d.", 
		  PRINTADDRESS(sin), get_port(sin), 0);
	      free(st->st_iv);
	      st->st_iv = (u_char *) NULL;
	      free(buffer);
	      /* XXX Could send notification back */
#ifdef DEBUG_IN_OUT
	      in_out_functions(" Q comm_handle | in demux.c -er9-");
#endif
	      return;
	    }
	  
	  isag = (struct isakmp_generic *) (buffer + k);
	}
      
      k += ntohs(isag->isag_length);
      if (k > i)
	{
	  log(0, "malformed packet received from %s, port %d.", 
	      PRINTADDRESS(sin), get_port(sin), 0);
	  free(st->st_iv);
	  st->st_iv = (u_char *) NULL;
	  free(buffer);
	  /* XXX Could send notification back */
#ifdef DEBUG_IN_OUT
	  in_out_functions(" Q comm_handle | in demux.c -er9-");
#endif
	  return;
	}
      
#ifdef DEBUG
      if(arg_verbose & DEBUG_VALUES)
	fprintf(stdout, "removed %d bytes of padding\n", i - k);
#endif
      
      i = k;
      isa->isa_length = htonl(i);
    } 
  /*
   *  end of "if (isa->isa_flags & ISAKMP_FLAG_ENCRYPTION)" 
   */

#ifdef DEBUG
      show_payloads(buffer, 1);
#endif

  if (st == (struct state *) NULL)
    {
      st = (struct state *) find_half_state(isa->isa_icookie, sin);
#ifdef DEBUG
      if (arg_verbose & DEBUG_VERBOSE)
	{
	  if (st)
	    fprintf(stdout, "half state object found: state = %d\n", st->st_state);
	  else
	    fprintf(stdout, "state object not found\n");
	}
#endif
    }
  
  if (st == (struct state *) NULL)	/* Begining of exchange */
    {
      
      switch (isa->isa_xchg)
	{
	case ISAKMP_XCHG_IDPROT:
	  if (isa->isa_np != ISAKMP_NEXT_SA)
	    {
	      log(0, "invalid payload %d from %s, port %d",
		  isa->isa_np, PRINTADDRESS(sin), get_port(sin));
	      /* XXX Could send notification back */
	      free(buffer);
#ifdef DEBUG_IN_OUT
	      in_out_functions(" Q comm_handle | in demux.c -er10-");
#endif
	      return;
	    }
	  
	  isasa = (struct isakmp_sa *) (buffer + 
					sizeof(struct isakmp_hdr));
	  switch (ntohl(isasa->isasa_doi))
	    {
	    case ISAKMP_DOI_IPSEC:
	      /* Check the situation */
	      bcopy(buffer + sizeof(struct isakmp_hdr) +
		    sizeof(struct isakmp_sa), &ipsecdoisit,
		    IPSEC_DOI_SITUATION_LENGTH);
	      ipsecdoisit = ntohl(ipsecdoisit);
	      if (ipsecdoisit != SIT_IDENTITY_ONLY)
		{
		  free(buffer);
		  log (0, "unsupported IPsec DOI situation (%d) received from %s, port %d\n",
		       ipsecdoisit, PRINTADDRESS(sin), 
		       get_port(sin));
		  /* XXX Could send notification back */
#ifdef DEBUG_IN_OUT
		  in_out_functions(" Q comm_handle | in demux.c -er11-");
#endif
		  return;
		}
	      
      ipsecdoi_handle_rfirst(sock, buffer, i, sin, kernelfd);
	      break;
	      
	    default:
	      log(0, "unknown/unsupported DOI %d from %s, port %d",
		  ntohl(isasa->isasa_doi), PRINTADDRESS(sin),
			get_port(sin));
	      /* XXX Could send notification back */
	      free(buffer);
#ifdef DEBUG_IN_OUT
	      in_out_functions(" Q comm_handle | in demux.c -er12-");
#endif
	      return;
	    } /* end switch (ntohl(isasa->isasa_doi)) */
#ifdef DEBUG_IN_OUT
	  in_out_functions(" Q comm_handle | in demux.c -succ1-");
#endif
	  return;

  	case ISAKMP_XCHG_INFO:
      	    /* XXX Handle deletions */
      	    /* XXX Handle error messages */
	    free(buffer);
#ifdef DEBUG
	    isan = (struct isakmp_notification *) (buffer + sizeof(struct isakmp_hdr));
      	    fprintf(stdout, "Received informational message from %s, port %d type %d\n",
	  	    PRINTADDRESS(sin), get_port(sin),ntohs(isan->isan_type) );
  fprintf(stdout, "\n=======================================================================\n");
#endif
#ifdef DEBUG_IN_OUT
      in_out_functions(" Q comm_handle | in demux.c -succ1a-");
#endif
	    return;
	    break;
	  
	default:
	  log(0, "out of order packet received from %s, port %d",
	      PRINTADDRESS(sin), get_port(sin), 0);
	  /* XXX Could send notification back */
	  free(buffer);
#ifdef DEBUG_IN_OUT
	  in_out_functions(" Q comm_handle | in demux.c -er13-");
#endif
	  return;
	}     /* end switch (isa->isa_xchg) */
    }         /* end if (st == (struct state *) NULL) */
  
  /* XXX Handle Informational Exchanges -- Delete/Notifications */
  if (isa->isa_xchg == ISAKMP_XCHG_INFO)
    {
      /* XXX Handle deletions */
      /* XXX Handle error messages */
#ifdef DEBUG
      if (isa->isa_np == ISAKMP_NEXT_HASH)
 	{
 	isag = (struct isakmp_generic *) (buffer + sizeof(struct isakmp_hdr));
 	i1 = ntohs(isag->isag_length);
 	}
      else
 	i1 = 0;
      isan = (struct isakmp_notification *) (buffer +
 					     sizeof(struct isakmp_hdr) + i1);
      fprintf(stdout, "Received informational message from %s, port %d, type %d\n",
	  PRINTADDRESS(sin), get_port(sin), ntohs(isan->isan_type)); 
  fprintf(stdout, "\n=======================================================================\n");
#endif
/* Phase 2 Informational Message - Delete the newly-created Phase 2 SA  */
      if (encrypted)
		{
		delete_state(st);
		free_state (st);
		}
  
#ifdef DEBUG_IN_OUT
      in_out_functions(" Q comm_handle | in demux.c -succ1b-");
#endif
	    return;
    }
  
  /* XXX Handle Commit Bit set and unset it */
  /* This commit bit is used to signal key exchange synchronisation */
  /* the value MUST be reset after phase 1 negotiations!! */
  /* If set, the entity wich did not set it must wait for an */
  /* ISAKMP_XCHG_INFO.    */
  
  switch (st->st_state)
    {
    case OAKLEY_MAIN_I_1:
      if (isa->isa_np != ISAKMP_NEXT_SA)
	    {
	      log(0, "dropping out of sequence packet from %s, port %d",
		  PRINTADDRESS(sin), get_port(sin), 0);
#ifdef DEBUG_IN_OUT
	      in_out_functions(" Q comm_handle | in demux.c -er14-");
#endif
	      free(buffer);
	      return;
	    }

      ipsecdoi_handle_i1(sock, buffer, i, sin, st);
#ifdef DEBUG_IN_OUT
      in_out_functions(" Q comm_handle | in demux.c -succ2-");
#endif
      return;
      
    case OAKLEY_MAIN_I_2:
      if (isa->isa_np != ISAKMP_NEXT_KE)
	{
	  log(0, "dropping out of sequence packet from %s, port %d",
	      PRINTADDRESS(sin), get_port(sin), 0);
#ifdef DEBUG_IN_OUT
	  in_out_functions(" Q comm_handle | in demux.c -er15-");
#endif
	  free(buffer);
	  return;
	}
      
      ipsecdoi_handle_i2(sock, buffer, i, sin, st);
#ifdef DEBUG_IN_OUT
      in_out_functions(" Q comm_handle | in demux.c -succ3-");
#endif
      return;
      
    case OAKLEY_MAIN_I_3:
      if (encrypted == 0)
	{
	  log(0, "packet from %s, port %d should have been encrypted",
	      PRINTADDRESS(sin), get_port(sin), 0);
	  free(buffer);
	  /* XXX Could send notification back */
#ifdef DEBUG_IN_OUT
	  in_out_functions(" Q comm_handle | in demux.c -er16-");
#endif
	  return;
	}

      if (isa->isa_np != ISAKMP_NEXT_ID)
	{
	  log(0, "dropping out of sequence packet from %s, port %d",
	      PRINTADDRESS(sin), get_port(sin), 0);
	  free(buffer);
#ifdef DEBUG_IN_OUT
	  in_out_functions(" Q comm_handle | in demux.c -er17-");
#endif
       	  return;
	}
      
	    /* Keep last block */
      st->st_lastblock = (u_char *) calloc(lastblocksize, 
						 sizeof(u_char));
      if (st->st_lastblock == (u_char *) NULL)
	exit_log("calloc() failed in comm_handle()", 0, 0, 0);
      
      st->st_lastblock_len = lastblocksize;
      bcopy(lastblock, st->st_lastblock, lastblocksize);
      
#ifdef DEBUG
      if (arg_verbose & DEBUG_VERBOSE)
	{
	  fprintf(stdout, "last encrypted Phase 1 block: ");
	  for (k = 0; k < st->st_lastblock_len; k++)
	    fprintf(stdout, "%02x ", st->st_lastblock[k]);
	  fprintf(stdout, "\n");
	}
#endif
      ipsecdoi_handle_i3(sock, buffer, i, sin, st, kernelfd);
#ifdef DEBUG_IN_OUT
      in_out_functions(" Q comm_handle | in demux.c -succ4-");
#endif
      return;
      
    case OAKLEY_MAIN_R_1:
      if (isa->isa_np != ISAKMP_NEXT_KE)
	{
	  /* Retransmit */
	  if (isa->isa_np == ISAKMP_NEXT_SA)
	    {
	      if (sendto(sock, st->st_packet, st->st_packet_len, 0,
			 &(st->st_peer), sizeof(st->st_peer)) !=
		  st->st_packet_len)
		log(1, "sendto() failed in comm_handle() for %s, port %d",
		    PRINTADDRESS(st->st_peer), get_port(st->st_peer), 0);
#ifdef DEBUG
	      else 
		    fprintf(stdout, "retransmitted %d bytes\n", st->st_packet_len);
#endif
	    }
	  else
	    fprintf(stdout, "dropping out of sequence packet from %s, port %d\n",
		PRINTADDRESS(sin), get_port(sin));

	  free(buffer);
#ifdef DEBUG_IN_OUT
	  in_out_functions(" Q comm_handle | in demux.c -er18-");
#endif
	  return;
	}
      
	    ipsecdoi_handle_r1(sock, buffer, i, sin, st);
#ifdef DEBUG_IN_OUT
	    in_out_functions(" Q comm_handle | in demux.c -succ5-");
#endif
	    return;
	    
    case OAKLEY_MAIN_R_2:
      if (encrypted == 0)
	{
	  log(0, "packet from %s, port %d should have been encrypted",
	      PRINTADDRESS(sin), get_port(sin), 0);
	  free(buffer);
	  /* XXX Could send notification back */
#ifdef DEBUG_IN_OUT
	  in_out_functions(" Q comm_handle | in demux.c -er19-");
#endif
	  return;
	}
      
      if (isa->isa_np != ISAKMP_NEXT_ID)
	{
	  /* Retransmit */
	  if (isa->isa_np == ISAKMP_NEXT_KE)
	    {
	      if (sendto(sock, st->st_packet, st->st_packet_len, 0,
			 &(st->st_peer), sizeof(st->st_peer)) !=
		  st->st_packet_len)
		log(1, "sendto() failed in comm_handle() for %s, port %d",
		    PRINTADDRESS(st->st_peer), get_port(st->st_peer), 0);
#ifdef DEBUG
	      else
		fprintf(stdout, "retransmitted %d bytes\n", st->st_packet_len);
#endif
	    }
	  else
	    fprintf(stdout, "dropping out of sequence packet from %s, port %d\n",
		PRINTADDRESS(sin), get_port(sin));
	  free(buffer);
#ifdef DEBUG_IN_OUT
	  in_out_functions(" Q comm_handle | in demux.c -er20-");
#endif		
	  return;
	}
      
      ipsecdoi_handle_r2(sock, buffer, i, sin, st);
#ifdef DEBUG_IN_OUT
      in_out_functions(" Q comm_handle | in demux.c -succ6-");
#endif
      return;
      
    case OAKLEY_QUICK_I_1:
      if (encrypted == 0)
	{
	  log(0, "packet from %s, port %d should have been encrypted",
	      PRINTADDRESS(sin), get_port(sin), 0);
	  free(buffer);
	  /* XXX Could send notification back */
#ifdef DEBUG_IN_OUT
	  in_out_functions(" Q comm_handle | in demux.c -er21-");
#endif
	  return;
	}
      
      if (isa->isa_np != ISAKMP_NEXT_HASH)
	{
	  log(0, "dropping out of sequence packet from %s, port %d",
	      PRINTADDRESS(sin), get_port(sin), 0);
	  free(buffer);
#ifdef DEBUG_IN_OUT
	  in_out_functions(" Q comm_handle | in demux.c -er22-");
#endif
	  return;
	}
      
      ipsecdoi_handle_quick_i1(sock, buffer, i, sin, st, kernelfd);
#ifdef DEBUG_IN_OUT
      in_out_functions(" Q comm_handle | in demux.c -succ7-");
#endif
      return;
      
    case OAKLEY_QUICK_R_1:
      if (encrypted == 0)
	{
	  log(0, "packet from %s, port %d should have been encrypted",
	      PRINTADDRESS(sin), get_port(sin), 0);
	  free(buffer);
	  /* XXX Could send notification back */
#ifdef DEBUG_IN_OUT
	  in_out_functions(" Q comm_handle | in demux.c -er23-");
#endif
	  return;
	}

      if (isa->isa_np != ISAKMP_NEXT_HASH)
	{
	  log(0, "dropping out of sequence packet from %s, port %d",
	      PRINTADDRESS(sin), get_port(sin), 0);
	  free(buffer);
#ifdef DEBUG_IN_OUT
	  in_out_functions(" Q comm_handle | in demux.c -er24-");
#endif		
	  return;
	}
      /* CHECK if the message is not accepted, we should delete the new state. (!?!)*/
      ipsecdoi_handle_quick_r1(sock, buffer, i, sin, st, kernelfd);
#ifdef DEBUG_IN_OUT
      in_out_functions(" Q comm_handle | in demux.c -succ8-");
#endif
      return;
      
    case OAKLEY_QUICK_R_2:
      if (encrypted == 0)
	{
	  log(0, "packet from %s, port %d should have been encrypted",
	      PRINTADDRESS(sin), get_port(sin), 0);
	  free(buffer);
	  /* XXX Could send notification back */
#ifdef DEBUG_IN_OUT
	  in_out_functions(" Q comm_handle | in demux.c -err25-");
#endif
	  return;
	}
      
      if (isa->isa_np != ISAKMP_NEXT_HASH)
	{
	  isag = (struct isakmp_generic *) (buffer + sizeof(struct isakmp_hdr));
	  if (isag->isag_np == ISAKMP_NEXT_SA)
	    {
	      if (sendto(sock, 
			 st->st_packet, st->st_packet_len, 
			 0,
			 &(st->st_peer), 
			 sizeof(st->st_peer)) !=
		  st->st_packet_len)
		log(1, "sendto() failed in comm_handle() for %s, port %d",
		    PRINTADDRESS(st->st_peer), get_port(st->st_peer), 0);
#ifdef DEBUG
	      else
		fprintf(stdout, "retransmitted %d bytes\n", st->st_packet_len);
#endif
	    }
	  else
	    fprintf(stdout, "dropping out of sequence packet from %s, port %d\n",
		PRINTADDRESS(sin), get_port(sin), 0);
	  free(buffer);
#ifdef DEBUG_IN_OUT
	  in_out_functions(" Q comm_handle | in demux.c -err26-");
#endif		
	  return;
	}

       ipsecdoi_handle_quick_r2(sock, buffer, i, sin, st, kernelfd);
#ifdef DEBUG_IN_OUT
       in_out_functions(" Q comm_handle | in demux.c -succ9-");
#endif
       return;
     }
      
    log(0, "unexpected packet received from %s, port %d\n", 
	PRINTADDRESS(sin), get_port(sin), 0);
    free(buffer);
#ifdef DEBUG_IN_OUT
    in_out_functions(" Q comm_handle | in demux.c -errfinal-");
#endif
    return;
}


