.TH PLUTOPLUS 8 "1 Dec 1998" "PlutoPlus" "NIST IKE Reference Implementation"

.SH NAME
.B PlutoPlus 
\- IPsec IKE Key Negotiation Daemon

.SH SYNOPSIS
.HP
.BR plutoplus
.RB [ \-a 
.IR " auth_alg" ]
.RB [ \-b 
.IR " output_level" ]
.RB [ \-d 
.IR " dest_addr" ]
.RB [ \-e 
.IR " enc_alg" ]
.RB [ \-g 
.IR " gateway_addr" ]
.RB [ \-k 
.IR " enc_key_len" ]
.RB [ \-l 
.IR " ipsec_sa_life_seconds" ]
.RB [ \-m 
.IR " ipsec_sa_life_kbytes" ]
.RB [ \-o 
.IR " isakmp_sa_life_seconds" ]
.RB [ \-p 
.IR " port_num" ]
.RB [ \-v 
.IR " enc_iv_len" ]
.RB [ \-fhirst3 ]

.SH DESCRIPTION
.P
.B PlutoPlus 
is a reference implementation of the Internet Key Exchange
Protocol (IKE), the Internet Security Association and Key Management
Protocol (ISAKMP), and the Internet IP Security Domain of Interpretation
for ISAKMP (DOI). The goal of any IKE implementation is to negotiate an
IPsec Security Association (SA) with a peer. This is accomplished through a
2-phase negotiation: Phase 1 establishes an ISAKMP (Internet Security
Association and Key Management Protocol) SA, which is a secure channel
through which the IPsec SA negotiation can take place; Phase 2 establishes
the actual IPsec SA.
.P
Under normal operations, 
.B PlutoPlus 
is a daemon that waits for one of 2
types of requests: a kernel request to initiate negotiations for the
establishment of an IPsec SA (in which case 
.BR PlutoPlus 's 
role is that of
Initiator) or a peer request (generally via port 500) to establish an IPsec
SA (in which case 
.BR PlutoPlus 's 
role is that of Responder). 
As Initiator,
.B PlutoPlus 
sends a single proposal, dictated by the command-line options. As Responder, 
.B PlutoPlus 
accepts any single proposal whose attributes are consistent with
.BR PlutoPlus 's 
capabilities.
In this mode, any
error messages are logged to syslog and, in some cases, cause a
Notification Message to be sent to the negotiating peer.
.P
For debugging and testing purposes, 
.B PlutoPlus 
has a DEBUG mode that causes
increased diagnostic and informational output; in this mode, all messages
are printed to the standard output or standard error.
.P
In addition, 
.B PlutoPlus 
has a WIT DEBUG mode that is used for the version of
.B PlutoPlus 
running on IPsec WIT, ITL's IPsec Interoperability Tester. In
this mode, 
.B PlutoPlus 
conducts a single negotiation, either as Initiator or
Responder, and then exits. If an error is encountered, or if too much time
elapses without a message from the negotiating peer, 
.B PlutoPlus 
also exits.
.P
In the WIT DEBUG mode, command-line options are used to dictate whether
.B PlutoPlus 
will act as Initiator or Responder, and also to communicate the
parameters of the proposal to be sent (as Initiator) or accepted (as
Responder). In the WIT DEBUG mode 
.BR PlutoPlus , 
as Initiator, sends a single
proposal, dictated by the command-line options. As Responder, 
.B PlutoPlus 
accepts a single proposal, and checks to ensure that the proposal
is consistent with the command-line options.

.SH OPTIONS
.TP
.BI \-a " auth_alg"
As Initiator, propose an IPsec SA with authentication algorithm 
.I auth_alg
.br
.in +5
.BI \-a " 2" 
==> HMAC_MD5 
.br
.BI \-a " 3" 
==> HMAC_SHA)
.in -5
.br
.B without -e: 
Propose an AH SA with authentication algorithm 
.I auth_alg
.br
.B with -e: 
Propose an ESP SA with authentication algorithm 
.I auth_alg

.TP
.BI \-b " output_level"
Print additional DEBUG output (DEBUG mode only)
.br
.B \-b 1
==> print verbose debug output
.br
.B \-b 2
==> print packets/packet headers
.br
.B \-b 4
==> print various IKE calculated values
.br
.B \-b 7
has the same effect as 
.B -b 1 -b 2 -b 4
.TP
.BI \-d " dest_addr"
If 
.B PlutoPlus 
is the Initiator (as specified by the
.B \-i
option), 
.I dest_addr
is the address of the peer with whom 
.B PlutoPlus 
PlutoPlus negotiates its first IPsec SA.
.br
In WIT mode,
.I dest_addr
is the address of the peer WITH whom 
.B PlutoPlus 
is negotiating the IPsec SA (transport mode)
or the address of the peer FOR whom 
.B PlutoPlus 
is negotiating the IPsec SA (tunnel mode).
In WIT mode, 
.I dest_addr
must be specified.

.TP
.BI \-e " enc_alg"
As Initiator, propose an IPsec ESP SA with encryption algorithm 
.I enc_alg 
.br
.in +5
.BI \-e " 1" 
==> ESP_DES_IV64
.br
.BI \-e " 2" 
==> ESP_DES
.br
.BI \-e " 3" 
==> ESP_3DES
.br
.BI \-e " 4" 
==> ESP_RC5
.br
.BI \-e " 5" 
==> ESP_IDEA
.br
.BI \-e " 7" 
==> ESP_BLOWFISH
.br
.BI \-e " 11" 
==> ESP_NULL
.in -5
(If neither -a nor -e is specified, default is an IPsec ESP SA with 
encryption algorithm DES and authentication algorithm HMAC_MD5)

.TP
.B \-f
Conduct an extra Diffie-Hellman Exchange during the Phase 2 negotiation to ensure Perfect
Forward Secrecy (PFS) for KEYS.

.TP
.BI \-g " gateway_addr"
Gateway address for tunnel mode negotiation (WIT mode only).  In tunnel mode, 
.B PlutoPlus 
negotiates WITH the
.I gateway_addr
to establish an IPsec SA FOR the
.I dest_addr \.  If no 
.I gateway_addr
is specified, then the
.I dest_addr
is used.

.TP
.B \-h
help (print Usage message, then exit).

.TP
.B \-i
Act as Initiator of key negotiation.  In non-WIT mode, after initiating a
single negotiation, PlutoPlus waits for further negotiations to be instigated
by either the kernel or a peer.

.TP
.BI \-k " enc_key_len"
ESP encryption key length in bytes (BLOWFISH and RC5 ONLY).  Valid values for
RC5 are: 5, 16, 20 (default is 16); valid values for BLOWFISH are 5 to 56 
(default is 8).

.TP
.BI \-l " ipsec_sa_life_seconds"
Lifetime in seconds of proposed IPsec SA (default is 8 hours).

.TP
.BI \-m " ipsec_sa_life_kbytes"
Lifetime in kilobytes of proposed IPsec SA (default is 32767 - hex 7FFF - 
kilobytes).

.TP
.BI \-o " isakmp_sa_life_seconds"
Lifetime in seconds of proposed ISAKMP SA (default is 24 hours).

.TP
.BI \-p " port_num"
.B PlutoPlus 
port number (default is port 500).

.TP
.B \-r
As Initiator, propose an IPsec SA WITHOUT replay protection

.TP
.B \-s
As Initiator, propose an ISAKMP SA with SHA as the hash algorithm (default is
MD5)


.TP
.B \-t
As Initiator, propose an IPsec tunnel-mode SA (default is transport mode)

.TP
.BI \-v " enc_iv_len"
As Initiator, propose an IPsec ESP SA with IV length enc_iv_len.  Valid values 
are 0 or 8.  Default for DES, DES_IV64, 3DES, RC5, IDEA, or BLOWFISH is 8;
default for ESP_NULL is 0.

.TP
.B \-3
As Initiator, propose an ISAKMP SA with 3DES as the encryption algorithm 
(default is DES)

.SH FILES
.I /dev/zero
.br
.I /dev/urandom
.br
.I /dev/ike
.br
.I /dev/ipsec
.br
.I /etc/isakmp-secrets
(non-DEBUG mode)
.br
.I ./isakmp-secrets
(DEBUG mode without WIT)
.br
.I /tmp/wit/isakmp-secrets.dest_addr
(DEBUG mode with WIT)

.SH SEE ALSO
sadb(n)

.SH HISTORY
The original
.B Pluto
for Linux was written in Greece in 1997 by Angelos Keramytis.
.P
Sheila Frankel of NIST added additional capabilities,
updated it to conform to the current Internet Drafts, integrated it with NIST's
IPSec Reference Implementation, and in general
expanded, documented, cajoled and bullied it into its current incarnation,
.BR PlutoPlus .

.SH BUGS
.B PlutoPlus
is known to have some memory leaks.
