/* This program is an implementation of the IKE Internet Standard.
 * PlutoPlus Copyright (C) 1999 Sheila Frankel - for details see COPYING.
 * Pluto Copyright (C) 1997 Angelos D. Keromytis - for details see COPYING.others.
 */

/*
 * log.c - This file defines error logging functions
 */

#include <stdio.h>
#include <syslog.h>

/**********************************************************************/
void init_log(void)
{
#ifndef DEBUG
  openlog("PlutoPlus", LOG_CONS | LOG_NDELAY | LOG_PID, LOG_AUTHPRIV);
#else
  setbuf(stderr, NULL);
  setbuf(stdout, NULL);
#endif
}

/**********************************************************************/
void close_log(void)
{
#ifndef DEBUG
  closelog();
#endif
}

/**********************************************************************/
/*
 * If the first argument is true, then this is an error, otherwise
 * it's a warning. It takes up to three additional arguments (which
 * will be passed to syslog/printf verbatim.
 */
void log(int   error, 
	 char *message, 
	 int   a, 
	 int   b, 
	 int   c)
{
#ifndef DEBUG
  if (error)
    {
      syslog(LOG_ERR, message, a, b, c);
    }
  else
    syslog(LOG_WARNING, message, a, b, c);
#else
  if (error)
#ifndef WIT
      fprintf(stderr, "Error: ");
#else
/* WIT - Message to let WIT know that PlutoPlus has unsuccessfully completed */
      fprintf(stderr, "***Error: ");
#endif WIT
  fprintf(stderr,message, a, b, c);
  fprintf(stderr, "\n");
#ifdef WIT
/* WIT - Exit if serious error encountered */
  if (error)
 	exit(-1);
#endif WIT
#endif
}

/**********************************************************************/
void exit_log(char *message, int a, int b, int c)
{
/* Call kernel_unregister to send SADBM_UNREGISTER to kernel before exiting */
  kernel_unregister (0);
  log(1, message, a, b, c);
  close_log();
  exit(-1);
}

void exit_log_nr(char *message, int a, int b, int c)
{
/* Special version of exit_log called only by kernel_unregister -
 *	logs and exits without calling kernel_unregister */
  log(1, message, a, b, c);
  close_log();
  exit(-1);
}


