/* This program is an implementation of the IKE Internet Standard.
 * PlutoPlus Copyright (C) 1999 Sheila Frankel - for details see COPYING.
 * Pluto Copyright (C) 1997 Angelos D. Keromytis - for details see COPYING.others.
 */

/* main.c */

#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <netdb.h>
#include "constants.h"
#include "argdefs.h"
#include <sadb.h>

extern u_int16_t our_port;

u_int32_t getaddr(char *s);

/**********************************************************************/
main(int argc, char **argv)
{
  int i;
  u_char msg1[40];

  /* Defs for arg-handling code: handles setting of policy-related variables */
  int          ch;
  int          help_opt;
  int          enc_iv_len_set;
  extern char *optarg;

#ifdef DEBUG_IN_OUT
  in_out_functions(" E main | in main.c");
#endif
    
#ifndef DEBUG
  i = fork();
  if (i < 0)
    {
      fprintf(stderr, "fork() failed in main()\n");
      exit(-1);
    }
  else
    if (i)
      exit(0);  /* Parent dies */
  
  if (setsid() < 0)
    {
      fprintf(stderr, "setsid() failed in main()\n");
      exit(-1);
    }
  
  for (i = getdtablesize() - 1; i >= 0; i--)  /* Bad hack */
    close(i);
#endif
  
  /* Arg-handling code: handles setting of policy-related variables */
  /* Set default values */
  arg_isakmp_auth =       OAKLEY_MD5;
  arg_isakmp_enc =        OAKLEY_DES_CBC;
  arg_replay_protection = 1;
  arg_initiator =   	  0;
  arg_isakmp_enc_length = 8;
  arg_enc_iv_len =        8;
  arg_ipsec_life_duration_seconds = SA_LIFE_DURATION_DEFAULT;
  arg_ipsec_life_duration_kbytes = SA_LIFE_DURATION_K_DEFAULT;
  arg_oakley_life_duration_seconds = OAKLEY_ISAKMP_SA_LIFETIME_DEFAULT;
#ifdef DEBUG
  arg_verbose = 	  0;
#endif DEBUG
  
  /* Set initial values */
  arg_auth_alg =      0;
  arg_auth_key_len =  0;
  arg_enc_alg =       0;
  arg_enc_key_len =   0;
  arg_dest_addr =     0;
  arg_gateway_addr =  0;
  arg_key_mgmt_goal = 0;
  arg_pfs_requested = 0;

  help_opt = 0;
/* To differentiate -v 0 from no -v specified */
  enc_iv_len_set = 0;

#ifdef DEBUG
/* allow -b debug_level option */
  while ((ch = getopt(argc, argv, "a:b:d:e:fg:ik:l:m:o:p:rstv:3h:")) != EOF)
#else
  while ((ch = getopt(argc, argv, "a:d:e:fg:ik:l:m:o:p:rstv:3h")) != EOF)
#endif
    switch(ch) {
    case 'a':
      arg_auth_alg = atoi(optarg);
      arg_key_mgmt_goal |= GOAL_AUTHENTICATE;
/* 2 : MD5
 * 3 : SHA
	 Either used as HMAC (for an ESP transform) or as AH transform number.
	 Uses AH constants
 If it is used as HMAC, the transformation into the good numbers is done later */
      switch (arg_auth_alg)
	{
	case AH_MD5:
	  arg_auth_key_len = 16;
	  break;
	case AH_SHA:
	  arg_auth_key_len = 20;
	  break;
	default:
	  exit_log ("Invalid auth alg #: %s", optarg, 0, 0);
	}
      break;
#ifdef DEBUG
    case 'b':
      arg_verbose = atoi(optarg) | arg_verbose;
      if ((arg_verbose < 1) || (arg_verbose > 7))
	exit_log ("Invalid -b debug level : %s", optarg, 0, 0);
      break;
#endif DEBUG
    case 'd':
#ifdef WIT
/* WIT - Error message if no hostoping was specified on Login */
	  if (!strcmp(optarg,"NO-HOST-TO-PING"))
    		exit_log("HOST TO PING must be specified for WIT; Please Restart WIT", 0, 0, 0);
#endif WIT
      if ((arg_dest_addr = inet_addr(optarg)) == -1) 
        if (!(arg_dest_addr = getaddr(optarg))) 
            exit_log ("Invalid dest addr: %s", optarg, 0, 0);
      break;
    case 'e':
/* Valid values:
ESP_DES_IV64             1
ESP_DES                  2
ESP_3DES                 3
ESP_RC5                  4
ESP_IDEA                 5
ESP_BLOWFISH             7
ESP_NULL                 11 */
      arg_enc_alg = atoi(optarg);
      arg_key_mgmt_goal |= GOAL_ENCRYPT;
      switch (arg_enc_alg)
	{
	case ESP_DES:
	case ESP_DES_IV64:
	case ESP_NULL:
	case ESP_3DES:
	case ESP_RC5:
	case ESP_IDEA:
	case ESP_BLOWFISH:
	  break;
	default:
	  exit_log ("Invalid esp alg #: %s", optarg, 0, 0);
	}
      break;
    case 'f':
      arg_pfs_requested = 1;
      break;
    case 'g':
      if ((arg_gateway_addr = inet_addr(optarg)) == -1)
        if (!(arg_gateway_addr = getaddr(optarg))) 
	  exit_log ("Invalid gateway addr: %s", optarg, 0, 0);
      break;
    case 'i':
      /* We are the initiator ==> send SADBM_REGISTER message to kernel, requesting that
	 kernel kick key mgmt                                */
      arg_initiator = 1;
      break;
    case 'k':
      arg_enc_key_len = atoi(optarg);
      break;
    case 'l':
      arg_ipsec_life_duration_seconds = atoi(optarg);
/* -l 0 ==> Don't propose life duration (seconds) attribute */
      if ((arg_ipsec_life_duration_seconds) &&
         ((arg_ipsec_life_duration_seconds < SA_LIFE_DURATION_MINIMUM) ||
	  (arg_ipsec_life_duration_seconds > SA_LIFE_DURATION_MAXIMUM)))			
	exit_log ("Invalid IPsec life duration (seconds): %s", optarg, 0, 0);
      break;
    case 'm':
      arg_ipsec_life_duration_kbytes = atoi(optarg);
/* -m 0 ==> Don't propose life duration (kbytes) attribute */
      if ((arg_ipsec_life_duration_kbytes) &&
         (arg_ipsec_life_duration_kbytes < SA_LIFE_DURATION_K_MINIMUM))
	exit_log ("Invalid IPsec life duration (kbytes): %s", optarg, 0, 0);
      break;
    case 'o':
      arg_oakley_life_duration_seconds = atoi(optarg);
      if ((arg_oakley_life_duration_seconds < OAKLEY_ISAKMP_SA_LIFETIME_MINIMUM) ||
	  (arg_oakley_life_duration_seconds > OAKLEY_ISAKMP_SA_LIFETIME_MAXIMUM))
	exit_log ("Invalid Oakley life duration (seconds): %s", optarg, 0, 0);
      break;
    case 'p':
      our_port = atoi(optarg);
      if (!our_port)
	exit_log ("Invalid port #: %s", optarg, 0, 0);
      break;
    case 'r':
      arg_replay_protection = 0;
      break;
    case 's':
      arg_isakmp_auth = OAKLEY_SHA;
      break;
    case 't':
      arg_key_mgmt_goal |= GOAL_TUNNEL;
      break;
    case 'v':
/* Set DEFAULT enc iv len */
      enc_iv_len_set = 1;
      arg_enc_iv_len = atoi(optarg);
      if ((arg_enc_iv_len != 0) && (arg_enc_iv_len != 8))
	exit_log ("Invalid DEFAULT enc iv len : %s", optarg, 0, 0);
      break;
      /* Use 3DES for encrypting ISAKMP messages */
    case '3':
      arg_isakmp_enc = OAKLEY_3DES_CBC;
      arg_isakmp_enc_length = 24;
      break;
    case 'h':
      help_opt = 1;
    default:
      fprintf(stdout, "usage: %s [-a auth_alg] [-d dest_addr] [-e enc_alg] [-g gateway_addr]\n", argv[0]);
      fprintf(stdout, "\t[-k enc_key_len] [-p port_num] [-v enc_iv_len]\n");
#ifdef DEBUG
      fprintf(stdout, "\t[-bfhirst3]\n");
      fprintf(stdout, "     where: -b n ==> print additional debug output\n");
      fprintf(stdout, "                     (with n = the sum of 1 or more\n");
      fprintf(stdout, "                      of the following values:\n");
      fprintf(stdout, "               1 ==> print verbose debug output\n");
      fprintf(stdout, "               2 ==> print packets/packet headers\n");
      fprintf(stdout, "               4 ==> print various IKE calculated values\n");
#else
      fprintf(stdout, "\t[-fhirst3]\n");
#endif
      fprintf(stdout, "            -f ==> turn on pfs for all quick exchanges\n");
      fprintf(stdout, "            -h ==> help (prints this message, then exits)\n");
      fprintf(stdout, "            -i ==> initiate key negotiation\n");
      fprintf(stdout, "            -r ==> turn OFF replay protection\n");
      fprintf(stdout, "            -s ==> use HMACSHA (instead of HMACMD5) for ISAKMP SA\n");
      fprintf(stdout, "            -t ==> tunnel mode\n");
      fprintf(stdout, "            -3 ==> use 3DESCBC (instead of DESCBC) for ISAKMP SA\n");
      if (help_opt)
	   exit(-1);
      else
           exit_log("Unknown Option", 0, 0, 0);
    }
  
  /* Default behavior: */
  /* 	If neither -a nor -e was specified ==> default goal (for initiator) is: 
	encrypt with IPSEC_DES_CBC &
	authenticate with IPSEC_HMACMD596 */
  	if (!(arg_key_mgmt_goal & GOAL_AUTHENTICATE) &&
      	!(arg_key_mgmt_goal & GOAL_ENCRYPT)) 
	{
      		arg_key_mgmt_goal |= GOAL_ENCRYPT;
      		arg_enc_alg = ESP_DES;

    		arg_key_mgmt_goal |= GOAL_AUTHENTICATE;
    		arg_auth_alg = AH_MD5;
    		arg_auth_key_len = 16;
  	}

  /* 	If gateway_addr was not specified ==> gateway_addr = dest_addr */
  if (!(arg_gateway_addr))
    arg_gateway_addr = arg_dest_addr;

/* WIT - Save negotiating peer's addr as part of name of saved secrets file */
#ifdef WIT
 		    strcpy(secret_file_name,  "/tmp/wit/isakmp-secrets.");  
    if (arg_key_mgmt_goal & GOAL_TUNNEL)
    /* For tunnel-mode SA ==> negotiate with the gateway */
	    strcpy(&secret_file_name[24], (char *)inet_ntoa(arg_gateway_addr));  
    else
        strcpy(&secret_file_name[24], (char *)inet_ntoa(arg_dest_addr));  
#endif WIT
  
  /* Error checks: */
  /* 	Total key length cannot exceed MAX_KEY_LENGTH*/
  if ((arg_auth_key_len + arg_enc_key_len > MAX_KEY_LENGTH))
    exit_log("Total key length cannot exceed %d \n\t\t (auth_key_len = %d; enc_key_len = %d)", 
	     MAX_KEY_LENGTH, arg_auth_key_len, arg_enc_key_len);
  
  /* 	Initiator - dest_addr must be specified */
  if ((arg_initiator) && !(arg_dest_addr))
    exit_log("-d dest_addr must be specified for Initiator", 0, 0, 0);
  
  /* 	WIT - dest_addr must be specified */
#ifdef WIT
  if (!(arg_dest_addr))
    exit_log("-d dest_addr must be specified for WIT", 0, 0, 0);
#endif WIT

  /* 	Peer addr can differ from dest addr only in tunnel mode */
  if ((arg_dest_addr != arg_gateway_addr) && !(arg_key_mgmt_goal & GOAL_TUNNEL))
    exit_log("-g valid only with -t", 0, 0, 0);
  
/* Key_len can only be specified for RC5 or BLOWFISH */
if ((arg_enc_key_len) &&
    (arg_enc_alg != ESP_RC5) &&
    (arg_enc_alg != ESP_BLOWFISH))
	  exit_log ("-k valid only with -e ESP_RC5 or -e ESP_BLOWFISH", 0, 0, 0);

/* Can't request both -l 0 and -m 0 */ 
      if ((!arg_ipsec_life_duration_seconds) &&
         (!arg_ipsec_life_duration_kbytes)) 
	  exit_log ("can only request -l 0 OR -m 0", 0, 0, 0);

/* Now set key len & iv len based on enc alg; exit for faulty combinations */
if (arg_enc_alg)
      switch (arg_enc_alg)
	{
	case ESP_DES:
  		arg_enc_key_len =   8;
	        if ((arg_enc_iv_len != 0) &&
	           (arg_enc_iv_len != 8))
	  	      exit_log ("invalid ESP_DES iv_len: %d", arg_enc_iv_len, 0, 0);
	  break;
	case ESP_DES_IV64:
  		arg_enc_key_len =   8;
	  break;
	case ESP_NULL:
  		arg_enc_key_len =   0;
	  break;
	case ESP_3DES:
  		arg_enc_key_len =  24;
	        if ((arg_enc_iv_len != 0) &&
	           (arg_enc_iv_len != 8))
	  	      exit_log ("invalid ESP_3DES iv_len: %d", arg_enc_iv_len, 0, 0);
	  break;
	case ESP_RC5:
	  if (!arg_enc_key_len) 
  		arg_enc_key_len =   16;
	  else if ((arg_enc_key_len != 5) &&
	           (arg_enc_key_len != 16) &&
	           (arg_enc_key_len != 20))
	  	exit_log ("invalid ESP_RC5 key_len: %d", arg_enc_key_len, 0, 0);
	  if ((arg_enc_iv_len != 0) &&
	     (arg_enc_iv_len != 8))
	        exit_log ("invalid ESP_RC5 iv_len: %d", arg_enc_iv_len, 0, 0);
	  break;
	case ESP_IDEA:
  		arg_enc_key_len =  16;
	        if ((arg_enc_iv_len != 0) &&
	           (arg_enc_iv_len != 8))
	  	      exit_log ("invalid ESP_IDEA iv_len: %d", arg_enc_iv_len, 0, 0);
	  break;
	case ESP_BLOWFISH:
	  if (!arg_enc_key_len) {
  		arg_enc_key_len =   8;
	  }
	  else if ((arg_enc_key_len < 5) ||
	            (arg_enc_key_len > 56))
	  	exit_log ("invalid ESP_BLOWFISH key_len: %d", arg_enc_key_len, 0, 0);
	  if ((arg_enc_iv_len != 0) &&
	     (arg_enc_iv_len != 8))
	        exit_log ("invalid ESP_BLOWFISH iv_len: %d", arg_enc_iv_len, 0, 0);
	  break;
	default:
	  break;
	} /* end switch enc_alg_arg */

  init_log();
  init_rnd_pool();
  init_vars();
  init_state();
  init_nums();

#ifdef DEBUG
  fprintf(stdout, "ISAKMP/IKE has the following parameters:\n");
  fprintf(stdout, "\tRole : ");
  if (arg_initiator) 
	fprintf(stdout, "INITIATOR\n");
  else 
	fprintf(stdout, "RESPONDER\n");

    #ifdef ZZZZI
if (arg_verbose & DEBUG_VERBOSE)
    fprintf(stdout, "\t\tZZZZI (initiator negotiating with self) defined\n"); 
    #endif
    
    #ifdef ZZZZR
if (arg_verbose & DEBUG_VERBOSE)
    fprintf(stdout, "\t\tZZZZR (responder negotiating with self) defined\n"); 
    #endif

  fprintf(stdout, "\tAuthentication : PRESHARED\n");
  fprintf(stdout, "\tGroup number : 1\n");
  switch (arg_isakmp_enc)
    {
    case OAKLEY_3DES_CBC:
      fprintf(stdout, "\tISAKMP SA algorithms (enc/hash) : 3DES_CBC(3)");
      break;
    case OAKLEY_DES_CBC:
      fprintf(stdout, "\tISAKMP SA algorithms (enc/hash) : DES_CBC(2)");
      break;
    default:
      fprintf(stdout, "\tISAKMP SA algorithms (enc/hash) : not implemented(%d)", arg_isakmp_enc);
      break;
    }
  switch (arg_isakmp_auth)
    {
    case OAKLEY_MD5:
      fprintf(stdout, "/MD5(2)\n");
      break;
    case OAKLEY_SHA:
      fprintf(stdout, "/SHA(3)\n");
      break;
    default:
      fprintf(stdout, "/not implemented(%d)\n", arg_isakmp_auth);
    }
  if(arg_key_mgmt_goal & GOAL_ENCRYPT)
    switch (arg_enc_alg)
      {
      case ESP_NULL:
	fprintf(stdout, "\tIPsec ESP algorithm : NULL (11)\n");
	break;
      case ESP_DES_IV64:
	fprintf(stdout, "\tIPsec ESP algorithm : DES_IV64 (1)\n");
	break;
      case ESP_DES:
	fprintf(stdout, "\tIPsec ESP algorithm : DES (2)\n");
	break;
      case ESP_3DES:
	fprintf(stdout, "\tIPsec ESP algorithm : 3DES (3)\n");
	break;
	case ESP_RC5:
	fprintf(stdout, "\tIPsec ESP algorithm : RC5 (4)\n");
	break;
	case ESP_IDEA:
	fprintf(stdout, "\tIPsec ESP algorithm : IDEA (5)\n");
	break;
	case ESP_BLOWFISH:
	fprintf(stdout, "\tIPsec ESP algorithm : BLOWFISH (7)\n");
	break;
      default:
	fprintf(stdout, "\tIPsec ESP algorithm not implemented\n");
      }
  if (arg_key_mgmt_goal & GOAL_AUTHENTICATE)
      {
        if (arg_key_mgmt_goal & GOAL_ENCRYPT)
 		    strcpy(msg1,  "With authentication algorithm : ");  
	else
 		    strcpy(msg1,  "IPsec AH algorithm : ");  
      switch (arg_auth_alg)
	{
	case AH_MD5:
	  fprintf(stdout, "\t%s MD5 (1) \n", msg1);
	  break;
	case AH_SHA:
	  fprintf(stdout, "\t%s SHA (2) \n", msg1);
	  break;
	default:
	  fprintf(stdout, "\t%s not implemented\n", msg1);
	}
     }
  if (arg_pfs_requested)  
	fprintf(stdout, "\tPFS : YES\n");
  else                    
	fprintf(stdout, "\tPFS : NO\n");
  if (arg_replay_protection)  
	fprintf(stdout, "\tReplay Protection : YES\n");
  else                    
	fprintf(stdout, "\tReplay Protection : NO\n");
  if (arg_key_mgmt_goal & GOAL_ENCRYPT)
	{
	if (arg_enc_alg ==  ESP_DES_IV64)
       		fprintf(stdout, "\tEncryption IV length : 8 bytes\n");
	else if (arg_enc_alg == ESP_NULL)
       		fprintf(stdout, "\tEncryption IV length : 0 bytes\n");
	else
       		fprintf(stdout, "\tEncryption IV length : %d bytes\n", arg_enc_iv_len);
	}
  if (arg_enc_key_len)  
	fprintf(stdout, "\tEncryption key length: %d bytes (%d bits)\n", 
		arg_enc_key_len, 8 * (arg_enc_key_len));
  if (arg_key_mgmt_goal & GOAL_TUNNEL)  
	fprintf(stdout, "\tMode : TUNNEL\n");
  else                              
	fprintf(stdout, "\tMode : TRANSPORT\n");
  fprintf(stdout, "\tPort # : %d\n", our_port);
  if (enc_iv_len_set)
  	fprintf(stdout, "\tDEFAULT Encryption IV length : %d bytes\n", arg_enc_iv_len);
 fprintf(stdout, "\tDEFAULT Oakley SA life duration : %d seconds\n", arg_oakley_life_duration_seconds);
 if (arg_ipsec_life_duration_seconds) 
  	fprintf(stdout, "\tDEFAULT IPsec SA life duration : %d seconds\n", arg_ipsec_life_duration_seconds);
 if (arg_ipsec_life_duration_kbytes) 
  	fprintf(stdout, "\tDEFAULT IPsec SA life duration : %lu kbytes\n", arg_ipsec_life_duration_kbytes);
  fprintf(stdout, "\n******************** STARTING ******************* STARTING ********************\n");
  if (!arg_initiator)
      fprintf(stdout, "\nReady to receive packets from Initiator\n");
#endif DEBUG  

  call_server();
#ifdef DEBUG_IN_OUT
  in_out_functions(" Q main | in main.c"); /* should never reach this */
#endif
  exit(-1);        /* Shouldn't ever reach this either.*/
}

u_int32_t getaddr(char *s)
{
	struct hostent *h;
	u_long **haddr;
	u_int32_t paddr;

	if (!strcmp(s,"0")) return 0;

	if (h=gethostbyname(s)){

		switch (h->h_addrtype){
		case AF_INET:
			haddr = (u_long **)h->h_addr_list;
			paddr = (*(struct in_addr **)haddr)->s_addr; 
			return paddr;
		break;
		default:
			return 0;
		break;
		}
	}
	return 0;
}
