/* This program is an implementation of the IKE Internet Standard.
 * PlutoPlus Copyright (C) 1999 Sheila Frankel - for details see COPYING.
 * Pluto Copyright (C) 1997 Angelos D. Keromytis - for details see COPYING.others.
 */

/* misc.c - This file contains miscellaneous functions */

#ifdef DEBUG
#include <netinet/in.h>
#include <stdio.h>
#include <string.h>    /*for strstr */
#include "constants.h"
#include "argdefs.h"
#include "state.h"
#include "packet.h"   /*for the struc of isakmp_hdr */
#include "defs.h"

void show_header(struct isakmp_hdr *isa)
{
  int i;

  fprintf(stdout, "\nISAKMP HEADER : \n");
  fprintf(stdout, "\tInitiator Cookie(%d): \t", COOKIE_SIZE);
  for (i = 0; i < COOKIE_SIZE; i++)
    fprintf(stdout, "%02x ", isa->isa_icookie[i]); 
  fprintf(stdout, "\n\tResponder Cookie(%d): \t", COOKIE_SIZE);
  for (i = 0; i < COOKIE_SIZE; i++)
    fprintf(stdout, "%02x ", isa->isa_rcookie[i]); 
  fprintf(stdout, "\n\tNext Payload  : \t%u\n", isa->isa_np);
  fprintf(stdout, "\tMajor Version : \t%u\n", isa->isa_maj);
  fprintf(stdout, "\tMinor Version : \t%u\n", isa->isa_min);
  fprintf(stdout, "\tExchange Type : \t%u\n", isa->isa_xchg);
  fprintf(stdout, "\tFlags         : \t%u\n", isa->isa_flags);
  fprintf(stdout, "\tMessage ID    : \t%x\n", ntohl(isa->isa_msgid)); 
  fprintf(stdout, "\tLength        : \t%d\n\n", ntohl(isa->isa_length));

}

/**************************************************/
int show_payloads(u_char *buf , short received) 
{
  struct isakmp_generic *isag;
  struct isakmp_hdr     *isa;
  int                    ptr_buf;
  int                    k;

  isa = (struct isakmp_hdr *) buf;
  if (received)
    {
      fprintf(stdout, "The message RECEIVED (msgid=%x) has the following payloads : \nHDR ", ntohl(isa->isa_msgid));  
    }
  else
    {
      fprintf(stdout, "The message SENT (msgid=%x) has the following payloads : \nHDR ", ntohl(isa->isa_msgid));  
    }
  switch(isa->isa_np)
    {
    case ISAKMP_NEXT_NONE:
      fprintf(stdout, "+ NONE (%d)", ISAKMP_NEXT_NONE);
      break;
    case ISAKMP_NEXT_SA:
      fprintf(stdout, "+ SA (%d) ", ISAKMP_NEXT_SA);
      break;
    case ISAKMP_NEXT_KE:
      fprintf(stdout, "+ KE (%d) ", ISAKMP_NEXT_KE);
      break;
    case ISAKMP_NEXT_ID:
      fprintf(stdout, "+ ID (%d) ", ISAKMP_NEXT_ID);
      break;
    case ISAKMP_NEXT_CERT:
      fprintf(stdout,  "+ CERT (%d) ", ISAKMP_NEXT_CERT);
      break;
    case ISAKMP_NEXT_CR:
      fprintf(stdout,  "+ CERT_REQUEST (%d) ", ISAKMP_NEXT_CR);
      break;
    case ISAKMP_NEXT_HASH:
      fprintf(stdout, "+ HASH (%d) ", ISAKMP_NEXT_HASH);
      break;
    case ISAKMP_NEXT_SIG:
      fprintf(stdout,  "+ SIG (%d) ", ISAKMP_NEXT_SIG);
      break;
    case ISAKMP_NEXT_NONCE:
      fprintf(stdout, "+ NONCE (%d)", ISAKMP_NEXT_NONCE);
      break;
    case ISAKMP_NEXT_N:
      fprintf(stdout,  "+ NOTIFICATION (%d)", ISAKMP_NEXT_N);
      break;
    case ISAKMP_NEXT_D:
      fprintf(stdout,  "+ DELETE (%d) ", ISAKMP_NEXT_D);
      break;
    case ISAKMP_NEXT_Vendor_ID:
      fprintf(stdout,  "+ VENDOR_ID (%d) ", ISAKMP_NEXT_Vendor_ID);
      break;
    default:
      fprintf(stdout,  " UNKNOWN (%d), *** ERROR ***\n", isag->isag_np);
    }
  ptr_buf = SIZEOF_HDR_PAYLOAD;
  isag = (struct isakmp_generic *) (buf + ptr_buf);
  while (ptr_buf < ntohl(isa->isa_length))
    {
      switch(isag->isag_np)
	{
	case ISAKMP_NEXT_NONE:
	  fprintf(stdout, "+ NONE (%d)", ISAKMP_NEXT_NONE);
	  break;
	case ISAKMP_NEXT_SA:
	  fprintf(stdout, "+ SA (%d) ", ISAKMP_NEXT_SA);
	  break;
	case ISAKMP_NEXT_KE:
	  fprintf(stdout, "+ KE (%d) ", ISAKMP_NEXT_KE);
	  break;
	case ISAKMP_NEXT_ID:
	  fprintf(stdout, "+ ID (%d) ", ISAKMP_NEXT_ID);
	  break;
	case ISAKMP_NEXT_CERT:
	  fprintf(stdout,  "+ CERT (%d) ", ISAKMP_NEXT_CERT);
	  break;
	case ISAKMP_NEXT_CR:
	  fprintf(stdout,  "+ CERT_REQUEST (%d) ", ISAKMP_NEXT_CR);
	  break;
	case ISAKMP_NEXT_HASH:
	  fprintf(stdout, "+ HASH (%d) ", ISAKMP_NEXT_HASH);
	  break;
	case ISAKMP_NEXT_SIG:
	  fprintf(stdout,  "+ SIG (%d) ", ISAKMP_NEXT_SIG);
	  break;
	case ISAKMP_NEXT_NONCE:
	  fprintf(stdout, "+ NONCE (%d)", ISAKMP_NEXT_NONCE);
	  break;
	case ISAKMP_NEXT_N:
	  fprintf(stdout,  "+ NOTIFICATION (%d)", ISAKMP_NEXT_N);
	  break;
	case ISAKMP_NEXT_D:
	  fprintf(stdout,  "+ DELETE (%d) ", ISAKMP_NEXT_D);
	  break;
        case ISAKMP_NEXT_Vendor_ID:
          fprintf(stdout,  "+ VENDOR_ID (%d) ", ISAKMP_NEXT_Vendor_ID);
          break;
	default:
	  fprintf(stdout,  " UNKNOWN (%d), *** ERROR ***\n", isag->isag_np);
	}
      /* point after the next payload */
      k = ntohs(isag->isag_length);
      ptr_buf += k;
      if ((ptr_buf + sizeof(struct isakmp_generic) < ntohl(isa->isa_length)) &&
		(k > 0))
	isag = (struct isakmp_generic *) (buf + ptr_buf);
      else
	{
	  ptr_buf = ntohl(isa->isa_length);
	}
    } /* end while */
  fprintf(stdout, " ... total length : %d\n\n", ntohl(isa->isa_length));
}

#ifdef DEBUG_IN_OUT
/***************************************************/
void in_out_functions(char* msg)
{
  static int tabul;
  int        k=0;
  int        exit=1;
  
  if (strstr(msg, " E ")) 
    {
      tabul++;
      exit=0;
    }
  
  while((++k < tabul) && (k < 12)) 
      fprintf(stderr, "    ");
  
  if (exit)
    fprintf(stderr, " <");

  fprintf(stderr, msg);
  fprintf(stderr, "\n");

  if (exit)
    tabul--;

}
#endif DEBUG_IN_OUT

/**********************************************************************/
int  packet_dump(u_char *buf, 
		  int     option,
		  int     sizetodump) /* if we want to dump a certain size of the packet */
{
  int                k;
  struct isakmp_hdr *isa;
  u_int32_t          packet_size;

  fprintf(stdout, "\n");
  switch (option)
    {
    case DUMP_MSG:
      fprintf(stdout, "%s\n", buf);
      return 0;
      break;
    case DUMP_SENT_BEFORE_ENC:
      fprintf(stdout,"\tSENT-SENT-SENT ***** BEFORE ENCRYPTION\n");
      break;
    case DUMP_SENT_AFTER_ENC:
      fprintf(stdout,"\tSENT-SENT-SENT ***** AFTER ENCRYPTION\n");
      break;
    case DUMP_SENT_NO_ENC:
      fprintf(stdout,"\tSENT-SENT-SENT ***** NO ENCRYPTION\n");
      break;
    case DUMP_RECVD_BEFORE_DEC:
      fprintf(stdout,"\tRECEIVED-RECEIVED-RECEIVED ***** BEFORE DECRYPTION\n");
      break;
    case DUMP_RECVD_AFTER_DEC:
      fprintf(stdout,"\tRECEIVED-RECEIVED-RECEIVED ***** AFTER DECRYPTION\n");
      break;
    case DUMP_RECVD_NO_DEC:
      fprintf(stdout,"\tRECEIVED-RECEIVED-RECEIVED ***** NO ENCRYPTION\n");
      break;
    case DUMP_RECVD_OR_SENT_PKT:
      break;
    default:
    }
  
  isa = (struct isakmp_hdr *) buf;

  fprintf(stdout, "-----------------------------------------------------------------------\n");
  fprintf(stdout, "\tHDR (%d)\n", SIZEOF_HDR_PAYLOAD);
  for (k = 0; k < SIZEOF_HDR_PAYLOAD; k++)
    {
      fprintf(stdout, "%02x", *(buf + k) );
      if ((k + 1) % 4 == 0) 
	{
	  fprintf(stdout, " ");
	}
      if ((k + 1) % 32 == 0) 
	{
	  fprintf(stdout, "\n");
	}
    }

  if(!sizetodump)   
  		packet_size = ntohl(isa->isa_length);
  else             
  		packet_size = sizetodump;

  fprintf(stdout, "\n\tBODY (%d) \n", packet_size - SIZEOF_HDR_PAYLOAD);
  for (k=SIZEOF_HDR_PAYLOAD; k < packet_size; k++)
    {
      fprintf(stdout, "%02x", *(buf + k) );
      if ((k + 1) % 4 == 0) 
	{
	  fprintf(stdout, " ");
	}
      if ((k + 5) % 32 == 0) 
	{
	  fprintf(stdout, "\n");
	}
    }

  if ((packet_size - SIZEOF_HDR_PAYLOAD)%32)
    {
	  fprintf(stdout, "\n");
    }

  fprintf(stdout, "-----------------------------------------------------------------------\n");
}

/**********************************************************************/
void*  format_dump(u_char*  buf, 
		   int      length)
{
  int      k;
  
  for (k = 0; k < length ; k++)
    {
      fprintf(stdout, "%02x", *(buf + k) );
      if ((k + 1) % 4 == 0) 
	{
	  fprintf(stdout," ");
	}
      if ((k + 1 ) % 32 == 0 && k+1 != length) 
	{
	  fprintf(stdout, "\n");
	}
    }
	  fprintf(stdout, "\n");
}

/**********************************************************************/
char* exchange_state_dump(int    exchg_state)
{
  switch(exchg_state)
    {
    case OAKLEY_MAIN_I_1:
      return( "INITIATOR, MAIN MODE after message 1 was sent");
      break;
    case OAKLEY_MAIN_I_2:
      return( "INITIATOR, MAIN MODE after message 3 was sent");
      break;
    case OAKLEY_MAIN_I_3:
      return( "INITIATOR, MAIN MODE after message 5 was sent");
      break;
    case OAKLEY_MAIN_I_4:
      return( "INITIATOR, MAIN MODE after message 6 was received\nready for QUICK MODE");
      break;
    case OAKLEY_MAIN_R_1:
      return( "RESPONDER, MAIN MODE after message 2 was sent");
      break;
    case OAKLEY_MAIN_R_2:
      return( "RESPONDER, MAIN MODE after message 4 was sent");
      break;
    case OAKLEY_MAIN_R_3:
      return( "RESPONDER, MAIN MODE after message 6 was sent\nready for QUICK MODE");
      break;
    case OAKLEY_QUICK_I_1:
      return( "INITIATOR, QUICK MODE after message 1 was sent");
      break;
    case OAKLEY_QUICK_I_2:
      return( "INITIATOR, QUICK MODE after message 3 was sent");
      break;
    case OAKLEY_QUICK_R_1:
      return( "INITIATOR, QUICK MODE intermediate state used in demux.c");
      break;
    case OAKLEY_QUICK_R_2:
      return( "INITIATOR, QUICK MODE after message 2 was sent");
      break;
    case OAKLEY_QUICK_R_3:
      return( "INITIATOR, QUICK MODE after message 3 was received");
      break;
    default:
      return( "INVALID");
    }
}

/**********************************************************************/
void* success_printout(struct state *st)
{
  
  if (arg_verbose & DEBUG_VERBOSE)
  	fprintf(stdout, "transmitted %d bytes\n", st->st_packet_len);
  fprintf(stdout, "\n\n************** PHASE 2 COMPLETED ************* PHASE 2 COMPLETED **************\n\n");
  
  /* ISAKMP ENC/AUTH */
      fprintf(stdout, "\tISAKMP SA algorithms (enc/hash) : ");
  switch (st->st_enc)
    {
    case OAKLEY_3DES_CBC:
      fprintf(stdout, "3DES_CBC(%d)", st->st_enc);
      break;
    case OAKLEY_DES_CBC:
      fprintf(stdout, "DES_CBC(%d)", st->st_enc);
      break;
    default:
      fprintf(stdout, "not implemented(%d)", st->st_enc);
    }
  switch (st->st_hash)
    {
    case OAKLEY_MD5:
      fprintf(stdout, "/HMAC_MD5(%d)\n", st->st_hash);
      break;
    case OAKLEY_SHA:
      fprintf(stdout, "/HMAC_SHA(%d)\n", st->st_hash);
      break;
    default:
      fprintf(stdout, "/not implemented(%d)\n", st->st_hash);
    }


  if (st->st_protoid == PROTO_IPSEC_ESP)
    {
      fprintf(stdout, "\tIPSEC ESP algorithm : ");
      switch (st->st_transid)
	{
	case ESP_DES_IV64:
	  fprintf(stdout, "DES_IV64 (%d)\n", st->st_transid);
	  break;
	case ESP_DES:
	  fprintf(stdout, "DES (%d)\n",  st->st_transid);
	      break;
	case ESP_3DES:
	  fprintf(stdout, "3DES (%d)\n",  st->st_transid);
	  break;
	case ESP_RC5:
	  fprintf(stdout, "RC5 (%d)\n", st->st_transid);
	  break;
	case ESP_IDEA:
	  fprintf(stdout, "IDEA (%d)\n", st->st_transid);
	  break;
	case ESP_BLOWFISH:
	  fprintf(stdout, "BLOWFISH (%d)\n", st->st_transid);
	  break;
	case ESP_NULL:
	  fprintf(stdout, "NULL (%d)\n", st->st_transid);
	  break;
	default:
	  fprintf(stdout, "not implemented (%d) \n",  st->st_transid);
	}

      if (st->st_att_authentication_alg)
       switch (st->st_att_authentication_alg)
	{
	case AUTH_ALGO_HMAC_MD5:
	  fprintf(stdout, "\t     With AUTH algorithm : HMAC_MD5 (%d)\n", st->st_att_authentication_alg);
	  break;
	case AUTH_ALGO_HMAC_SHA_1:
	  fprintf(stdout, "\t     With AUTH algorithm : HMAC_SHA (%d)\n", st->st_att_authentication_alg);
	  break;
	case AUTH_ALGO_DES_MAC:
	  fprintf(stdout, "\t     With AUTH algorithm : DES_MAC (%d)\n", st->st_att_authentication_alg);
	  break;
	case AUTH_ALGO_KPDK:
	  fprintf(stdout, "\t     With AUTH algorithm : KPDK (%d)\n", st->st_att_authentication_alg);
	  break;
	default:
	  fprintf(stdout, "\t     With AUTH algorithm : not recognized (%d)\n", st->st_att_authentication_alg);
	}
    }
  else
    {
      if (st->st_protoid == PROTO_IPSEC_AH)
	switch (st->st_transid)
	  {
	  case AH_MD5:
	    fprintf(stdout, "\tIPsec AH algorithm : HMAC_MD5 (%d) \n", st->st_transid);
	    break;
	  case AH_SHA:
	    fprintf(stdout, "\tIPsec AH algorithm : HMAC_SHA (%d) \n", st->st_transid);
	    break;
	  default:
	    fprintf(stdout, "\tIPsec AH algorithm : not implemented (%d)\n", st->st_transid);
	  }
      else
	fprintf(stdout, "\nERROR : the Protocol ID is neither ESP or AH!\n");
    }     
  if (st->st_pfs_handle)
    fprintf(stdout, "\tPFS : YES\n");
  else
    fprintf(stdout, "\tPFS : NO\n");

  if (arg_replay_protection)  
	fprintf(stdout, "\tReplay Protection : YES\n");
  else                    
	fprintf(stdout, "\tReplay Protection : NO\n");

  if (st->st_protoid == PROTO_IPSEC_ESP)
	if (st->st_transid ==  ESP_DES_IV64)
       		fprintf(stdout, "\tEncryption IV length : 8 bytes\n");
	else if (st->st_transid == ESP_NULL)
       		fprintf(stdout, "\tEncryption IV length : 0 bytes\n");
	else
       		fprintf(stdout, "\tEncryption IV length : %d bytes\n", arg_enc_iv_len);

  if (st->st_esp_keymat_len)  
	fprintf(stdout, "\tEncryption key length: %d bytes (%d bits)\n", st->st_esp_keymat_len,
		8 * (st->st_esp_keymat_len));

  if (st->st_att_encapsulation_mode == ENCAPSULATION_MODE_TUNNEL)
    fprintf(stdout, "\tEncapsulation mode : TUNNEL\n");
  else
    if (st->st_att_encapsulation_mode == ENCAPSULATION_MODE_TRANSPORT)
      fprintf(stdout, "\tEncapsulation mode : TRANSPORT\n");
}

#endif DEBUG
