/* This program is an implementation of the IKE Internet Standard.
 * PlutoPlus Copyright (C) 1999 Sheila Frankel - for details see COPYING.
 * Pluto Copyright (C) 1997 Angelos D. Keromytis - for details see COPYING.others.
 */

#if defined(__OpenBSD__) || defined(__NetBSD__)
#include <machine/endian.h>
#elif linux
#if defined(i386) && !defined(__i386__)
#define __i386__ 1
#define MYHACKFORTHIS 1
#endif
#include <endian.h>
#include <asm/byteorder.h>
#ifdef MYHACKFORTHIS
#undef __i386__
#endif
#else
#include <sys/endian.h>
#endif

struct isakmp_hdr
{
    u_int8_t    isa_icookie[COOKIE_SIZE];
    u_int8_t    isa_rcookie[COOKIE_SIZE];
    u_int8_t    isa_np;                 /* Next payload */
#if BYTE_ORDER == BIG_ENDIAN
    u_int8_t    isa_maj:4;		/* Major version */
    u_int8_t    isa_min:4;		/* Minor version */
#elif BYTE_ORDER == LITTLE_ENDIAN
    u_int8_t    isa_min:4;
    u_int8_t    isa_maj:4;
#else
#error "Check your endianness"
#endif
    u_int8_t    isa_xchg;		/* Exchange type */
    u_int8_t    isa_flags;		
    u_int32_t   isa_msgid;		/* Message ID */
    u_int32_t   isa_length;		/* Length of message */
};

struct isakmp_attribute
{
    union 
    {
	struct _heh
	{
#if BYTE_ORDER == BIG_ENDIAN
	    u_int16_t isaat_af:1;		/* TLV/TV flag */
	    u_int16_t isaat_rtype:15;		/* Attribute type */
#elif BYTE_ORDER == LITTLE_ENDIAN
	    u_int16_t isaat_rtype:15;
	    u_int16_t isaat_af:1;
#else
#error "Check your endianness"
#endif
	} _heh;
	u_int16_t isaat_type;
    } _hah;
    u_int16_t isaat_lv;			/* Length or value */
};

#define isaat_af     _hah._heh.isaat_af
#define isaat_type   _hah.isaat_type
#define isaat_rtype  _hah._heh.isaat_rtype

/* Handle Variable Length Attributes */
struct isakmp_attribute_var_val
{
    u_int32_t isaatv_val;			/* Length or value */
};

struct isakmp_sa
{
    u_int8_t  isasa_np;			/* Next payload */
    u_int8_t  isasa_reserved;
    u_int16_t isasa_length;		/* Payload length */
    u_int32_t isasa_doi;		/* DOI */
};

struct isakmp_proposal
{
    u_int8_t    isap_np;
    u_int8_t    isap_reserved;
    u_int16_t   isap_length;
    u_int8_t    isap_proposal;
    u_int8_t    isap_protoid;
    u_int8_t    isap_spisize;
    u_int8_t    isap_notrans;		/* Number of transforms */
};

struct isakmp_transform
{
    u_int8_t    isat_np;
    u_int8_t    isat_reserved;
    u_int16_t   isat_length;
    u_int8_t    isat_transnum;		/* Number of the transform */
    u_int8_t    isat_transid;
    u_int8_t    isat_reserved2;
};

struct isakmp_id
{
    u_int8_t    isaid_np;
    u_int8_t    isaid_reserved;
    u_int16_t   isaid_length;
    u_int8_t    isaid_idtype;
    u_int8_t    isaid_reserved2;
    u_int16_t   isaid_reserved3;
};

struct isakmp_generic
{
    u_int8_t    isag_np;
    u_int8_t    isag_reserved;
    u_int16_t   isag_length;
};

struct isakmp_notification
{
    u_int8_t    isan_np;
    u_int8_t    isan_reserved;
    u_int16_t   isan_length;
    u_int32_t   isan_doi;
    u_int8_t    isan_protoid;
    u_int8_t    isan_spisize;
    u_int16_t    isan_type;
};

struct identity
{
    u_int8_t    id_type;
    u_int8_t    id_protoid;
    u_int16_t   id_port;
};
