/* This program is an implementation of the IKE Internet Standard.
 * PlutoPlus Copyright (C) 1999 Sheila Frankel - for details see COPYING.
 * Pluto Copyright (C) 1997 Angelos D. Keromytis - for details see COPYING.others.
 */

/*
 *  server.c - Server main loop and socket initialization routines.
 */

#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>  
#include <sys/time.h>
#include <netdb.h>
#include <unistd.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include "constants.h"
#include "state.h"
#include "defs.h"
#include "argdefs.h"


/**********************************************************************/
/*
 * Initialize the kernel socket.
 */
int init_kernelfd(void)
{
  struct sockaddr_in  sin;
  int                 s;
  
#ifdef DEBUG_IN_OUT
  in_out_functions(" E init_kernelfd |in server.c");
#endif
  sin.sin_family = AF_INET;
  sin.sin_port = htons(our_port + 1);
  sin.sin_addr.s_addr = INADDR_ANY;
  
#ifdef DEBUG
  if (arg_verbose & DEBUG_VERBOSE)
    fprintf(stdout, "init_kernelfd(): listening to port %d\n", our_port + 1);
#endif
  
  s = kernelsock_open();
  
#ifdef DEBUG_IN_OUT
  in_out_functions(" Q init_kernelfd |in server.c");
#endif
  return s;
}



/**********************************************************************/
/*
 * Initialize the sockets.
 */
int init_socket(int *socks)
{
  struct protoent      *proto;
  struct sockaddr_in    sin;
  struct sockaddr_in   *sin2;
  int                   sock;		/* this int is never used!! */
  int                   i;
  int                   j;
  int                   k;
  struct ifconf         ifconf; 
  char                  buf[1024];

#if defined (ZZZZI) || defined (ZZZZR)
  int					ok_addr = 0;
#endif
  
  /* Get a UDP socket */
  
#ifdef DEBUG_IN_OUT
  in_out_functions(" E init_socket |in server.c");
#endif
  proto = getprotobyname("udp");
  
  if (proto == (struct protoent *) NULL)
    socks[0] = socket(PF_INET, SOCK_DGRAM, 0);
  else
    socks[0] = socket(PF_INET, SOCK_DGRAM, proto->p_proto);
  
  if (socks[0] == -1)
    exit_log("socket() failed in init_socket()", 0, 0, 0);
  
  sin.sin_family = AF_INET;
  sin.sin_port = htons(our_port);
  sin.sin_addr.s_addr = INADDR_ANY;
  
#ifdef DEBUG
  if(arg_verbose & DEBUG_VERBOSE)
    fprintf(stdout, "init_socket(): listening to port %d\n", our_port);
#endif
  
  k = 1;
  if (setsockopt(socks[0], SOL_SOCKET, SO_REUSEADDR, (void *)&k, 
		 sizeof(k)) < 0)
    exit_log("setsockopt() failed in init_socket()", 0, 0, 0);
  
  /* bind the socket */
  if (bind(socks[0], (struct sockaddr *)&sin, sizeof(sin)) < 0)
    exit_log("bind() failed in init_socket()", 0, 0, 0);
  
  /* Get local interfaces */
  ifconf.ifc_len = 1024; 
  ifconf.ifc_buf = buf; 
  bzero(buf, 1024); 
 
  if (ioctl(socks[0], SIOCGIFCONF, &ifconf) == -1) 
    exit_log("ioctl() failed in init_socket()", 0, 0, 0); 
    
  /* This loop by Niels Provos */
  /* IFNAMSIZ = 16 -- in <linux/if.h> */
  for (i = 1, j = 0; j < ifconf.ifc_len; j += IFNAMSIZ + 
	 sizeof(struct sockaddr) 
	 , i++)
    {
      sin2 = (struct sockaddr_in *) &buf[IFNAMSIZ + j]; 
      
      if (sin2->sin_family != AF_INET)
	{
	  i--;
	  continue;
	}
      
      if ((socks[i] = socket(PF_INET, SOCK_DGRAM, proto->p_proto)) < 0)
	exit_log("socket() failed in init_socket()", 0, 0, 0); 
      
      if (setsockopt(socks[i], SOL_SOCKET, SO_REUSEADDR, (void *)&k, 
		     sizeof(k)) < 0)
	exit_log("setsockopt() failed in init_socket()", 0, 0, 0);
      
      bzero((void *)&sin, sizeof(sin));
      sin.sin_port = htons(our_port);
      sin.sin_addr = sin2->sin_addr; 
      sin.sin_family = AF_INET; 
#if defined (ZZZZI) || defined (ZZZZR)
    if (arg_key_mgmt_goal & GOAL_TUNNEL) 
    {
	if (sin.sin_addr.s_addr == arg_gateway_addr)
  	  	ok_addr = 1;
    }
    else if (sin.sin_addr.s_addr == arg_dest_addr)
  	  	ok_addr = 1;
#endif ZZZZI || ZZZZR
      
      if (bind(socks[i], (struct sockaddr *)&sin, sizeof(sin)) < 0)
	exit_log("bind() failed in init_socket()", 0, 0,0); 
      
#ifdef DEBUG
      if (arg_verbose & DEBUG_VERBOSE)
	fprintf(stdout, "listening at %s\n", inet_ntoa(sin2->sin_addr));
#endif
    }
#if defined (ZZZZI) || defined (ZZZZR)
  	  if (!ok_addr)
#ifdef WIT
  	  	   exit_log("Incorrect system under test: %s; Restart WIT\n", 
#else
  	  	   exit_log("Incorrect system under test: %s\n", 
#endif WIT
  	  	   		inet_ntoa(arg_dest_addr), 0, 0);
#endif ZZZZI || ZZZZR
  
#ifdef DEBUG
  if (arg_verbose & DEBUG_VERBOSE)
    fprintf(stdout, "listening at %d interfaces\n", i - 1);
#endif
#ifdef DEBUG_IN_OUT
  in_out_functions(" Q init_socket |in server.c");
#endif
  return i;
}



/**********************************************************************/
/*
 * This routine listens for incoming ISAKMP packets, kernel PF_KEY requests,
 * handles packet retransmits and other events.
 */
void call_server(void)
{
  struct sockaddr_in 	sin;
  int 			kernelfd;
  int 			sock[256];  /* XXX couldn't we use the value defined 
				      in <linux/posix.h>, i.e. __FDSET_LONGS ? */
  int 			numsocks;
  int 			i;
  int 			maxfd;
  int 			k;
  fd_set 		readfds;   /* it's a struct{unsigned long fds_bits[256]*/
  struct timeval        tm;
#ifdef WIT
  time_t   		tm_begin; 
#endif WIT

#ifdef DEBUG_IN_OUT
  in_out_functions(" E call_server |in server.c");
#endif
  
  numsocks = init_socket(sock);
  kernelfd = init_kernelfd();
  
#ifdef DEBUG
if (arg_verbose & DEBUG_VERBOSE)
  {
    fprintf(stdout, "socket numbers: ");
    for (k = 0; k < numsocks; k++)
      fprintf(stdout, "%d ", sock[k]);
    fprintf(stdout, "\t");
    fprintf(stdout, "kernel socket: %d\n", kernelfd);
  }
#endif
  
#ifdef WIT
/* Save time as point of reference for elapsed time */
  tm_begin = time((time_t *) NULL);
#endif WIT
  while (1)
    {
#ifdef WIT
/* If nothing interesting has happened for END_PLUTO_DELAY seconds,
   end PlutoPlus   */
  if ((time((time_t *) NULL) - tm_begin) > END_PLUTO_DELAY)
    exit_log("No messages received for %d seconds", END_PLUTO_DELAY, 0, 0);
#endif WIT
      /* FD_SET(num,var) sets bit num in var */
      for (k = 1; k < numsocks; k++)
	FD_SET(sock[k], &readfds);
      FD_SET(kernelfd, &readfds);
      
      maxfd = (sock[numsocks - 1] > kernelfd ? sock[numsocks - 1] : 
	       kernelfd) + 1;
      
      i = next_event(); 

      /* Is there any pending event ? */
      /* next-event returns the time until the next event */
      /* in the queue expires. -1 if no job in queue      */      
      if (i == -1)        /* No job in queue                                  */
	{
#ifndef WIT
/* Wait indefinitely */
	  i = select(maxfd, &readfds, NULL, NULL, NULL); 
#else
/* WIT - Only wait END_PLUTO_DELAY seconds */
	  tm.tv_sec = END_PLUTO_DELAY;
	  tm.tv_usec = 0;
	  i = select(maxfd, &readfds, NULL, NULL, &tm); 
#endif WIT
	}
      else
	{	  
	  tm.tv_sec = i;
	  tm.tv_usec = 3600;

	  i = select(maxfd, &readfds, NULL, NULL, &tm);
	  /*  return 0 if timeout expires before anything interesting happens  */
	  /*  return -1 on error                                               */
	  /*  return the number of descriptor contained in readfds on success. */
	}
      
      if (i == -1)
	exit_log("select() failed in call_server()", 0, 0, 0);
      
      /* FD_ISSET(num,var) checks bit num in var */
      for (k = 1; k < numsocks; k++)
	if (FD_ISSET(sock[k], &readfds))
	  {
	    comm_handle(kernelfd, sock[k]);
#ifdef WIT
/* Received message - Reset point of reference for elapsed time */
  tm_begin = time((time_t *) NULL);
#endif WIT
	  }
      
      /* FD_ISSET(num,var) checks bit num in var */
      if (FD_ISSET(kernelfd, &readfds))
	{
#ifdef DEBUG
#ifndef ZZZZR
	  if (arg_verbose & DEBUG_VERBOSE)
	    {
	      fprintf(stdout, "received kernel message");
	      fprintf(stdout,"\t call kernel_handle(kernelfd, sock[0])\n");
    fprintf(stdout, "kernel_handle called for kernelfd = %d\n", kernelfd);
#ifdef WIT
/* Received kernel message - Reset point of reference for elapsed time */
  tm_begin = time((time_t *) NULL);
#endif WIT
	    }
#endif ZZZZR
#endif DEBUG
	  kernel_handle(kernelfd, sock[0]);
	}
      
      if (i == 0)   /* Event */
	{
	  event_handle(kernelfd, sock[0]);
	}
    }
#ifdef DEBUG_IN_OUT
  in_out_functions(" Q call_server |in server.c");
#endif
}
