/* This program is an implementation of the IKE Internet Standard.
 * PlutoPlus Copyright (C) 1999 Sheila Frankel - for details see COPYING.
 * Pluto Copyright (C) 1997 Angelos D. Keromytis - for details see COPYING.others.
 */

/* state.h */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <time.h>
#include "gmp.h"

struct event
{
  time_t          ev_time;
  u_int32_t       ev_type;        /* Event type */
  void           *ev_ptr;         /* Pointer to event specific structure */
  u_int32_t       ev_ptr_len;     /* Length of ptr, where applicable */
  struct event   *ev_next;        /* Pointer to next event */
};


struct state
{
  time_t             st_expire;	               /* When this SA expires  */ /*time_t <=> long */
  u_int16_t          st_hash;		       /* Hash algorithm algorithm used for Isakmp exchanges -MD5/SHA for now - */
  u_int16_t          st_enc;                   /* Encryption algorithm used for ISAKMP exchanges -DES/3DES for now - */
  u_int16_t          st_prf;		       /* An alternate pseudo random function - the one from st->st_hash for now -*/
  u_int16_t          st_auth;		       /* Authentication method used - preshared key for now - */
  u_int32_t          st_group;	               /* Oakley group - group 1 for now - */
  u_int32_t          st_doi;                   /* the DOI used - ipsec for now - */
  u_int32_t          st_situation;             /* Situation definition - SIT_IDENTITY_ONLY for now */
  /* Should only be used when we are responder. */
  u_int32_t          st_goal;                  /* What is the SA (phase 1 or 2 ) we want ? */
  u_int32_t          st_msgid;	               /* MSG-ID from header */
  u_char             st_icookie[COOKIE_SIZE];  /* Initiator Cookie */
  u_char             st_rcookie[COOKIE_SIZE];  /* Responder Cookie */
  struct sockaddr    st_peer;                  /* Peer's address - sizeof(struct sockaddr) == 16 - */
  u_int16_t          st_state;                 /* State of exchange */
  u_int16_t          st_keymat_len;	       /* Length of KEYMAT */
  u_int16_t          st_ah_keymat_len;	       /* Length of KEYMAT for AH */
  u_int16_t          st_esp_keymat_len;	       /* Length of KEYMAT for ESP */
  u_char            *st_packet;                /* Transmitted packet or packet to transmit */
  u_int32_t          st_packet_len;            /* Size of transmitted packet */
  /* identities */
  u_char            *st_myidentity;            /* My identity */
  u_int16_t          st_myidentity_len;        /* Length of identity */
  u_int16_t          st_myidentity_port;       /* Port used to communicate - 500 in non_debug mode - */
  u_int8_t           st_myidentity_type;       /* Our type of identity - IPv4 for now -  */
  u_int8_t           st_myidentity_protoid;    /* Transport protocol used - UDP - */
  u_char            *st_peeridentity;          /* Peer's identity */
  u_int16_t          st_peeridentity_len;      /* Length of Peer's identity */
  u_int16_t          st_peeridentity_port;     /* Port the peer uses - same as ours for now - */
  u_int8_t           st_peeridentity_type;     /* Peer's type of identity - IPv4 for now */
  u_int8_t           st_peeridentity_protoid;  /* Transport protocol used -UDP - */
/* Send/Accept Client IDs */
  /* Client identities */
  u_char             *st_myclientid;            /* My client's identity */
  u_int16_t          st_myclientid_len;        /* Length of identity */
  u_int16_t          st_myclientid_port;       /* Client Port for IPSEC SA */
  u_int8_t           st_myclientid_type;       /* Client identity type - IPv4 for now */
  u_int8_t           st_myclientid_protoid;    /* Client protocol for IPSEC SA */
  u_char             *st_peerclientid;          /* Peer client's identity */
  u_int16_t          st_peerclientid_len;        /* Length of identity */
  u_int16_t          st_peerclientid_port;     /* Peer's client Port for IPSEC SA */
  u_int8_t           st_peerclientid_type;     /* Peer's client identity type */
  u_int8_t           st_peerclientid_protoid;  /* Peer's client protocol for IPSEC SA */

  u_int8_t           st_retransmit;            /* Number of retransmits still to be done - policy matter ; 2 max for now -*/
  u_int8_t           st_spi_len;               /* Length of the SPI - should be 4 to be compliant to IPSEC - */
  u_int8_t           st_peer_spi_len;          /* Length of the SPI - should be 4 to be compliant to IPSEC - */
  u_int8_t           st_pfs_handle;            /* Set if Perfect Forward Secrecy is used */  
  u_char            *st_proposal;              /* Constructed/accepted proposal */
  u_char            *st_sa;		       /* Constructed/uses SA */
  u_char            *st_ni;                    /* Initiator's nonce - Ni - */
  u_char            *st_nr;                    /* Responder's nonce - Nr - */
  u_int8_t           st_shared_in_use;         /* 1 if the shared secret is in use */ /* not used for now - */
  u_int8_t           st_gi_in_use;	       /* 1 if st_gi is allocated */ /* not used for now - */
  u_int8_t           st_gr_in_use;             /* 1 if st_gr is in use */ /* not used for now - */
  u_int8_t           st_sec_in_use;            /* 1 if st_sec is in use */ /* not used for now - */
  /* Keying material */
  u_char            *st_skeyid;                /* Keying material for the other keying material and for hash of phase 1 */ 
  u_char            *st_skeyid_d;              /* Keying material for phase 2 keying material */
  u_char            *st_skeyid_a;              /* Keying material for phase 2 authentications */
  u_char            *st_skeyid_e;              /* Keying material for encryption of IKE mesages. */
  u_int16_t          st_skeyid_len;	       /* Key material lengths */
  u_int16_t          st_skeyid_d_len;
  u_int16_t          st_skeyid_a_len;
  u_int16_t          st_skeyid_e_len;
  u_char            *st_keymat;	               /* Key material - used in phase 2 - */
  u_char            *st_peer_keymat;           /* Peer's Key material - used in phase 2 - useful for debuging/webbased test server */
  u_char            *st_iv;		       /* IV for encryption */

  u_char            *st_lastblock;	       /* Last block of Phase 1 - kept for pahase 2 IV generation - */
  u_char            *st_spi;                   /* SPI in use */
  u_char            *st_peer_spi;              /* Peer's SPI in use */
  u_int16_t          st_iv_len;
  u_int16_t          st_lastblock_len;
  u_int16_t          st_att_authentication_alg;/* the authentication algo used */
  u_int16_t          st_ca_name;
  u_int16_t          st_flags;                      /* re-negotiated, deleted */
  u_int8_t           st_transid;
  u_int8_t           st_protoid;
  u_int8_t           st_peer_transid;
  u_int8_t           st_peer_protoid;
  u_int16_t          st_peer_keymat_len;

  u_int16_t          st_att_encapsulation_mode;
  u_int16_t          st_att_group;
  time_t             st_att_sa_duration_seconds;
  u_int32_t          st_att_sa_duration_kbytes;	/* Kilobytes */

  /* DH exchange values */
  MP_INT             st_gi;		       /* Initiator public value */
  MP_INT             st_gr;		       /* Responder public value */
  MP_INT             st_sec;		       /* Our secret value */
  MP_INT             st_shared;	               /* Derived shared secret */

  struct event      *st_event;               /* Pointer to pending event */
  struct state      *st_phase1;	             /* Pointer to Phase 1 object */
  struct state      *st_next;                /* Next in list */
  struct state      *st_prev;		     /* Previous in list */
};
