<?php

include("../style.php");

$color = "3576BA";

pageheader("$color",2,"Linux release: Fedora Core 6 Installation");

$content =  <<<EOF1

<H1>Installing Openswan and Linux OCF kernel on Fedora Core 6</H1>
<OL>
<h2>Getting the important files from Hifn</H2>
<UL>
<LI>Go to www.hifn.com and click "extranet login". If you do not already have an account, you can request one there.</LI>
<LI>Go to "Document Library" then "software downloads", then "integrated open source systems" and finally "Linux 2.6 and 795x."</LI>
<LI> Download the two files there and save them in a nice safe place..</LI>
</UL>

<h2>Installing Fedora Core 6</H2>
<P>Make sure you use an unwanted disk (we will wipe it) that is at least 5 Gigs in size.
<P>Please note that you will need to install a <strong>32-bit</strong> version
of Fedora Core, as we do not support 64-bit kernels at this time.
<li>Insert CD #1
<li>Power up and type "linux text" at the boot prompt.
<li>Skip the Media Test
<li>Select OK at the Welcome Screen
<li>Select English at the Language Window
<li>Select US at the Keyboard Window
<li>Select "Remove all Partitions on selected drives..." and OK; If you are installing on top of an existing Linux distro, you might need to select "Reinstall System" if it is offered.
<li>Answer Yes to confirm removing all partitions.
<li>Answer Yes to "Review and modify partitioning layout?"
<li>Select OK in the Partitioning Window
<li>Select "Use Grub bootloader"
<li>Do not define any special options for the Grub bootloader
<li>Do not put a Grub password
<li>Select OK on the Boot Loader Configuration Window
<li>Select to Install on Master Boot Record
<li>Choose DHCP for Network Configuration for all your devices, but disable IPv6 support.
<li>Select "Automatically via DHCP" at the Host Name Configuration Window
<li>Select and confirm your timezone
<li>Choose and enter a root password
<li>In the Package Selection Window, only select the following groups (you may select more if you wish, but this is the minimum):
<pre>Software Development
</pre>
<LI>Select "OK" at the next screen that warns you that a log will be available.
Once you have confirmed your selection, the installation will actually begin. At this point, you might get a disk partitioning error; if this occurs, reboot the machine and start again; this error will not appear again.

Stick around as the installation will ask you for CDs #1, #2, and #3.
In case of total panic on your part, please refer to
	<a href=http://fedora.redhat.com/docs/fedora-install-guide-en/fc5/>http://fedora.redhat.com/docs/fedora-install-guide-en/fc6/</a>

<H2>Post Installation Configuration</H2>
<P>The boot procedure will bring you into a configuration window.  If you do not select anything inside of a minute, the bootup will continue to the regular console prompt.  Let the configuration window timeout and:
<li>Login as root
<li>yum update yum
<li>yum update
<li>yum install iperf
<li>adduser -m (user)
<li>passwd (user)
<li>setup
<P>This will bring up the Text Mode Setup Utility.
<LI>Select Firewall Configuration and disable the firewall.
<LI>Exit the Text Mode Setup utility.
<LI>Edit the file /etc/sysconfig/selinux and replace
<PRE>
SELINUX=enforcing
</PRE>
to
<PRE>
SELINUX=disabled
</PRE>
<LI>Edit the files <B>/etc/sysconfig/network-scripts/ifcfg-eth&lt;n&gt;</B> and add the following:
<PRE>
MTU=9000
</PRE>
<LI>Reboot
<h2>Building the Linux OCF kernel</h2>
<LI>Login as the (user) you created above, and get the OCF linux kernel source code: 
<pre>
cd \$HOME
(Now copy the file linux-ocf-v3.0.06.tgz that you downloaded from Hifn earlier, and then:)
tar -xzvf linux-ocf-v3.0.06.tgz
cd linux-ocf-v3.0.06
cp /boot/config-`uname -r` .config
make oldconfig
</pre>
<LI>Configure the Kernel; Answer "y" to the following items, for all others, just use the default:
<pre>
KLIPS26
KLIPS_AH
KLIPS_OCF
OCF_OCF
OCF_CRYPTODEV
OCF_RANDOMHARVEST
OCF_CRYPTOSOFT
OCF_HIFN
</pre>
<P>Be careful; the following config options should be set to "N":OCF_FIPS, OCF_HIFN_PKMMAP, OCF_HIFN_DEBUG_COUNTERS, OCF_HIFNHIPP, OCF_BENCH, OCF_PROFILE (that's their default anyways).
<LI>In the resulting .config file, make sure CONFIG_LOCALVERSION_AUTO is NOT set:
<PRE>
grep CONFIG_LOCALVERSION_AUTO .config
</PRE>
<LI>Edit the .config file and change the content of the CONFIG_LOCALVERSION setting:
<PRE>
CONFIG_LOCALVERSION=""
</PRE>
to
<PRE>
CONFIG_LOCALVERSION="-ocf"
</PRE>
<LI>We have to set XFS off, since it prevents the kernel compile from completing.  Edit .config and change:
<PRE>
CONFIG_XFS_FS=y
</PRE>
to
<PRE>
CONFIG_XFS_FS=n
</PRE>
<LI>Compile the kernel:
<PRE>
make
</PRE>
<h2>Installing the Linux OCF Kernel</h2>
<LI>su - root
<LI>cd ~(user)/linux-ocf-v3.0.06
<LI>make modules_install
<LI>cp arch/i386/boot/bzImage /boot/vmlinuz-2.6.18-ocf
<LI>cp .config /boot/config-2.6.18-ocf
<LI>cp System.map /boot/System.map-2.6.18-ocf
<LI>/sbin/mkinitrd /boot/initrd-2.6.18-ocf.img 2.6.18-ocf
<LI>edit /etc/grub.conf and add a menu item, before any other items:
<pre>
title           OCF Linux, kernel 2.6.18-ocf
root            (hd0,0)
kernel          /vmlinuz-2.6.18-ocf root=/dev/VolGroup00/LogVol00 ro 
initrd          /initrd-2.6.18-ocf.img
</pre>
<LI>reboot
<LI>Select the OCF Kernel in the grub menu.
<LI>Login and verify that /dev/crypto exists. This should have been created
by the OCF and udev code. You do not need to manually mknod it. If at some
point it has vanished, it means the OCF kernel code crashed.
<H2>Configure and compile Openswan</H2>
<LI>Login as (user) and get openswan from the FTP site:
<pre>
cd \$HOME
(Now copy the file openswan-v3.0.04.tgz that you downloaded from Hifn earlier, and then:)
tar -xzvf openswan-v3.0.04.tgz
cd openswan-v3.0.04
</PRE>
<LI>Now compile Openswan:
<PRE>
make programs
</pre>
<LI>Switch to root and install Openswan:
<pre>
su root
make install
</pre>
<H2>Post install tuning</H2>
<LI>Go to root's \$HOME directory and edit the .bash_profile of root account and make sure ipsec executable is in PATH; replace:
<PRE>
PATH=\$PATH:\$HOME/bin
</PRE>
with
<PRE>
PATH=\$PATH:\$HOME/bin:/usr/local/sbin
</PRE>
</OL>
<H2>One last thing:</H2>
<P>The version 3.0.06 of Linux OCF is an internal numbering, so you are not actually getting a "Linux version 3" or anything.  We will be packaging the KLIPS code as part of Openswan itself, so that when you install Openswan, you will also install the proper KLIPS patches to go with <b>your</b> Linux kernel. That will happen Real Soon Now.</P>
<P>Also be aware that this version of Linux OCF default to a rather high level of debugging, and this will slow down your machine and performance tests.  Each time the machine reboots, the following command has to run in order to disable this level of debugging:
<pre>
echo "0" &gt; /sys/module/ocf/parameters/crypto_proc_debug
</pre>

EOF1;

table("3576BA","home","","right","","$content");

pagefooter("3576BA","home");

?>
