<?php

include("../style.php");

$color = "3576BA";

pageheader("$color",2,"Milestone 1: OCF Kernel Build + Installation");

$content =  <<<EOF1


<ol><h2>Building the latest version of OCF kernel</h2>
<LI>As a regular user, scp #ocf from hifn.xelerance.com : 
<pre>
cd \$HOME
scp <user>@hifn.xelerance.com:/hifn/MASTER/files/linux-2.6-ocf-eac12a.tgz .
tar -xzvf linux-2.6-ocf-eac12a.tgz
cd linux-ocf-eac12a
cp /boot/config-`uname -r` .config
make oldconfig
</pre>
<LI>Configure the Kernel: 
<pre>
# Answer "y" to the following items, for all others, just use the default:
KLIPS26
KLIPS_OCF
OCF_OCF
OCF_CRYPTODEV
OCF_HIFN
</pre>
<LI>Make sure CONFIG_OCF_CRYPTOSOFT is NOT set (grep CONFIG_OCF_CRYPTOSOFT .config)
<LI>Make sure CONFIG_LOCALVERSION_AUTO is NOT set (grep CONFIG_LOCALVERSION_AUTO .config)
<LI>Change the content of the CONFIG_LOCALVERSION setting:
<PRE>
CONFIG_LOCALVERSION=""
</PRE>
to
<PRE>
CONFIG_LOCALVERSION="-ocf"
</PRE>
<LI>We have to set XFS off, since it prevents the kernel compile from completing.  Edit .config and set:
<PRE>
CONFIG_XFS_FS=n
</PRE>
<LI>For extra debug, edit crypto/ocf/cryptodev.c and change:
<PRE>
	static int debug = 0;
</PRE>
to
<PRE>
	static int debug = 1;
</PRE>
<b>Note: This will enable LOTS of debugging. Only use when problems are found. It will likely render any benchmarking numbers completely useless!</B>
<LI>make bzImage modules
</OL>

<OL><h2>Installing the latest OCF Kernel</h2>
<LI>su - root
<LI>cd ~(user)/linux-2.6-ocf-eac12a
<LI>make modules_install
<LI>mount /boot
<LI>cp arch/i386/boot/bzImage /boot/vmlinuz-2.6.16.18-ocf
<LI>cp .config /boot/config-2.6.16.18-ocf
<LI>cp System.map /boot/System.map-2.6.16.18-ocf
<LI>/sbin/mkinitrd /boot/initrd-2.6.16.18-ocf.img 2.6.16.18-ocf
<LI>edit /etc/grub.conf and add a menu item, before any other items:
<pre>
title           OCF Linux, kernel 2.6.16.18-ocf
root            (hd0,0)
kernel          /vmlinuz-2.6.16.18-ocf root=/dev/VolGroup00/LogVol00 ro 
initrd          /initrd-2.6.16.18-ocf.img
</pre>
<LI>reboot
<LI>Select the OCF Kernel in the grub menu.
<LI>Login and verify that /dev/crypto exists. This should have been created
by the OCF and udev code. You do not need to manually mknod it. If at some
point it has vanished, it means the OCF kernel code crashed.
</OL>
EOF1;

table("3576BA","home","","right","","$content");

pagefooter("3576BA","home");

?>


