<?php

include("../style.php");

$color = "3576BA";

pageheader("$color",3,"Milestone 2: Manual IPSec Setup");

$content =  <<<EOF1

<OL><H2>Configuring Manual IPSec Keying</H2>
<LI>Login as root on SUT3
<LI>On SUT3, create a file called <B>tunnel.sh</B> and put the following in it:
<pre>
setkey -FP
setkey -F
export SUT3=172.18.20.33
export SUT7=172.18.20.77
export SUT3KEY=0x0123456789abcdef02468ace13579bdf123456789abcdef0
export SUT7KEY=0x0123456789abcdef02468ace13579bdf123456789abcdef0
export SUT3AUTH=0x123456789abcdef02468ace013579bdf
export SUT7AUTH=0x123456789abcdef02468ace013579bdf
setkey -c << EOF
add \$SUT3 \$SUT7 esp 0x100
        -m transport
        -E 3des-cbc \$SUT7KEY
        -A hmac-md5 \$SUT7AUTH ;
add \$SUT7 \$SUT3 esp 0x101
        -m transport
        -E 3des-cbc \$SUT3KEY
        -A hmac-md5 \$SUT3AUTH ;
spdadd \$SUT3/32[any] \$SUT7/32[any] any -P out ipsec
        esp/transport/\$SUT3-\$SUT7/require ;
EOF
</pre>
<LI>Login as root on SUT7
<LI>On SUT7, create a file called <B>tunnel.sh</B> and put the following in it:
<pre>
setkey -FP
setkey -F
export SUT3=172.18.20.33
export SUT7=172.18.20.77
export SUT3KEY=0x0123456789abcdef02468ace13579bdf123456789abcdef0
export SUT7KEY=0x0123456789abcdef02468ace13579bdf123456789abcdef0
export SUT3AUTH=0x123456789abcdef02468ace013579bdf
export SUT7AUTH=0x123456789abcdef02468ace013579bdf
setkey -c << EOF
add \$SUT3 \$SUT7 esp 0x100
        -m transport
        -E 3des-cbc \$SUT7KEY
        -A hmac-md5 \$SUT7AUTH ;
add \$SUT7 \$SUT3 esp 0x101
        -m transport
        -E 3des-cbc \$SUT3KEY
        -A hmac-md5 \$SUT3AUTH ;
spdadd \$SUT7/32[any] \$SUT3/32[any] any -P out ipsec
        esp/transport/\$SUT7-\$SUT3/require ;
EOF
</pre>
<LI>On SUT3, login as root
<LI>On SUT3, start the end of the tunnel by doing <B>sh ./tunnel.sh</B>
<LI>On SUT7, login as root
<LI>On SUT7, start the end of the tunnel by doing <B>sh ./tunnel.sh</B>
</OL>
<P>Testing the tunnel
<OL>
<LI>Login as root on SUT3
<LI>Run:
<PRE>
tcpdump -n -i em0
</PRE>
<LI>Login as root on SUT7
<LI>Run:
<pre>
ping 172.18.20.33
</PRE>
<P>In the <B>tcpdump</b> window, you should see only ESP packets flow, and not ICMP packets.
</OL>

<OL><H2>Testing the card with manually keyed IPsec</H2>
We use the flood parameter of the ping command to send as many packets as possible in a short amount of time.  We don't even care if we get many responses back. As long as we get one ping packet back out of 
the whole bunch that we send out, then we know the link is good.
<LI>Login as root on SUT7
<LI>Run:
<PRE>
time ping -c 100000 -l 100000 -s 1400 -f 172.18.20.33
</PRE>
<P> The important part is the CPU percentage.  Without the card, the cpu percentage will be around 65%+, while with the card it will be hard to reach 9% CPU.
</OL>


EOF1;

table("3576BA","home","","right","","$content");

pagefooter("3576BA","home");

?>

