package req IxTclVpn

# Utility procedures
source SampleUtil.tcl


proc setConfigs { clientId } {

############# Chassis and port config #############
if { [catch { ixvpn::portGroup setDefault }] != 0} { handleProcError "setDefault" }
if { [catch { ixvpn::portGroup configure -dutPortId "SUT4 (172.18.50.44)" }] != 0 } { handleAttrError "dutPortId" }
if { [catch { ixvpn::portGroup configure -ixPortId "172.18.10.185:14:01" }] != 0 } { handleAttrError "dutPortId" }
if { [catch { ixvpn::portGroup configure -direction 1 }] != 0 } { handleAttrError "direction" }
ixvpn::portGroup add
if { [catch { ixvpn::portGroup configure -dutPortId "SUT4 (172.18.50.44)" }] != 0 } { handleAttrError "dutPortId" }
if { [catch { ixvpn::portGroup configure -ixPortId "172.18.10.185:14:02" }] != 0 } { handleAttrError "dutPortId" }
if { [catch { ixvpn::portGroup configure -direction 2 }] != 0 } { handleAttrError "direction" }
ixvpn::portGroup add

############# DUT config #############
if { [catch { ixvpn::dutGroup setDefault }] != 0} { handleProcError "setDefault" }
if { [catch { ixvpn::dutGroup configure -dutName "SUT4" }] != 0 } { handleAttrError "name" }
if { [catch { ixvpn::dutGroup configure -description "" }] != 0 } { handleAttrError "description" }
if { [catch { ixvpn::dutGroup configure -bDMVPNHub 0 }] != 0 } { handleAttrError "bDMVPNHub" }
if { [catch { ixvpn::dutGroup configure -DMVPNmGREAddress "" }] != 0 } { handleAttrError "DMVPNmGREAddress" }
if { [catch { ixvpn::dutGroup configure -publicPortIpAddress "172.18.50.44" }] != 0 } { handleAttrError "publicPortIpAddress" }
if { [catch { ixvpn::dutGroup configure -publicIPAddrType 0 }] != 0 } { handleAttrError "publicIPAddrType" }
if { [catch { ixvpn::dutGroup configure -usePublicMacAddr 0 }] != 0 } { handleAttrError "usePublicMacAddr" }
if { [catch { ixvpn::dutGroup configure -publicPortMACAddress "" }] != 0 } { handleAttrError "publicPortMACAddress" }
if { [catch { ixvpn::dutGroup configure -privatePortIpAddress "172.18.60.44" }] != 0 } { handleAttrError "privatePortIpAddress" }
if { [catch { ixvpn::dutGroup configure -privateIPAddrType 0 }] != 0 } { handleAttrError "privateIPAddrType" }
if { [catch { ixvpn::dutGroup configure -usePrivateMacAddr 0 }] != 0 } { handleAttrError "usePrivateMacAddr" }
if { [catch { ixvpn::dutGroup configure -privatePortMACAddress "" }] != 0 } { handleAttrError "privatePortMACAddress" }
ixvpn::dutGroup add

################ IPSEC configs ####################
if { [catch { ixvpn::ipsec setDefault }] != 0} { handleProcError "setDefault" }

############# Test-wide common configs ##############
if { [catch { ixvpn::ipsec configure -testName "d1-acc1.3a-algo-matrix-254-esp" }] != 0 } { handleAttrError "testName" }
if { [catch { ixvpn::ipsec configure -userName "wyt-ixvpn" }] != 0 } { handleAttrError "userName" }
if { [catch { ixvpn::ipsec configure -pcpuOwnerName "wyt-ixvpn" }] != 0 } { handleAttrError "pcpuOwnerName" }
if { [catch { ixvpn::ipsec configure -portToPortOnly 0 }] != 0 } { handleAttrError "portToPortOnly" }
if { [catch { ixvpn::ipsec configure -leaveSetupStateOptions 1 }] != 0 } { handleAttrError "leaveSetupStateOptions" }
if { [catch { ixvpn::ipsec configure -resetPcpus 0 }] != 0 } { handleAttrError "resetPcpus" }
if { [catch { ixvpn::ipsec configure -connectivityTestFailOption 0 }] != 0 } { handleAttrError "connectivityTestFailOption" }
if { [catch { ixvpn::ipsec configure -messageLogLevel 2 }] != 0 } { handleAttrError "messageLogLevel" }
if { [catch { ixvpn::ipsec configure -plutoDebugLogging 1 }] != 0 } { handleAttrError "plutoDebugLogging" }

############# Phase 1 configs ##############
if { [catch { ixvpn::ipsec configure -preSharedKey "123456" }] != 0 } { handleAttrError "preSharedKey" }
if { [catch { ixvpn::ipsec configure -mainMode 50 }] != 0 } { handleAttrError "mainMode" }
if { [catch { ixvpn::ipsec configure -aggrMode 50 }] != 0 } { handleAttrError "aggrMode" }
if { [catch { ixvpn::ipsec configure -phase1hashMd5 50 }] != 0 } { handleAttrError "phase1hashMd5" }
if { [catch { ixvpn::ipsec configure -phase1hashSha1 50 }] != 0 } { handleAttrError "phase1hashSha1" }
if { [catch { ixvpn::ipsec configure -phase1nullEncrypt 0 }] != 0 } { handleAttrError "phase1nullEncrypt" }
if { [catch { ixvpn::ipsec configure -phase1des 0 }] != 0 } { handleAttrError "phase1des" }
if { [catch { ixvpn::ipsec configure -phase1enc3des 25 }] != 0 } { handleAttrError "phase1enc3des" }
if { [catch { ixvpn::ipsec configure -phase1encAes128 25 }] != 0 } { handleAttrError "phase1encAes128" }
if { [catch { ixvpn::ipsec configure -phase1encAes192 25 }] != 0 } { handleAttrError "phase1encAes192" }
if { [catch { ixvpn::ipsec configure -phase1encAes256 25 }] != 0 } { handleAttrError "phase1encAes256" }
if { [catch { ixvpn::ipsec configure -phase1dh1 0 }] != 0 } { handleAttrError "phase1dh1" }
if { [catch { ixvpn::ipsec configure -phase1dh2 25 }] != 0 } { handleAttrError "phase1dh2" }
if { [catch { ixvpn::ipsec configure -phase1dh5 50 }] != 0 } { handleAttrError "phase1dh5" }
if { [catch { ixvpn::ipsec configure -phase1dh14 25 }] != 0 } { handleAttrError "phase1dh14" }
if { [catch { ixvpn::ipsec configure -phase1dh15 0 }] != 0 } { handleAttrError "phase1dh15" }
if { [catch { ixvpn::ipsec configure -phase1dh16 0 }] != 0 } { handleAttrError "phase1dh16" }
if { [catch { ixvpn::ipsec configure -phase1lifeTime 3600 }] != 0 } { handleAttrError "phase1lifeTime" }
if { [catch { ixvpn::ipsec configure -ikePort 500 }] != 0 } { handleAttrError "ikePort" }
if { [catch { ixvpn::ipsec configure -CAURL "" }] != 0 } { handleAttrError "CAURL" }
if { [catch { ixvpn::ipsec configure -peersCAContextId "" }] != 0 } { handleAttrError "peersCAContextId" }
if { [catch { ixvpn::ipsec configure -peersCAName "" }] != 0 } { handleAttrError "peersCAName" }
if { [catch { ixvpn::ipsec configure -bitSizeForKey 512 }] != 0 } { handleAttrError "bitSizeForKey" }
if { [catch { ixvpn::ipsec configure -algoForKey 1 }] != 0 } { handleAttrError "algoForKey" }
if { [catch { ixvpn::ipsec configure -authMethod 0 }] != 0 } { handleAttrError "authMethod" }
if { [catch { ixvpn::ipsec configure -uniqueCAKeyPerTunnel 1 }] != 0 } { handleAttrError "uniqueCAKeyPerTunnel" }
if { [catch { ixvpn::ipsec configure -enableXAuth 0 }] != 0 } { handleAttrError "enableXAuth" }
if { [catch { ixvpn::ipsec configure -enableXAuthUserGroup 0 }] != 0 } { handleAttrError "enableXAuthUserGroup" }
if { [catch { ixvpn::ipsec configure -xAuthPassword "" }] != 0 } { handleAttrError "xAuthPassword" }
if { [catch { ixvpn::ipsec configure -xAuthUserName "" }] != 0 } { handleAttrError "xAuthUserName" }
if { [catch { ixvpn::ipsec configure -bModeCfgEnabled 0 }] != 0 } { handleAttrError "bModeCfgEnabled" }
if { [catch { ixvpn::ipsec configure -modeCfgMode 0 }] != 0 } { handleAttrError "modeCfgMode" }
if { [catch { ixvpn::ipsec configure -userGroupList "" }] != 0 } { handleAttrError "userGroupList" }
if { [catch { ixvpn::ipsec configure -numUserGroups 0 }] != 0 } { handleAttrError "numUserGroups" }

############# Phase 2 configs ##############
if { [catch { ixvpn::ipsec configure -IKEMode 0 }] != 0 } { handleAttrError "IKEMode" }
if { [catch { ixvpn::ipsec configure -AHOnly 0 }] != 0 } { handleAttrError "AHOnly" }
if { [catch { ixvpn::ipsec configure -ESPOnly 100 }] != 0 } { handleAttrError "ESPOnly" }
if { [catch { ixvpn::ipsec configure -AHnESP 0 }] != 0 } { handleAttrError "AHnESP" }
if { [catch { ixvpn::ipsec configure -tunnelMode 100 }] != 0 } { handleAttrError "tunnelMode" }
if { [catch { ixvpn::ipsec configure -transportMode 0 }] != 0 } { handleAttrError "transportMode" }
if { [catch { ixvpn::ipsec configure -phase2hashMd5 50 }] != 0 } { handleAttrError "phase2hashMd5" }
if { [catch { ixvpn::ipsec configure -phase2hashSha1 50 }] != 0 } { handleAttrError "phase2hashSha1" }
if { [catch { ixvpn::ipsec configure -phase2nullEncrypt 0 }] != 0 } { handleAttrError "phase2nullEncrypt" }
if { [catch { ixvpn::ipsec configure -phase2des 0 }] != 0 } { handleAttrError "phase2des" }
if { [catch { ixvpn::ipsec configure -phase2enc3des 25 }] != 0 } { handleAttrError "phase2enc3des" }
if { [catch { ixvpn::ipsec configure -phase2encAes128 25 }] != 0 } { handleAttrError "phase2encAes128" }
if { [catch { ixvpn::ipsec configure -phase2encAes192 25 }] != 0 } { handleAttrError "phase2encAes192" }
if { [catch { ixvpn::ipsec configure -phase2encAes256 25 }] != 0 } { handleAttrError "phase2encAes256" }
if { [catch { ixvpn::ipsec configure -phase2dh1 0 }] != 0 } { handleAttrError "phase2dh1" }
if { [catch { ixvpn::ipsec configure -phase2dh2 0 }] != 0 } { handleAttrError "phase2dh2" }
if { [catch { ixvpn::ipsec configure -phase2dh5 100 }] != 0 } { handleAttrError "phase2dh5" }
if { [catch { ixvpn::ipsec configure -phase2dh14 0 }] != 0 } { handleAttrError "phase2dh14" }
if { [catch { ixvpn::ipsec configure -phase2dh15 0 }] != 0 } { handleAttrError "phase2dh15" }
if { [catch { ixvpn::ipsec configure -phase2dh16 0 }] != 0 } { handleAttrError "phase2dh16" }
if { [catch { ixvpn::ipsec configure -phase2lifeTime 28800 }] != 0 } { handleAttrError "phase2lifeTime" }
if { [catch { ixvpn::ipsec configure -PFS 0 }] != 0 } { handleAttrError "PFS" }
if { [catch { ixvpn::ipsec configure -useCompression 0 }] != 0 } { handleAttrError "useCompression" }
if { [catch { ixvpn::ipsec configure -enableNATT 0 }] != 0 } { handleAttrError "enableNATT" }

############# Rekey/retry and IKE configs ##############
if { [catch { ixvpn::ipsec configure -dontRekey 1 }] != 0 } { handleAttrError "dontRekey" }
if { [catch { ixvpn::ipsec configure -keyingRetries 0 }] != 0 } { handleAttrError "keyingRetries" }
if { [catch { ixvpn::ipsec configure -reKeyFuzz 0 }] != 0 } { handleAttrError "reKeyFuzz" }
if { [catch { ixvpn::ipsec configure -reKeyMargin 0 }] != 0 } { handleAttrError "reKeyMargin" }
if { [catch { ixvpn::ipsec configure -useDuration 0 }] != 0 } { handleAttrError "useDuration" }
if { [catch { ixvpn::ipsec configure -reKeyDuration 0 }] != 0 } { handleAttrError "reKeyDuration" }
if { [catch { ixvpn::ipsec configure -numTunnelRetries 0 }] != 0 } { handleAttrError "numTunnelRetries" }
if { [catch { ixvpn::ipsec configure -reKeyCount 0 }] != 0 } { handleAttrError "reKeyCount" }
if { [catch { ixvpn::ipsec configure -retryStartValue 0 }] != 0 } { handleAttrError "retryStartValue" }
if { [catch { ixvpn::ipsec configure -retryIncrementValue 0 }] != 0 } { handleAttrError "retryIncrementValue" }
if { [catch { ixvpn::ipsec configure -IKEType 0 }] != 0 } { handleAttrError "IKEType" }
if { [catch { ixvpn::ipsec configure -manualIKEConfigFileName "C:/Program Files/Ixia/IxVPN/config/IxVpnSampleManualKeyConfig.csv" }] != 0 } { handleAttrError "manualIKEConfigFileName" }
if { [catch { ixvpn::ipsec configure -customIkeName 1 }] != 0 } { handleAttrError "customIkeName" }
if { [catch { ixvpn::ipsec configure -bUseOneCert 0 }] != 0 } { handleAttrError "bUseOneCert" }
if { [catch { ixvpn::ipsec configure -bGetNewCerts 1 }] != 0 } { handleAttrError "bGetNewCerts" }
if { [catch { ixvpn::ipsec configure -bCacheNewCerts 1 }] != 0 } { handleAttrError "bCacheNewCerts" }
if { [catch { ixvpn::ipsec configure -certSource "" }] != 0 } { handleAttrError "certSource" }

############# Control plane configs ##############
if { [catch { ixvpn::ipsec configure -runCapacityTest 1 }] != 0 } { handleAttrError "runCapacityTest" }
if { [catch { ixvpn::ipsec configure -runRateTest 1 }] != 0 } { handleAttrError "runRateTest" }
if { [catch { ixvpn::ipsec configure -runDPFLTest 0 }] != 0 } { handleAttrError "runDPFLTest" }
if { [catch { ixvpn::ipsec configure -runDPTPTest 0 }] != 0 } { handleAttrError "runDPTPTest" }
if { [catch { ixvpn::ipsec configure -runDPLatTest 0 }] != 0 } { handleAttrError "runDPLatTest" }
if { [catch { ixvpn::ipsec configure -runSDPTest 1 }] != 0 } { handleAttrError "runSDPTest" }
if { [catch { ixvpn::ipsec configure -runDuplexTrafficSDP 0 }] != 0 } { handleAttrError "runDuplexTrafficSDP" }
if { [catch { ixvpn::ipsec configure -runDuplexTrafficRFC2544 0 }] != 0 } { handleAttrError "runDuplexTrafficRFC2544" }
if { [catch { ixvpn::ipsec configure -numP1SA 254 }] != 0 } { handleAttrError "numP1SA" }
if { [catch { ixvpn::ipsec configure -numP2SA 2 }] != 0 } { handleAttrError "numP2SA" }
if { [catch { ixvpn::ipsec configure -useMultiP2PerP1 0 }] != 0 } { handleAttrError "useMultiP2PerP1" }
if { [catch { ixvpn::ipsec configure -numIterations 1 }] != 0 } { handleAttrError "numIterations" }
if { [catch { ixvpn::ipsec configure -startNumTunnels 1 }] != 0 } { handleAttrError "startNumTunnels" }
if { [catch { ixvpn::ipsec configure -numTunnelIncrement 0 }] != 0 } { handleAttrError "numTunnelIncrement" }
if { [catch { ixvpn::ipsec configure -maxNumTunnels 254 }] != 0 } { handleAttrError "maxNumTunnels" }
if { [catch { ixvpn::ipsec configure -enableDPD 0 }] != 0 } { handleAttrError "enableDPD" }
if { [catch { ixvpn::ipsec configure -DPDIdlePeriod 1000 }] != 0 } { handleAttrError "DPDIdlePeriod" }
if { [catch { ixvpn::ipsec configure -DPDTimeout 120 }] != 0 } { handleAttrError "DPDTimeout" }
if { [catch { ixvpn::ipsec configure -tunnelTeardownCount 1 }] != 0 } { handleAttrError "teardownCount" }
if { [catch { ixvpn::ipsec configure -tunnelSetupTimeOut 30 }] != 0 } { handleAttrError "tunnelSetupTimeOut" }
if { [catch { ixvpn::ipsec configure -failThresholdPercentage 3.150000 }] != 0 } { handleAttrError "failThresholdPercentage" }

############# Data plane configs ##############
if { [catch { ixvpn::ipsec configure -numConnectionEndpointsRFC2544 1 }] != 0 } { handleAttrError "numConnectionEndpointsRFC2544" }
if { [catch { ixvpn::ipsec configure -protocolTypeRFC2544 0 }] != 0 } { handleAttrError "protocolTypeRFC2544" }
if { [catch { ixvpn::ipsec configure -trafficPortNumberRFC2544 7 }] != 0 } { handleAttrError "trafficPortNumberRFC2544" }
if { [catch { ixvpn::ipsec configure -numSamplePointsRFC2544 10 }] != 0 } { handleAttrError "numSamplePointsRFC2544" }
if { [catch { ixvpn::ipsec configure -bestPossibleRateRFC2544 0 }] != 0 } { handleAttrError "bestPossibleRateRFC2544" }
if { [catch { ixvpn::ipsec configure -frameSizeStartValueRFC2544 64 }] != 0 } { handleAttrError "frameSizeStartValueRFC2544" }
if { [catch { ixvpn::ipsec configure -frameSizeEndValueRFC2544 1360 }] != 0 } { handleAttrError "frameSizeEndValueRFC2544" }
if { [catch { ixvpn::ipsec configure -frameSizeIncrementValueRFC2544 64 }] != 0 } { handleAttrError "frameSizeIncrementValueRFC2544" }
if { [catch { ixvpn::ipsec configure -dpTestDurationRFC2544 "00:10" }] != 0 } { handleAttrError "dpTestDurationRFC2544" }
if { [catch { ixvpn::ipsec configure -maxRateLimitRFC2544 1000.000000 }] != 0 } { handleAttrError "maxRateLimitRFC2544" }
if { [catch { ixvpn::ipsec configure -frameSizeOptionEnumRFC2544 0 }] != 0 } { handleAttrError "frameSizeOptionEnumRFC2544" }
if { [catch { ixvpn::ipsec configure -frameSizeListRFC2544 "64, 128, 256, 512, 1024, 1280, 1424" }] != 0 } { handleAttrError "frameSizeListRFC2544" }
if { [catch { ixvpn::ipsec configure -imixWeightListRFC2544 "" }] != 0 } { handleAttrError "imixWeightListRFC2544" }
if { [catch { ixvpn::ipsec configure -numConnectionEndpointsSDP 254 }] != 0 } { handleAttrError "numConnectionEndpointsSDP" }
if { [catch { ixvpn::ipsec configure -protocolTypeSDP 0 }] != 0 } { handleAttrError "protocolTypeSDP" }
if { [catch { ixvpn::ipsec configure -trafficPortNumberSDP 7 }] != 0 } { handleAttrError "trafficPortNumberSDP" }
if { [catch { ixvpn::ipsec configure -frameSizeStartValueSDP 64 }] != 0 } { handleAttrError "frameSizeStartValueSDP" }
if { [catch { ixvpn::ipsec configure -frameSizeEndValueSDP 1360 }] != 0 } { handleAttrError "frameSizeEndValueSDP" }
if { [catch { ixvpn::ipsec configure -frameSizeIncrementValueSDP 64 }] != 0 } { handleAttrError "frameSizeIncrementValueSDP" }
if { [catch { ixvpn::ipsec configure -dpTestDurationSDP "00:10:00" }] != 0 } { handleAttrError "dpTestDurationSDP" }
if { [catch { ixvpn::ipsec configure -maxRateLimitSDP 100.000000 }] != 0 } { handleAttrError "maxRateLimitSDP" }
if { [catch { ixvpn::ipsec configure -frameSizeOptionEnumSDP 0 }] != 0 } { handleAttrError "frameSizeOptionEnumSDP" }
if { [catch { ixvpn::ipsec configure -frameSizeListSDP "64, 128, 256, 512, 1024, 1280, 1424" }] != 0 } { handleAttrError "frameSizeListSDP" }
if { [catch { ixvpn::ipsec configure -imixWeightListSDP "" }] != 0 } { handleAttrError "imixWeightListSDP" }

############# DMVPN configs ##############
if { [catch { ixvpn::ipsec configure -trafficPacketSize 256 }] != 0 } { handleAttrError "trafficPacketSize" }
if { [catch { ixvpn::ipsec configure -trafficRate 2.000000 }] != 0 } { handleAttrError "trafficRate" }
if { [catch { ixvpn::ipsec configure -bgpLocalASNumber 10 }] != 0 } { handleAttrError "bgpLocalASNumber" }
if { [catch { ixvpn::ipsec configure -nhrpNetworkID 10 }] != 0 } { handleAttrError "nhrpNetworkID" }
if { [catch { ixvpn::ipsec configure -nhrpHoldTime 7200 }] != 0 } { handleAttrError "nhrpHoldTime" }
if { [catch { ixvpn::ipsec configure -nhrpMaxRetryCount 10 }] != 0 } { handleAttrError "nhrpMaxRetryCount" }
if { [catch { ixvpn::ipsec configure -nhrpRetryInterval 2 }] != 0 } { handleAttrError "nhrpRetryInterval" }
if { [catch { ixvpn::ipsec configure -enableGREKey 0 }] != 0 } { handleAttrError "enableGREKey" }
if { [catch { ixvpn::ipsec configure -GREKey 99 }] != 0 } { handleAttrError "GREKey" }

############# Network configs ##############
if { [catch { ixvpn::ipsec configure -seedFQDNInitiator "" }] != 0 } { handleAttrError "seedFQDNInitiator" }
if { [catch { ixvpn::ipsec configure -seedFQDNResponder "" }] != 0 } { handleAttrError "seedFQDNResponder" }
if { [catch { ixvpn::ipsec configure -seedEGIP "50.0.0.1" }] != 0 } { handleAttrError "seedEGIP" }
if { [catch { ixvpn::ipsec configure -EGIPIncrementOctet 4 }] != 0 } { handleAttrError "EGIPIncrementOctet" }
if { [catch { ixvpn::ipsec configure -EGIPMaskWidth 24 }] != 0 } { handleAttrError "EGIPMaskWidth" }
if { [catch { ixvpn::ipsec configure -EGIPAddressType 0 }] != 0 } { handleAttrError "EGIPAddressType" }
if { [catch { ixvpn::ipsec configure -seedPHIP "60.0.0.1" }] != 0 } { handleAttrError "seedPHIP" }
if { [catch { ixvpn::ipsec configure -PHIPIncrementOctet 4 }] != 0 } { handleAttrError "PHIPIncrementOctet" }
if { [catch { ixvpn::ipsec configure -PHIPMaskWidth 24 }] != 0 } { handleAttrError "PHIPMaskWidth" }
if { [catch { ixvpn::ipsec configure -PHIPAddressType 0 }] != 0 } { handleAttrError "PHIPAddressType" }
if { [catch { ixvpn::ipsec configure -ipsecIDTypeResponder 1 }] != 0 } { handleAttrError "ipsecIDTypeResponder" }
if { [catch { ixvpn::ipsec configure -numHostsInEachPN 4 }] != 0 } { handleAttrError "numHostsInEachPN" }
if { [catch { ixvpn::ipsec configure -bEmulateSubnetInPN 0 }] != 0 } { handleAttrError "bEmulateSubnetInPN" }
if { [catch { ixvpn::ipsec configure -bRIMPresent 0 }] != 0 } { handleAttrError "bRIMPresent" }
if { [catch { ixvpn::ipsec configure -RIMIP "DEFAULT" }] != 0 } { handleAttrError "RIMIP" }
if { [catch { ixvpn::ipsec configure -RIMMaskWidth 24 }] != 0 } { handleAttrError "RIMMaskWidth" }
if { [catch { ixvpn::ipsec configure -bUseRIMMacAddr 0 }] != 0 } { handleAttrError "bUseRIMMacAddr" }
if { [catch { ixvpn::ipsec configure -RIMMacAddr "" }] != 0 } { handleAttrError "RIMMacAddr" }
if { [catch { ixvpn::ipsec configure -RIMIPAddressType 0 }] != 0 } { handleAttrError "RIMIPAddressType" }
if { [catch { ixvpn::ipsec configure -bUseESNBehindEG 1 }] != 0 } { handleAttrError "bUseESNBehindEG" }
if { [catch { ixvpn::ipsec configure -ESNIPMaskWidth 24 }] != 0 } { handleAttrError "ESNIPMaskWidth" }
if { [catch { ixvpn::ipsec configure -seedESNBehindEGIP "70.0.1.1" }] != 0 } { handleAttrError "seedESNBehindEGIP" }
if { [catch { ixvpn::ipsec configure -ESNBehindEGIPIncrementOctet 3 }] != 0 } { handleAttrError "ESNBehindEGIPIncrementOctet" }
if { [catch { ixvpn::ipsec configure -numHostsInEachESNBehindEG 1 }] != 0 } { handleAttrError "numHostsInEachESNBehindEG" }
if { [catch { ixvpn::ipsec configure -ESNBehindEGIPAddressType 0 }] != 0 } { handleAttrError "ESNBehindEGIPAddressType" }
if { [catch { ixvpn::ipsec configure -ipsecIDTypeInitiator 1 }] != 0 } { handleAttrError "ipsecIDTypeInitiator" }
if { [catch { ixvpn::ipsec configure -bUniqueMAC 0 }] != 0 } { handleAttrError "bUniqueMAC" }
if { [catch { ixvpn::ipsec configure -seedEGMAC "00 00 00 00 00 01" }] != 0 } { handleAttrError "seedEGMAC" }
if { [catch { ixvpn::ipsec configure -EGMACIncrementOctet 6 }] != 0 } { handleAttrError "EGMACIncrementOctet" }
if { [catch { ixvpn::ipsec configure -bEnableGRE 0 }] != 0 } { handleAttrError "bEnableGRE" }
if { [catch { ixvpn::ipsec configure -seedGREIPEG "40.0.0.1" }] != 0 } { handleAttrError "seedGREIPEG" }
if { [catch { ixvpn::ipsec configure -seedGREIPDUT "40.0.0.2" }] != 0 } { handleAttrError "seedGREIPDUT" }
if { [catch { ixvpn::ipsec configure -GREIPEGIncrementOctet 4 }] != 0 } { handleAttrError "GREIPEGIncrementOctet" }
if { [catch { ixvpn::ipsec configure -GREIPEGMaskWidth 24 }] != 0 } { handleAttrError "GREIPEGMaskWidth" }
if { [catch { ixvpn::ipsec configure -bEnableVLANEG 0 }] != 0 } { handleAttrError "bEnableVLANEG" }
if { [catch { ixvpn::ipsec configure -numVLANGroupsEG 1 }] != 0 } { handleAttrError "numVLANGroupsEG" }
if { [catch { ixvpn::ipsec configure -vlanIDListEG "" }] != 0 } { handleAttrError "vlanIDListEG" }
if { [catch { ixvpn::ipsec configure -bEnableVLANPH 0 }] != 0 } { handleAttrError "bEnableVLANPH" }
if { [catch { ixvpn::ipsec configure -numVLANGroupsPH 1 }] != 0 } { handleAttrError "numVLANGroupsPH" }
if { [catch { ixvpn::ipsec configure -vlanIDListPH "" }] != 0 } { handleAttrError "vlanIDListPH" }
if { [catch { ixvpn::ipsec configure -publicPortVRIPList "172.18.50.45" }] != 0 } { handleAttrError "publicPortVRIPList" }
if { [catch { ixvpn::ipsec configure -privatePortVRIPList "172.18.60.45" }] != 0 } { handleAttrError "privatePortVRIPList" }
ixvpn::ipsec configure -clientId $clientId
}
# set this to 0 if you don't want to run the script
set autoRun 1
# set this to 1 for windows and 2 for linux/unix client
set clientId 1

if { $autoRun != 0 } {
  # Following is required for UNIX/LINUX clients
  if { [isUNIX] } {
    set clientId 2
    set errMsg 0
    ixVpnUtil::connectToTclServer 172.18.10.185 errMsg
    puts $errMsg
  }

  # this file contains progress msgs
  set logFile [open d1-acc1.3a-algo-matrix-254-esp.log w]
  # this file contains the result test (pass or failed)
  set resultFile [open d1-acc1.3a-algo-matrix-254-esp.out w]

  setConfigs $clientId
  runTest "d1-acc1.3a-algo-matrix-254-esp"

  close $logFile
  close $resultFile
} else {
  puts "Set autoRun to 1 to execute the script"
}

