%define ver 20040619
%define rpmrel 0

%define private_suffix -pcntl

# If/when we find out about RedHat-specific stuff, we can use
# conditional building with a macro like the following to prevent the
# RedHat-specific stuff happening on other distributions
%define redhat %(if [ -f %{_sysconfdir}/redhat-release ]; then echo 1; else echo 0; fi)

Summary:	Point-to-Point Tunneling Protocol (PPTP) Client Configuration GUI
Name:		pptpconfig
Version:	%{ver}
Release:	%{rpmrel}
Source:		http://quozl.netrek.org/pptp/pptpconfig/pptpconfig-%{version}.tar.gz
License:	GPL
Group:		Applications/Internet
Packager: James Cameron <james.cameron@hp.com>
Vendor: Hewlett-Packard
Distribution:	PPTP Client Project
URL:		http://quozl.netrek.org/pptp/pptpconfig/
Requires:	ppp >= 2.4.2, pptp-linux >= 1.2.0, iproute, php-gtk%{private_suffix}, usermode
Buildroot:	%{_tmppath}/%{name}-%{version}-buildroot
Obsoletes:	pptp-php-gtk
BuildArch:	noarch
BuildRequires:	perl

%define private_php_dir %{_libdir}/php%{private_suffix}

%description
Graphical user interface for PPTP Client.
Supports configuration of tunnels, starting, stopping, catching debug
output from pppd, DNS and routing changes.

%prep
%setup -q

%install
# Some directory names hardcoded here because they are hardcoded in the PHP script
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && %{__rm} -rf "$RPM_BUILD_ROOT"
%{__make} bindir=%{_bindir} \
	sbindir=%{_sbindir} \
	sysconfdir=%{_sysconfdir} \
	datadir=%{_datadir} \
	DESTDIR=$RPM_BUILD_ROOT \
	install install-pam

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && %{__rm} -rf "$RPM_BUILD_ROOT"

%post
# Attempt to migrate tunnels from old pptp-php-gtk package
if [ ! -f /etc/pptpconfig/tunnels -a -f /etc/pptp-php-gtk/tunnels ]; then
	cp -p /etc/pptp-php-gtk/tunnels /etc/pptpconfig/tunnels
fi

%files
%defattr(-,root,root)
%dir /etc/pptpconfig
%dir /usr/lib/pptpconfig
%{_bindir}/pptpconfig.php
%{_bindir}/pptpconfig
%{_sbindir}/pptpconfig
%{_sysconfdir}/pam.d/pptpconfig
%{_sysconfdir}/security/console.apps/pptpconfig
%{_datadir}/applications/pptpconfig.desktop
/usr/lib/pptpconfig/pptpconfig.xml
/usr/lib/pptpconfig/*.xpm
%doc AUTHORS COPYING DEVELOPERS NEWS README TODO ChangeLog

%changelog
* Fri Jun 18 2004 James Cameron <james.cameron@hp.com>
- use upstream pptpconfig package

* Thu Jun 17 2004 Paul Howarth <paul@city-fan.org>
- move pptpconfig.pam & pptpconfig.app creation from spec file to patch
- move renaming and editing of files for pptp-php-gtk -> pptpconfig name
  change from install to prep phase
- try to migrate existing tunnel definitions from the old pptp-php-gtk package
- patch Makefile to make it properly usable in the RPM build
- patch Makefile to add install-pam target
- use Makefile for install process

* Tue Jun 15 2004 Paul Howarth <paul@city-fan.org>
- Initial RPM build.
