/*
 *	InEvent.java		2002/11/17
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.core;

/** 
 * The InEvent class is an abstract class representing an event received from a server that can be processed by a UI's Handler.
 * @author Alistair K Phipps
 * @version 2002/11/17
 */
public abstract class InEvent
{
	private Entity _eSource;

	/** Ctor used by subclasses to set source
	 * @param eSource source entity
	 */
	protected InEvent( Entity eSource )
	{
		_eSource = eSource;
	}
	
	/** Retrieve the source entity
	 * @return source entity
	 */
	public Entity getSource()
	{
		return _eSource;
	}
}
