/*
 *	MessageOutEvent.java		2002/11/17
 *	
 *	Copyright (c) 2002 Alistair K Phipps (jsilc@alistairphipps.com).
 *	All rights reserved.
 */

package com.alistairphipps.jsilc.core;

/** 
 * The MessageOutEvent class is an Event describing a message sent from a UI to a Connection.
 * @author Alistair K Phipps
 * @version 2002/11/17
 */
public class MessageOutEvent extends OutEvent
{
	/** message to be sent by the event */
	String _strMessage;
	
	/**
	 * Constructor sets up the source, destination and message
	 * @param eDest destination entity
	 * @param strMessage the message to send
	 */
	public MessageOutEvent( Entity eDest, String strMessage )
	{
		super( eDest );	
		_strMessage = strMessage;
	}

	/** Retrieve the message
	 * @return message text
	 */
	public String getMessage()
	{
		return _strMessage;
	}
}
